/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.registry.service.test;

import com.petalslink.easiersbs.registry.service.api.RegistryException;
import com.petalslink.easiersbs.registry.service.api.SemanticRegistryFactory;
import com.petalslink.easiersbs.registry.service.api.SemanticRegistryManager;
import com.petalslink.easiersbs.registry.service.api.model.Operation;
import com.petalslink.easiersbs.registry.service.api.model.Partner;
import com.petalslink.easiersbs.registry.service.api.model.SemanticElement;
import com.petalslink.easiersbs.registry.service.api.model.SemanticPart;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericElement;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericPart;
import com.petalslink.easiersbs.registry.service.impl.SemanticRegistryFactoryImpl;
import com.petalslink.easiersbs.registry.service.impl.model.OperationImpl;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Set;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Test;

public class RegistryTest {
    private static final String SAWSDL_URL = "services/sawsdl4test.wsdl";
    private static final String WSDL_NS = "http://sawsdl4test";

    @Test
    public void testNewSemanticRegistryManager() {
        SemanticRegistryFactory factory = SemanticRegistryFactoryImpl.getInstance();
        SemanticRegistryManager manager = factory.getSemanticRegistryManager();
        Assert.assertNotNull((Object)manager);
        Set emptyServiceList = manager.getAllTechnicalServices();
        Assert.assertNotNull((Object)emptyServiceList);
        Assert.assertEquals((int)0, (int)emptyServiceList.size());
        Set emptyProfileList = manager.getAllSemanticProfiles();
        Assert.assertNotNull((Object)emptyProfileList);
        Assert.assertEquals((int)0, (int)emptyProfileList.size());
    }

    @Test
    public void testCreateSemanticProfile() throws URISyntaxException {
        SemanticRegistryFactory factory = SemanticRegistryFactoryImpl.getInstance();
        SemanticProfile profile = factory.newSemanticProfile();
        Assert.assertNotNull((Object)profile);
        QName serviceQName = new QName(WSDL_NS, "service0");
        QName operationQName = new QName(WSDL_NS, "operation0");
        OperationImpl operation = new OperationImpl(operationQName, serviceQName);
        profile.addOperation((Operation)operation);
        SemanticPart inter = factory.newSemanticPart();
        URI interConcept = new URI("http://example.org/onto.owl#portType0");
        inter.addSemanticConcept(interConcept);
        profile.setSemanticInterface((GenericPart)inter);
        Assert.assertNotNull((Object)inter);
        Assert.assertEquals((int)1, (int)inter.getSemanticConcepts().size());
        Assert.assertTrue((boolean)((SemanticPart)profile.getSemanticInterface()).getSemanticConcepts().contains(interConcept));
        SemanticPart op = factory.newSemanticPart();
        URI opConcept = new URI("http://example.org/onto.owl#operation0");
        op.addSemanticConcept(opConcept);
        profile.setSemanticOperation((GenericPart)op);
        Assert.assertNotNull((Object)op);
        Assert.assertEquals((int)1, (int)op.getSemanticConcepts().size());
        Assert.assertTrue((boolean)((SemanticPart)profile.getSemanticOperation()).getSemanticConcepts().contains(opConcept));
        SemanticElement input = factory.newSemanticElement();
        URI inputConcept1 = new URI("http://example.org/onto.owl#element0");
        URI inputConcept2 = new URI("http://example.org/onto.owl#type0");
        input.addSemanticConcept(inputConcept1);
        input.addSemanticConcept(inputConcept2);
        profile.setInputSemanticElement((GenericElement)input);
        Assert.assertNotNull((Object)input);
        Assert.assertTrue((boolean)input.isRequired());
        Assert.assertNotNull((Object)profile.getInputSemanticElement());
        Assert.assertNull((Object)input.getElementQName());
        Assert.assertTrue((boolean)input.getSemanticConcepts().contains(inputConcept1));
        Assert.assertTrue((boolean)((SemanticElement)profile.getInputSemanticElement()).getSemanticConcepts().contains(inputConcept2));
        SemanticElement output = factory.newSemanticElement();
        URI outputConcept1 = new URI("http://example.org/onto.owl#element3concept1");
        URI outputConcept2 = new URI("http://example.org/onto.owl#element3concept2");
        output.addSemanticConcept(outputConcept1);
        output.addSemanticConcept(outputConcept1);
        output.addSemanticConcept(outputConcept2);
        profile.setOutputSemanticElement((GenericElement)output);
        Assert.assertNotNull((Object)output);
        Assert.assertTrue((boolean)output.isRequired());
        Assert.assertNotNull((Object)profile.getOutputSemanticElement());
        Assert.assertNull((Object)output.getElementQName());
        Assert.assertTrue((boolean)output.getSemanticConcepts().contains(outputConcept1));
        Assert.assertTrue((boolean)((SemanticElement)profile.getOutputSemanticElement()).getSemanticConcepts().contains(outputConcept2));
        System.out.println(profile);
        SemanticPart temp = factory.newSemanticPart(inter.getSemanticConcepts());
        Assert.assertTrue((boolean)inter.equals(temp));
        temp.removeSemanticConcept(interConcept);
        Assert.assertFalse((boolean)inter.equals(temp));
    }

    @Test
    public void testAddSemanticOperationFromDescription() throws RegistryException {
        URL wsdlUrl = Thread.currentThread().getContextClassLoader().getResource(SAWSDL_URL);
        QName serviceQName = new QName(WSDL_NS, "service0");
        QName operationQName = new QName(WSDL_NS, "operation0");
        OperationImpl operation = new OperationImpl(operationQName, serviceQName);
        SemanticRegistryFactory factory = SemanticRegistryFactoryImpl.getInstance();
        SemanticRegistryManager manager = factory.getSemanticRegistryManager();
        manager.addSemanticService(operationQName, wsdlUrl);
        Assert.assertEquals((int)1, (int)manager.getAllTechnicalServices().size());
        Assert.assertEquals((int)1, (int)manager.getAllSemanticProfiles().size());
        Assert.assertNotNull((Object)manager.getSemanticProfile((Operation)operation));
        Assert.assertNotNull((Object)manager.getTechnicalService(serviceQName));
        manager.removeSemanticService((Operation)operation);
        Assert.assertEquals((int)0, (int)manager.getAllTechnicalServices().size());
        Assert.assertEquals((int)0, (int)manager.getAllSemanticProfiles().size());
    }

    @Test
    public void testAddSemanticService() throws RegistryException {
        URL wsdlUrl = Thread.currentThread().getContextClassLoader().getResource(SAWSDL_URL);
        QName serviceQName = new QName(WSDL_NS, "service0");
        QName operationQName = new QName(WSDL_NS, "operation0");
        OperationImpl operation = new OperationImpl(operationQName, serviceQName);
        SemanticRegistryFactory factory = SemanticRegistryFactoryImpl.getInstance();
        SemanticRegistryManager manager = factory.getSemanticRegistryManager();
        manager.addSemanticServices(wsdlUrl);
        Assert.assertEquals((int)1, (int)manager.getAllTechnicalServices().size());
        Assert.assertEquals((int)2, (int)manager.getAllSemanticProfiles().size());
        Assert.assertNotNull((Object)manager.getSemanticProfile((Operation)operation));
        Assert.assertNotNull((Object)manager.getTechnicalService(serviceQName));
        manager.removeSemanticService((Operation)operation);
        Assert.assertEquals((int)1, (int)manager.getAllTechnicalServices().size());
        Assert.assertEquals((int)1, (int)manager.getAllSemanticProfiles().size());
    }

    @Test
    public void testPartnerSemanticService() throws RegistryException {
        URL wsdlUrl = Thread.currentThread().getContextClassLoader().getResource(SAWSDL_URL);
        QName serviceQName = new QName(WSDL_NS, "service0");
        QName operationQName0 = new QName(WSDL_NS, "operation0");
        QName operationQName1 = new QName(WSDL_NS, "operation1");
        OperationImpl operation0 = new OperationImpl(operationQName0, serviceQName);
        SemanticRegistryFactory factory = SemanticRegistryFactoryImpl.getInstance();
        SemanticRegistryManager manager = factory.getSemanticRegistryManager();
        Partner partner0 = factory.newPartner("partner0");
        manager.addSemanticService(operationQName0, wsdlUrl, partner0);
        Partner partner1 = factory.newPartner("partner1");
        manager.addSemanticService(operationQName1, wsdlUrl, partner1);
        Assert.assertEquals((int)1, (int)manager.getAllTechnicalServices().size());
        Assert.assertEquals((int)2, (int)manager.getAllSemanticProfiles().size());
        Assert.assertEquals((int)1, (int)manager.findSemanticProfilesByPartner(partner0).size());
        Assert.assertEquals((int)1, (int)manager.findSemanticProfilesByPartner(partner1).size());
        Assert.assertNotNull((Object)manager.getSemanticProfile((Operation)operation0));
        Assert.assertNotNull((Object)manager.getTechnicalService(serviceQName));
        manager.removeSemanticProfilesByPartner(partner0);
        Assert.assertNull((Object)manager.findSemanticProfilesByPartner(partner0));
        Assert.assertEquals((int)1, (int)manager.getAllSemanticProfiles().size());
        Assert.assertEquals((int)1, (int)manager.getAllTechnicalServices().size());
        manager.clearRegistry();
        Assert.assertEquals((int)0, (int)manager.getAllTechnicalServices().size());
        Assert.assertEquals((int)0, (int)manager.getAllSemanticProfiles().size());
    }

    @Test
    public void testPartnerMethods() {
        SemanticRegistryFactory factory = SemanticRegistryFactoryImpl.getInstance();
        Partner partner0 = factory.newPartner("partner0");
        Partner partner1 = factory.newPartner("partner1");
        Assert.assertFalse((boolean)partner0.equals(partner1));
        Assert.assertEquals((String)"partner0", (String)partner0.getName());
        Assert.assertEquals((String)"partner0", (String)partner0.toString());
        partner0.setName("partner1");
        Assert.assertTrue((boolean)partner0.equals(partner1));
    }
}

