/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.registry.service.test;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.petalslink.easiersbs.registry.service.api.RegistryException;
import com.petalslink.easiersbs.registry.service.api.model.Operation;
import com.petalslink.easiersbs.registry.service.api.model.SemanticElement;
import com.petalslink.easiersbs.registry.service.api.model.SemanticPart;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericElement;
import com.petalslink.easiersbs.registry.service.impl.model.OperationImpl;
import com.petalslink.easiersbs.registry.service.impl.util.ServiceUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.Service;

public class ServiceUtilTest {
    private static final String SAWSDL_URL = "services/sawsdl4test.wsdl";
    private static final String WSDL_NS = "http://sawsdl4test";
    URL wsdlUrl = Thread.currentThread().getContextClassLoader().getResource("services/sawsdl4test.wsdl");
    Description testDesc = null;

    @Before
    public void setUp() throws RegistryException {
        XmlContextFactory xmlContextFactory = new XmlContextFactory();
        XmlContext xmlContext = xmlContextFactory.newContext();
        XmlObjectReader reader = xmlContext.createReader();
        Definitions def = null;
        try {
            def = (Definitions)reader.readDocument(this.wsdlUrl, Definitions.class);
        }
        catch (XmlObjectReadException e) {
            throw new RegistryException("Impossible to parse WSDL file at " + this.wsdlUrl.toString(), (Exception)((Object)e));
        }
        this.testDesc = (Description)Factory.getInstance().wrap((XmlObject)def);
    }

    @Test
    public void testProfileExtraction() throws URISyntaxException {
        QName operationQName = new QName(WSDL_NS, "operation0");
        SemanticProfile profile = ServiceUtil.extractSemanticProfile((QName)operationQName, (Description)this.testDesc);
        System.out.println(profile);
        QName serviceQName = new QName(WSDL_NS, "service0");
        OperationImpl op = new OperationImpl(operationQName, serviceQName);
        Assert.assertEquals((int)1, (int)profile.getOperations().size());
        Assert.assertEquals((Object)op, profile.getOperations().iterator().next());
        Assert.assertEquals((Object)serviceQName, (Object)((Operation)profile.getOperations().iterator().next()).getServiceQName());
        Assert.assertEquals((Object)operationQName, (Object)((Operation)profile.getOperations().iterator().next()).getOperationQName());
        URI interConcept = new URI("http://example.org/onto.owl#portType0");
        Assert.assertEquals((int)1, (int)((SemanticPart)profile.getSemanticInterface()).getSemanticConcepts().size());
        Assert.assertTrue((boolean)((SemanticPart)profile.getSemanticInterface()).getSemanticConcepts().contains(interConcept));
        URI opConcept = new URI("http://example.org/onto.owl#operation0");
        Assert.assertEquals((int)1, (int)((SemanticPart)profile.getSemanticOperation()).getSemanticConcepts().size());
        Assert.assertTrue((boolean)((SemanticPart)profile.getSemanticOperation()).getSemanticConcepts().contains(opConcept));
        URI inputConcept1 = new URI("http://example.org/onto.owl#element0");
        URI inputConcept2 = new URI("http://example.org/onto.owl#type0");
        QName inputQName = new QName(WSDL_NS, "element0");
        Assert.assertNotNull((Object)profile.getInputSemanticElement());
        Assert.assertEquals((Object)inputQName, (Object)((SemanticElement)profile.getInputSemanticElement()).getElementQName());
        Assert.assertEquals((int)2, (int)((SemanticElement)profile.getInputSemanticElement()).getSemanticConcepts().size());
        Assert.assertTrue((boolean)((SemanticElement)profile.getInputSemanticElement()).getSemanticConcepts().contains(inputConcept1));
        Assert.assertTrue((boolean)((SemanticElement)profile.getInputSemanticElement()).getSemanticConcepts().contains(inputConcept2));
        URI outputConcept1 = new URI("http://example.org/onto.owl#element3concept1");
        URI outputConcept2 = new URI("http://example.org/onto.owl#element3concept2");
        QName outputQName = new QName(WSDL_NS, "element3");
        Assert.assertNotNull((Object)profile.getOutputSemanticElement());
        Assert.assertEquals((Object)outputQName, (Object)((SemanticElement)profile.getOutputSemanticElement()).getElementQName());
        Assert.assertEquals((int)2, (int)((SemanticElement)profile.getOutputSemanticElement()).getSemanticConcepts().size());
        Assert.assertTrue((boolean)((SemanticElement)profile.getOutputSemanticElement()).getSemanticConcepts().contains(outputConcept1));
        Assert.assertTrue((boolean)((SemanticElement)profile.getOutputSemanticElement()).getSemanticConcepts().contains(outputConcept2));
    }

    @Test
    public void testComplexProfileExtraction() throws URISyntaxException {
        QName operationQName = new QName(WSDL_NS, "operation1");
        SemanticProfile profile = ServiceUtil.extractSemanticProfile((QName)operationQName, (Description)this.testDesc);
        System.out.println(profile);
        ArrayList<URI> concepts = new ArrayList<URI>();
        URI inputConcept1 = new URI("http://example.org/onto.owl#element1.0");
        concepts.add(inputConcept1);
        URI inputConcept2 = new URI("http://example.org/onto.owl#element1.0.1");
        concepts.add(inputConcept2);
        URI inputConcept3 = new URI("http://example.org/onto.owl#element1.0.2");
        concepts.add(inputConcept3);
        URI inputConcept4 = new URI("http://example.org/onto.owl#element1.0.3");
        concepts.add(inputConcept4);
        URI inputConcept5 = new URI("http://example.org/onto.owl#element1complex");
        concepts.add(inputConcept5);
        URI inputConcept6 = new URI("http://example.org/onto.owl#element1.3");
        concepts.add(inputConcept6);
        Assert.assertNotNull((Object)profile.getInputSemanticElement());
        Set elements = ServiceUtil.getFlattenElements((GenericElement)profile.getInputSemanticElement());
        Assert.assertEquals((int)6, (int)elements.size());
        Set inputConcepts = ServiceUtil.getFlattenConcepts((Set)elements);
        Assert.assertEquals((int)6, (int)inputConcepts.size());
        Assert.assertTrue((boolean)inputConcepts.containsAll(concepts));
    }

    @Test
    public void testSawsdlTcProfileExtraction() throws URISyntaxException, RegistryException {
        XmlContextFactory xmlContextFactory = new XmlContextFactory();
        XmlContext xmlContext = xmlContextFactory.newContext();
        URL sawsdlTcUrl = Thread.currentThread().getContextClassLoader().getResource("services/book_price_service.wsdl");
        Description sawsdlTcDesc = ServiceUtil.getDescription((URL)sawsdlTcUrl, (XmlContext)xmlContext);
        QName operationQName = ((Interface)sawsdlTcDesc.getInterfaces().get(0)).getOperations()[0].inferQName();
        SemanticProfile profile = ServiceUtil.extractSemanticProfile((QName)operationQName, (Description)sawsdlTcDesc);
        Assert.assertEquals((int)0, (int)((SemanticPart)profile.getSemanticInterface()).getSemanticConcepts().size());
        Assert.assertEquals((int)0, (int)((SemanticPart)profile.getSemanticOperation()).getSemanticConcepts().size());
        Assert.assertEquals((int)7, (int)ServiceUtil.getFlattenElements((GenericElement)profile.getInputSemanticElement()).size());
        Assert.assertEquals((int)3, (int)ServiceUtil.getFlattenElements((GenericElement)profile.getOutputSemanticElement()).size());
    }

    @Test
    public void testSawsdlTcComplexProfileExtraction() throws URISyntaxException, RegistryException {
        XmlContextFactory xmlContextFactory = new XmlContextFactory();
        XmlContext xmlContext = xmlContextFactory.newContext();
        URL sawsdlTcUrl = Thread.currentThread().getContextClassLoader().getResource("services/governmentmissile_financing_service.wsdl");
        Description sawsdlTcDesc = ServiceUtil.getDescription((URL)sawsdlTcUrl, (XmlContext)xmlContext);
        QName operationQName = ((Interface)sawsdlTcDesc.getInterfaces().get(0)).getOperations()[0].inferQName();
        SemanticProfile profile = ServiceUtil.extractSemanticProfile((QName)operationQName, (Description)sawsdlTcDesc);
        Assert.assertEquals((int)0, (int)((SemanticPart)profile.getSemanticInterface()).getSemanticConcepts().size());
        Assert.assertEquals((int)0, (int)((SemanticPart)profile.getSemanticOperation()).getSemanticConcepts().size());
        Assert.assertEquals((int)174, (int)ServiceUtil.getFlattenElements((GenericElement)profile.getInputSemanticElement()).size());
        Assert.assertEquals((int)11, (int)ServiceUtil.getFlattenElements((GenericElement)profile.getOutputSemanticElement()).size());
    }

    @Test
    public void testProfileDestruction() throws URISyntaxException {
        QName operationQName = new QName(WSDL_NS, "operation1");
        QName serviceQName = new QName(WSDL_NS, "service0");
        OperationImpl op = new OperationImpl(operationQName, serviceQName);
        SemanticProfile profile = ServiceUtil.extractSemanticProfile((QName)operationQName, (Description)this.testDesc);
        URI inputConcept1 = new URI("http://example.org/onto.owl#element1complex");
        ((SemanticElement)profile.getInputSemanticElement()).removeSemanticConcept(inputConcept1);
        Assert.assertEquals((int)0, (int)((SemanticElement)profile.getInputSemanticElement()).getSemanticConcepts().size());
        SemanticElement unwantedInput = (SemanticElement)((SemanticElement)profile.getInputSemanticElement()).getChildElements().iterator().next();
        ((SemanticElement)profile.getInputSemanticElement()).removeChildElement((GenericElement)unwantedInput);
        Assert.assertEquals((int)1, (int)((SemanticElement)profile.getInputSemanticElement()).getChildElements().size());
        profile.removeOperation((Operation)op);
        Assert.assertEquals((int)0, (int)profile.getOperations().size());
    }

    @Test
    public void testNavigationMethods() {
        QName operationQName = new QName(WSDL_NS, "operation0");
        QName serviceQName = new QName(WSDL_NS, "service0");
        Set ops = ServiceUtil.getOperations((Description)this.testDesc);
        Assert.assertEquals((int)2, (int)ops.size());
        org.petalslink.abslayer.service.api.Operation op = ServiceUtil.findOperation((QName)operationQName, (Description)this.testDesc);
        Assert.assertNotNull((Object)op);
        Assert.assertEquals((Object)operationQName, (Object)op.inferQName());
        Set ops2 = ServiceUtil.findOperationsByService((QName)serviceQName, (Description)this.testDesc);
        Assert.assertEquals((int)2, (int)ops2.size());
        List serv = ServiceUtil.findServicesByOperation((QName)operationQName, (Description)this.testDesc);
        Assert.assertEquals((int)1, (int)serv.size());
        Assert.assertEquals((Object)serviceQName, (Object)((Service)serv.get(0)).getQName());
    }
}

