/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.registry.service.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.petalslink.easiersbs.registry.service.api.RegistryException;
import com.petalslink.easiersbs.registry.service.api.SemanticRegistryManager;
import com.petalslink.easiersbs.registry.service.api.model.Operation;
import com.petalslink.easiersbs.registry.service.api.model.Partner;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import com.petalslink.easiersbs.registry.service.api.registry.SemanticProfileRegistry;
import com.petalslink.easiersbs.registry.service.api.registry.TechnicalServiceRegistry;
import com.petalslink.easiersbs.registry.service.impl.model.OperationImpl;
import com.petalslink.easiersbs.registry.service.impl.registry.ImportWsdlCallableImpl;
import com.petalslink.easiersbs.registry.service.impl.registry.SemanticProfileRegistryImpl;
import com.petalslink.easiersbs.registry.service.impl.registry.TechnicalServiceRegistryImpl;
import com.petalslink.easiersbs.registry.service.impl.util.ServiceUtil;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Service;

public class SemanticRegistryManagerImpl
implements SemanticRegistryManager {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private SemanticProfileRegistry profiles = new SemanticProfileRegistryImpl();
    private TechnicalServiceRegistry services = new TechnicalServiceRegistryImpl();
    private static XmlContextFactory xmlContextFactory = new XmlContextFactory();
    private static XmlContext xmlContext = xmlContextFactory.newContext();

    public void addSemanticService(QName operationQName, Description wsdlDesc, Partner partner, URL wsdlUrl) {
        SemanticProfile profile = ServiceUtil.extractSemanticProfile(operationQName, wsdlDesc);
        profile.setPartner(partner);
        List<Service> listServices = ServiceUtil.findServicesByOperation(operationQName, wsdlDesc);
        for (Service service : listServices) {
            this.services.addTechnicalService(service.getQName(), wsdlDesc, wsdlUrl);
        }
        this.profiles.addSemanticProfile(profile);
    }

    public void addSemanticService(QName operationQName, Description wsdlDesc, URL wsdlUrl) {
        this.addSemanticService(operationQName, wsdlDesc, null, wsdlUrl);
    }

    public void addSemanticService(QName operationQName, URL wsdlUrl, Partner partner) throws RegistryException {
        Description wsdlDesc = this.getDescription(wsdlUrl);
        this.addSemanticService(operationQName, wsdlDesc, partner, wsdlUrl);
    }

    public void addSemanticService(QName operationQName, URL wsdlUrl) throws RegistryException {
        this.addSemanticService(operationQName, wsdlUrl, null);
    }

    public void addSemanticServices(Description wsdlDesc, Partner partner, URL wsdlUrl) {
        for (org.petalslink.abslayer.service.api.Operation op : ServiceUtil.getOperations(wsdlDesc)) {
            this.addSemanticService(op.inferQName(), wsdlDesc, partner, wsdlUrl);
        }
    }

    public void addSemanticServices(Description wsdlDesc, URL wsdlUrl) {
        this.addSemanticServices(wsdlDesc, null, wsdlUrl);
    }

    public void addSemanticServices(URL wsdlUrl, Partner partner) throws RegistryException {
        Description wsdlDesc = this.getDescription(wsdlUrl);
        this.addSemanticServices(wsdlDesc, partner, wsdlUrl);
    }

    public void addSemanticServices(URL wsdlUrl) throws RegistryException {
        this.addSemanticServices(wsdlUrl, null);
    }

    public void addMultipleSemanticServices(Set<URL> wsdlUrls, Partner partner) {
        ExecutorService exec = Executors.newFixedThreadPool(4);
        ExecutorCompletionService<Boolean> compExec = new ExecutorCompletionService<Boolean>(exec);
        HashMap<URL, Future<Boolean>> results = new HashMap<URL, Future<Boolean>>();
        for (URL wsdlUrl : wsdlUrls) {
            ImportWsdlCallableImpl call = new ImportWsdlCallableImpl(this.profiles, this.services, xmlContext, partner, wsdlUrl);
            Future<Boolean> success = compExec.submit(call);
            results.put(wsdlUrl, success);
        }
        boolean done = false;
        while (!done) {
            done = true;
            for (Future future : results.values()) {
                if (future.isDone()) continue;
                done = false;
                break;
            }
            if (done) continue;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        for (Map.Entry result : results.entrySet()) {
            try {
                if (((Boolean)((Future)result.getValue()).get()).booleanValue()) continue;
                this.logger.warning("Impossible to import WSDL at " + result.getKey());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        exec.shutdown();
    }

    public void clearRegistry() {
        this.services.removeAllTechnicalServices();
        this.profiles.removeAllSemanticProfiles();
    }

    public SemanticProfile getSemanticProfile(Operation operation) {
        return this.profiles.getSemanticProfile(operation);
    }

    public Set<SemanticProfile> getAllSemanticProfiles() {
        return this.profiles.getAllSemanticProfiles();
    }

    public Set<SemanticProfile> findSemanticProfilesByPartner(Partner partner) {
        return this.profiles.findSemanticProfilesByPartner(partner);
    }

    public Description getTechnicalService(QName serviceQName) throws RegistryException {
        return this.services.getTechnicalService(serviceQName);
    }

    public URL getWsdlUrl(QName serviceQName) {
        return this.services.getWsdlUrl(serviceQName);
    }

    public Set<URL> getWsdlUrls() {
        return this.services.getWsdlUrls();
    }

    public Set<Description> getAllTechnicalServices() {
        return this.services.getAllTechnicalServices();
    }

    public void removeSemanticServices(Description wsdlDesc) {
        for (Service service : wsdlDesc.getServices()) {
            this.services.removeTechnicalService(service.getQName());
        }
        for (org.petalslink.abslayer.service.api.Operation op : ServiceUtil.getOperations(wsdlDesc)) {
            QName serviceQName = ServiceUtil.findServicesByOperation(op.inferQName(), wsdlDesc).get(0).getQName();
            this.profiles.removeSemanticProfile((Operation)new OperationImpl(op.inferQName(), serviceQName));
        }
    }

    public void removeSemanticService(Operation operation) {
        this.profiles.removeSemanticProfile(operation);
        boolean used = false;
        Description wsdlDesc = this.services.getTechnicalService(operation.getServiceQName());
        Set<org.petalslink.abslayer.service.api.Operation> ops = ServiceUtil.findOperationsByService(operation.getServiceQName(), wsdlDesc);
        for (org.petalslink.abslayer.service.api.Operation op : ops) {
            OperationImpl profileOp = new OperationImpl(op.inferQName(), operation.getServiceQName());
            if (this.profiles.getSemanticProfile((Operation)profileOp) == null) continue;
            used = true;
            break;
        }
        if (!used) {
            this.services.removeTechnicalService(operation.getServiceQName());
        }
    }

    public void removeSemanticProfilesByPartner(Partner partner) {
        this.profiles.removeSemanticProfilesByPartner(partner);
    }

    public Description getDescription(URL wsdlUrl) throws RegistryException {
        return ServiceUtil.getDescription(wsdlUrl, xmlContext);
    }
}

