/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.registry.service.impl.model.generic;

import com.petalslink.easiersbs.registry.service.api.model.Operation;
import com.petalslink.easiersbs.registry.service.api.model.Partner;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericElement;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericPart;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericProfile;
import java.util.HashSet;
import java.util.Set;

public abstract class GenericProfileImpl<P extends GenericPart, E extends GenericElement<E>>
implements GenericProfile<P, E> {
    protected E semanticInput = null;
    protected E semanticOutput = null;
    protected P semanticOperation = null;
    protected P semanticInterface = null;
    protected Set<Operation> operations = new HashSet<Operation>();
    protected Partner partner = null;

    public E getInputSemanticElement() {
        return this.semanticInput;
    }

    public E getOutputSemanticElement() {
        return this.semanticOutput;
    }

    public P getSemanticInterface() {
        return this.semanticInterface;
    }

    public P getSemanticOperation() {
        return this.semanticOperation;
    }

    public void setInputSemanticElement(E input) {
        this.semanticInput = input;
    }

    public void setOutputSemanticElement(E output) {
        this.semanticOutput = output;
    }

    public void setSemanticInterface(P semanticInterface) {
        this.semanticInterface = semanticInterface;
    }

    public void setSemanticOperation(P semanticOperation) {
        this.semanticOperation = semanticOperation;
    }

    public Set<Operation> getOperations() {
        return this.operations;
    }

    public void addOperation(Operation operation) {
        this.operations.add(operation);
    }

    public void removeOperation(Operation operation) {
        this.operations.remove(operation);
    }

    public Partner getPartner() {
        return this.partner;
    }

    public boolean hasPartner() {
        return this.partner != null;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public boolean equals(Object other) {
        if (other instanceof GenericProfile) {
            return ((Object)this.operations).equals(((GenericProfile)other).getOperations());
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.operations).hashCode();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        if (this.semanticOperation != null) {
            str.append("\n\tOperation: " + this.semanticOperation.toString());
        }
        if (this.semanticInterface != null) {
            str.append("\n\tInterface: " + this.semanticInterface.toString());
        }
        if (this.semanticInput != null) {
            str.append("\n\tInput: " + this.semanticInput.toString());
        }
        if (this.semanticOutput != null) {
            str.append("\n\tOutput: " + this.semanticOutput.toString());
        }
        return str.toString();
    }
}

