/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.registry.service.impl.registry;

import com.petalslink.easiersbs.registry.service.api.model.Operation;
import com.petalslink.easiersbs.registry.service.api.model.Partner;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import com.petalslink.easiersbs.registry.service.api.registry.SemanticProfileRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SemanticProfileRegistryImpl
implements SemanticProfileRegistry {
    Map<Operation, SemanticProfile> registry = new HashMap<Operation, SemanticProfile>();
    Map<Partner, Set<SemanticProfile>> partnerProfiles = new HashMap<Partner, Set<SemanticProfile>>();

    public void addSemanticProfile(SemanticProfile profile) {
        this.registry.put((Operation)profile.getOperations().iterator().next(), profile);
        if (profile.hasPartner()) {
            Partner partner = profile.getPartner();
            if (this.partnerProfiles.containsKey(partner)) {
                this.partnerProfiles.get(partner).add(profile);
            } else {
                HashSet<SemanticProfile> profiles = new HashSet<SemanticProfile>();
                profiles.add(profile);
                this.partnerProfiles.put(partner, profiles);
            }
        }
    }

    public void removeSemanticProfile(Operation operation) {
        SemanticProfile profile = this.registry.get(operation);
        if (profile != null) {
            this.registry.remove(operation);
            if (profile.hasPartner()) {
                Partner partner = profile.getPartner();
                Set<SemanticProfile> profiles = this.partnerProfiles.get(partner);
                profiles.remove(profile);
                if (profiles.isEmpty()) {
                    this.partnerProfiles.remove(partner);
                }
            }
        }
    }

    public SemanticProfile getSemanticProfile(Operation operation) {
        return this.registry.get(operation);
    }

    public Set<SemanticProfile> getAllSemanticProfiles() {
        return new HashSet<SemanticProfile>(this.registry.values());
    }

    public Set<SemanticProfile> findSemanticProfilesByPartner(Partner partner) {
        return this.partnerProfiles.get(partner);
    }

    public void removeAllSemanticProfiles() {
        this.registry.clear();
        this.partnerProfiles.clear();
    }

    public void removeSemanticProfilesByPartner(Partner partner) {
        Set<SemanticProfile> tempProfiles = this.findSemanticProfilesByPartner(partner);
        for (SemanticProfile profile : tempProfiles) {
            this.registry.remove(profile.getOperations().iterator().next());
        }
        this.partnerProfiles.remove(partner);
    }
}

