/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.registry.service.impl.registry;

import com.petalslink.easiersbs.registry.service.api.registry.TechnicalServiceRegistry;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.petalslink.abslayer.service.api.Description;

public class TechnicalServiceRegistryImpl
implements TechnicalServiceRegistry {
    Map<QName, Description> registry = new HashMap<QName, Description>();
    Map<QName, URL> wsdlUrls = new HashMap<QName, URL>();

    public void addTechnicalService(QName serviceQName, Description wsdlDesc, URL wsdlUrl) {
        this.registry.put(serviceQName, wsdlDesc);
        this.wsdlUrls.put(serviceQName, wsdlUrl);
    }

    public void removeTechnicalService(QName serviceQName) {
        this.registry.remove(serviceQName);
        this.wsdlUrls.remove(serviceQName);
    }

    public Description getTechnicalService(QName serviceQName) {
        return this.registry.get(serviceQName);
    }

    public URL getWsdlUrl(QName serviceQName) {
        return this.wsdlUrls.get(serviceQName);
    }

    public Set<URL> getWsdlUrls() {
        HashSet<URL> urls = new HashSet<URL>();
        for (URL url : this.wsdlUrls.values()) {
            urls.add(url);
        }
        return urls;
    }

    public Set<Description> getAllTechnicalServices() {
        return new HashSet<Description>(this.registry.values());
    }

    public void removeAllTechnicalServices() {
        this.registry.clear();
        this.wsdlUrls.clear();
    }
}

