/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.registry.service.impl.util;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easybox.api.with.WithName;
import com.ebmwebsourcing.easysawsdl10.api.SawsdlHelper;
import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.element.Choice;
import com.ebmwebsourcing.easyschema10.api.element.ComplexType;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.element.Sequence;
import com.ebmwebsourcing.easyschema10.api.type.Type;
import com.ebmwebsourcing.easyschema10.api.with.WithElements;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.petalslink.easiersbs.registry.service.api.RegistryException;
import com.petalslink.easiersbs.registry.service.api.model.SemanticElement;
import com.petalslink.easiersbs.registry.service.api.model.SemanticPart;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericElement;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericPart;
import com.petalslink.easiersbs.registry.service.impl.model.OperationImpl;
import com.petalslink.easiersbs.registry.service.impl.model.SemanticElementImpl;
import com.petalslink.easiersbs.registry.service.impl.model.SemanticPartImpl;
import com.petalslink.easiersbs.registry.service.impl.model.SemanticProfileImpl;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Endpoint;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.Operation;
import org.petalslink.abslayer.service.api.Part;
import org.petalslink.abslayer.service.api.Service;

public class ServiceUtil {
    public static Set<Operation> getOperations(Description wsdlDesc) {
        HashSet<Operation> operations = new HashSet<Operation>();
        for (Interface inter : wsdlDesc.getInterfaces()) {
            operations.addAll(Arrays.asList(inter.getOperations()));
        }
        return operations;
    }

    public static Operation findOperation(QName operationQName, Description wsdlDesc) {
        for (Interface inter : wsdlDesc.getInterfaces()) {
            Operation op = inter.getOperation(operationQName);
            if (op == null) continue;
            return op;
        }
        return null;
    }

    public static List<Service> findServicesByOperation(QName operationQName, Description wsdlDesc) {
        Operation op = ServiceUtil.findOperation(operationQName, wsdlDesc);
        List services = wsdlDesc.findServicesImplementingInterface(op.getParentInterface());
        return services;
    }

    public static Set<Operation> findOperationsByService(QName serviceQName, Description wsdlDesc) {
        HashSet<Operation> ops = new HashSet<Operation>();
        Service serv = wsdlDesc.findService(serviceQName);
        for (Endpoint end : serv.getEndpoints()) {
            ops.addAll(Arrays.asList(end.getBinding().getInterface().getOperations()));
        }
        return ops;
    }

    public static <E extends GenericElement<E>> Set<E> getFlattenElements(E element) {
        HashSet listElements = new HashSet();
        return ServiceUtil.getFlattenElements(element, listElements);
    }

    private static <E extends GenericElement<E>> Set<E> getFlattenElements(E element, Set<E> listElements) {
        HashSet<E> res = new HashSet<E>();
        if (element != null) {
            res.add(element);
            listElements.add(element);
            for (GenericElement child : element.getChildElements()) {
                if (listElements.contains(child)) continue;
                res.addAll(ServiceUtil.getFlattenElements(child, listElements));
            }
        }
        return res;
    }

    public static <E extends GenericElement<E>> Set<URI> getFlattenConcepts(Set<E> elements) {
        HashSet<URI> concepts = new HashSet<URI>();
        for (GenericElement element : elements) {
            concepts.addAll(element.getSemanticConcepts());
        }
        return concepts;
    }

    public static SemanticProfile extractSemanticProfile(QName operationQName, Description wsdlDesc) {
        SemanticProfileImpl profile = new SemanticProfileImpl();
        Operation op = ServiceUtil.findOperation(operationQName, wsdlDesc);
        List<Service> services = ServiceUtil.findServicesByOperation(operationQName, wsdlDesc);
        OperationImpl profileOp = null;
        if (!services.isEmpty()) {
            profileOp = new OperationImpl(operationQName, services.get(0).getQName());
        }
        profile.addOperation(profileOp);
        SemanticPart interPart = ServiceUtil.extractSemanticPart((XmlObject)op.getParentInterface().getModel());
        profile.setSemanticInterface((GenericPart)interPart);
        SemanticPart opPart = ServiceUtil.extractSemanticPart((XmlObject)op.getModel());
        profile.setSemanticOperation((GenericPart)opPart);
        SemanticElement input = null;
        if (op.getInput() != null && op.getInput().getParts().length != 0 && op.getInput().getParts()[0] != null) {
            input = ServiceUtil.extractAllSemanticElements(op.getInput().getParts()[0]);
        }
        profile.setInputSemanticElement((GenericElement)input);
        SemanticElement output = null;
        if (op.getOutput() != null && op.getOutput().getParts().length != 0 && op.getOutput().getParts()[0] != null) {
            output = ServiceUtil.extractAllSemanticElements(op.getOutput().getParts()[0]);
        }
        profile.setOutputSemanticElement((GenericElement)output);
        return profile;
    }

    public static SemanticPart extractSemanticPart(XmlObject object) {
        URI[] concepts;
        SemanticPartImpl part = new SemanticPartImpl();
        if (object instanceof WithName && ((WithName)object).hasName()) {
            part.setName(((WithName)object).getName());
        }
        for (URI concept : concepts = SawsdlHelper.getModelReference((XmlObject)object)) {
            part.addSemanticConcept(concept);
        }
        return part;
    }

    public static SemanticElement extractAllSemanticElements(Part part) {
        HashMap<QName, SemanticElement> elementList = new HashMap<QName, SemanticElement>();
        Element element = null;
        if (part.getElement() != null) {
            element = part.getElement();
        } else if (part.getType() != null) {
            element = part.createElement();
            element.setName(part.getQName().getLocalPart());
            element.setType(part.getType());
            Type type = SchemaHelper.findTypeByQName((XmlObject)part.getDescription().getModel(), (QName)part.getType());
            SchemaHelper.findParentSchema((XmlObject)type).addElement(element);
        }
        if (element != null) {
            return ServiceUtil.extractSemanticElement(element, elementList);
        }
        return null;
    }

    private static SemanticElement extractSemanticElement(Element element, Map<QName, SemanticElement> elementList) {
        QName elementQName = element.inferQName();
        if (elementList.containsKey(elementQName)) {
            return elementList.get(elementQName);
        }
        if (element.hasRef()) {
            Element realElement = SchemaHelper.findElementByQName((XmlObject)element.getXmlObjectBaseRoot(), (QName)element.getRef());
            return ServiceUtil.extractSemanticElement(realElement, elementList);
        }
        SemanticElementImpl semanticElement = new SemanticElementImpl();
        semanticElement.setElementQName(element.inferQName());
        semanticElement.setName(element.getName());
        if (element.getMinOccurs() == 0) {
            semanticElement.setRequired(false);
        } else {
            semanticElement.setRequired(true);
        }
        for (URI concept : ServiceUtil.extractSemanticAnnotations(element)) {
            semanticElement.addSemanticConcept(concept);
        }
        elementList.put(elementQName, semanticElement);
        Type type = element.findType();
        if (type instanceof ComplexType) {
            XmlObjectNode[] nodes;
            for (XmlObjectNode node : nodes = type.getXmlObjectChildren()) {
                semanticElement.setChildElements(ServiceUtil.extractSemanticElementChildren(node, elementList));
            }
        }
        return semanticElement;
    }

    private static Set<SemanticElement> extractSemanticElementChildren(XmlObjectNode node, Map<QName, SemanticElement> elementList) {
        HashSet<SemanticElement> children = new HashSet<SemanticElement>();
        if (node instanceof WithElements) {
            for (Element element : ((WithElements)node).getElements()) {
                children.add(ServiceUtil.extractSemanticElement(element, elementList));
            }
        }
        if (node instanceof Sequence || node instanceof Choice) {
            for (Element element : node.getXmlObjectChildren()) {
                if (element instanceof Element) continue;
                children.addAll(ServiceUtil.extractSemanticElementChildren((XmlObjectNode)element, elementList));
            }
        }
        return children;
    }

    private static Set<URI> extractSemanticAnnotations(Element element) {
        URI[] typeConcepts;
        URI[] concepts;
        HashSet<URI> annotations = new HashSet<URI>();
        for (URI concept : concepts = SawsdlHelper.getModelReference((XmlObject)element)) {
            annotations.add(concept);
        }
        for (URI concept : typeConcepts = SawsdlHelper.getModelReference((XmlObject)element.findType())) {
            annotations.add(concept);
        }
        return annotations;
    }

    public static Description getDescription(URL wsdlUrl, XmlContext xmlContext) throws RegistryException {
        Definitions def = null;
        try {
            XmlObjectReader reader = xmlContext.createReader();
            def = (Definitions)reader.readDocument(wsdlUrl, Definitions.class);
        }
        catch (XmlObjectReadException e) {
            throw new RegistryException("Impossible to parse WSDL file at " + wsdlUrl.toString(), (Exception)((Object)e));
        }
        return (Description)Factory.getInstance().wrap((XmlObject)def);
    }
}

