/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.test;

import com.petalslink.easiersbs.matching.service.ProfileFactoryImpl;
import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.profile.ProfileException;
import com.petalslink.easiersbs.matching.service.api.profile.SearchProfile;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredElement;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredProfile;
import com.petalslink.easiersbs.matching.service.matcher.MatcherPropertiesImpl;
import com.petalslink.easiersbs.matching.service.util.ProfileUtil;
import com.petalslink.easiersbs.reasoner.api.ReasonerException;
import com.petalslink.easiersbs.reasoner.api.ReasonerFactory;
import com.petalslink.easiersbs.reasoner.api.engine.Reasoner;
import com.petalslink.easiersbs.reasoner.api.ontology.OntologyManager;
import com.petalslink.easiersbs.reasoner.impl.ReasonerFactoryImpl;
import com.petalslink.easiersbs.registry.service.api.RegistryException;
import com.petalslink.easiersbs.registry.service.api.SemanticRegistryManager;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericElement;
import com.petalslink.easiersbs.registry.service.impl.SemanticRegistryFactoryImpl;
import com.petalslink.easiersbs.registry.service.impl.util.ServiceUtil;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Set;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Interface;

public class InferenceTest {
    public static final String TEST_NAMESPACE = "http://www.petalslink.com/easiersbs/test#";

    @Test
    public void testSemanticConceptEquals() throws ProfileException, URISyntaxException, MalformedURLException, RegistryException, ReasonerException {
        ReasonerFactory factory = ReasonerFactoryImpl.getInstance();
        OntologyManager manager = factory.getOntologyManager();
        URL ontoURL = Thread.currentThread().getContextClassLoader().getResource("services/sawsdl-tc/ontologies/books.owl");
        manager.importOntology(ontoURL.toURI());
        URL ontoURL2 = Thread.currentThread().getContextClassLoader().getResource("services/sawsdl-tc/ontologies/concept.owl");
        manager.importOntology(ontoURL2.toURI());
        Reasoner reasoner = factory.newReasoner(manager);
        SemanticRegistryManager registry = SemanticRegistryFactoryImpl.getInstance().getSemanticRegistryManager();
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("services/sawsdl-tc/queries/book_price_service.wsdl");
        Description wsdlDesc = registry.getDescription(wsdlURL);
        SemanticProfile semProf = ServiceUtil.extractSemanticProfile((QName)((Interface)wsdlDesc.getInterfaces().get(0)).getOperations()[0].inferQName(), (Description)wsdlDesc);
        SearchProfile profile = ProfileFactoryImpl.getInstance().newSearchProfile(semProf);
        System.out.println(profile);
        Assert.assertEquals((long)7L, (long)ServiceUtil.getFlattenConcepts((Set)ServiceUtil.getFlattenElements((GenericElement)profile.getInputSemanticElement())).size());
        InferredProfile inferedProfile = profile.infer(reasoner, (MatcherProperties)new MatcherPropertiesImpl());
        Assert.assertNotNull((Object)inferedProfile);
        System.out.println(inferedProfile);
        Assert.assertEquals((long)17L, (long)ProfileUtil.getFlattenRatedUris((InferredElement)((InferredElement)inferedProfile.getInputSemanticElement())).size());
        Assert.assertEquals((long)7L, (long)ProfileUtil.getFlattenRatedUris((InferredElement)((InferredElement)inferedProfile.getOutputSemanticElement())).size());
    }
}

