/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.test;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.petalslink.easiersbs.matching.service.ProfileFactoryImpl;
import com.petalslink.easiersbs.matching.service.api.ProfileFactory;
import com.petalslink.easiersbs.matching.service.api.profile.ProfileException;
import com.petalslink.easiersbs.matching.service.api.profile.SearchElement;
import com.petalslink.easiersbs.matching.service.api.profile.SearchPart;
import com.petalslink.easiersbs.matching.service.api.profile.SearchProfile;
import com.petalslink.easiersbs.registry.service.api.RegistryException;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericElement;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericPart;
import com.petalslink.easiersbs.registry.service.impl.util.ServiceUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Test;
import org.petalslink.abslayer.service.api.Description;

public class ProfileSearchTest {
    public static final String TEST_NAMESPACE = "http://www.petalslink.com/easiersbs/test#";
    private static final String SAWSDL_URL = "services/sawsdl4matching.wsdl";
    private static final String WSDL_NS = "http://sawsdl4matching";

    @Test
    public void testCreateProfile() throws ProfileException, URISyntaxException {
        ProfileFactory factory = ProfileFactoryImpl.getInstance();
        SearchProfile profile = factory.newSearchProfile();
        SearchPart interfacePart = factory.newSemanticPart();
        interfacePart.addSemanticConcept(new URI("http://www.petalslink.com/easiersbs/test#interfaceConcept"));
        profile.setSemanticInterface((GenericPart)interfacePart);
        Assert.assertTrue((boolean)((SearchPart)profile.getSemanticInterface()).getSemanticConcepts().contains(new URI("http://www.petalslink.com/easiersbs/test#interfaceConcept")));
        Assert.assertFalse((boolean)((SearchPart)profile.getSemanticInterface()).getSemanticConcepts().contains(new URI("http://www.petalslink.com/easiersbs/test#otherConcept")));
        Assert.assertEquals((String)"interfaceConcept", (String)((URI)((SearchPart)profile.getSemanticInterface()).getSemanticConcepts().iterator().next()).getFragment());
        HashSet<URI> operationSemanticConcepts = new HashSet<URI>();
        operationSemanticConcepts.add(new URI("http://www.petalslink.com/easiersbs/test#operationConcept"));
        SearchPart operationPart = factory.newSemanticPart("op", operationSemanticConcepts);
        profile.setSemanticOperation((GenericPart)operationPart);
        Assert.assertTrue((boolean)((SearchPart)profile.getSemanticOperation()).getSemanticConcepts().contains(new URI("http://www.petalslink.com/easiersbs/test#operationConcept")));
        SearchElement inputElement = factory.newSemanticElement();
        inputElement.addSemanticConcept(new URI("http://www.petalslink.com/easiersbs/test#inputElementConcept"));
        profile.setInputSemanticElement((GenericElement)inputElement);
        Assert.assertTrue((boolean)((SearchElement)profile.getInputSemanticElement()).getSemanticConcepts().contains(new URI("http://www.petalslink.com/easiersbs/test#inputElementConcept")));
        HashSet<URI> outputSemanticConcepts = new HashSet<URI>();
        outputSemanticConcepts.add(new URI("http://www.petalslink.com/easiersbs/test#outputElementConcept"));
        SearchElement outputElement = factory.newSemanticElement("out", outputSemanticConcepts, true);
        profile.setOutputSemanticElement((GenericElement)outputElement);
        Assert.assertTrue((boolean)((SearchElement)profile.getOutputSemanticElement()).getSemanticConcepts().contains(new URI("http://www.petalslink.com/easiersbs/test#outputElementConcept")));
        System.out.println(profile);
        SearchProfile profile2 = factory.newSearchProfile(interfacePart, operationPart, inputElement, outputElement);
        Assert.assertNotNull((Object)profile2);
        Assert.assertTrue((boolean)profile.equals(profile2));
    }

    @Test
    public void testConvertProfileFromSemanticProfile() throws XmlObjectReadException, RegistryException {
        URL wsdlUrl = Thread.currentThread().getContextClassLoader().getResource(SAWSDL_URL);
        XmlContextFactory xmlContextFactory = new XmlContextFactory();
        XmlContext xmlContext = xmlContextFactory.newContext();
        Description desc = ServiceUtil.getDescription((URL)wsdlUrl, (XmlContext)xmlContext);
        QName operationQName = new QName(WSDL_NS, "getWeather");
        SemanticProfile profile = ServiceUtil.extractSemanticProfile((QName)operationQName, (Description)desc);
        SearchProfile res = ProfileFactoryImpl.getInstance().newSearchProfile(profile);
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((int)ServiceUtil.getFlattenElements((GenericElement)profile.getInputSemanticElement()).size(), (int)ServiceUtil.getFlattenElements((GenericElement)res.getInputSemanticElement()).size());
        Assert.assertEquals((int)ServiceUtil.getFlattenElements((GenericElement)profile.getOutputSemanticElement()).size(), (int)ServiceUtil.getFlattenElements((GenericElement)res.getOutputSemanticElement()).size());
    }
}

