/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.test;

import com.petalslink.easiersbs.matching.service.SBSFactoryImpl;
import com.petalslink.easiersbs.matching.service.api.EasierSBSException;
import com.petalslink.easiersbs.matching.service.api.SBSFactory;
import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.matcher.MatchingResult;
import com.petalslink.easiersbs.matching.service.api.matcher.SemanticMatcher;
import com.petalslink.easiersbs.matching.service.matcher.MatcherPropertiesImpl;
import com.petalslink.easiersbs.reasoner.api.ReasonerException;
import com.petalslink.easiersbs.reasoner.api.ReasonerFactory;
import com.petalslink.easiersbs.reasoner.impl.ReasonerFactoryImpl;
import com.petalslink.easiersbs.registry.service.api.RegistryException;
import com.petalslink.easiersbs.registry.service.api.SemanticRegistryFactory;
import com.petalslink.easiersbs.registry.service.api.SemanticRegistryManager;
import com.petalslink.easiersbs.registry.service.api.model.Operation;
import com.petalslink.easiersbs.registry.service.api.model.Partner;
import com.petalslink.easiersbs.registry.service.impl.SemanticRegistryFactoryImpl;
import com.petalslink.easiersbs.registry.service.impl.model.PartnerImpl;
import com.petalslink.easiersbs.test.SawsdlTcSample;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Interface;

public class SemanticMatchingTest {
    private static final String SAWSDL_URL = "services/sawsdl4matching.wsdl";
    private static final String WSDL_NS = "http://sawsdl4matching";
    private SemanticRegistryFactory registryFactory = SemanticRegistryFactoryImpl.getInstance();
    private SemanticRegistryManager registry = this.registryFactory.getSemanticRegistryManager();
    private SBSFactory factory = SBSFactoryImpl.getInstance();
    private ReasonerFactory reasoner = ReasonerFactoryImpl.getInstance();

    @Before
    public void prepareRegistry() throws RegistryException, ReasonerException, URISyntaxException {
        this.registry.clearRegistry();
        URL wsdlUrl = Thread.currentThread().getContextClassLoader().getResource(SAWSDL_URL);
        QName operationQName = new QName(WSDL_NS, "getWeather");
        PartnerImpl easierPartner = new PartnerImpl("EasierSBS");
        this.registry.addSemanticService(operationQName, wsdlUrl, (Partner)easierPartner);
        PartnerImpl tcPartner = new PartnerImpl("SawsdlTc");
        this.registry.addMultipleSemanticServices(SawsdlTcSample.getServiceSample(), (Partner)tcPartner);
        this.reasoner.getOntologyManager().clearOntology();
        URI ontoUri = Thread.currentThread().getContextClassLoader().getResource("services/sawsdl-tc/ontologies/concept.owl").toURI();
        this.reasoner.getOntologyManager().importOntology(ontoUri);
        URI ontoUri2 = Thread.currentThread().getContextClassLoader().getResource("services/sawsdl-tc/ontologies/books.owl").toURI();
        this.reasoner.getOntologyManager().importOntology(ontoUri2);
    }

    @Test
    public void findSameService() throws RegistryException, EasierSBSException, ReasonerException, URISyntaxException {
        SemanticMatcher semanticMatcher = this.factory.newSemanticMatcher(this.reasoner, this.registry);
        URL wsdlUrl = Thread.currentThread().getContextClassLoader().getResource(SAWSDL_URL);
        Description sawsdlDesc = this.registry.getDescription(wsdlUrl);
        QName operationQName = new QName(WSDL_NS, "getWeather");
        System.out.println("findSameService: SemanticMatching (1 service in registry)");
        long start = System.currentTimeMillis();
        MatchingResult result = semanticMatcher.findServices(operationQName, sawsdlDesc, (Partner)new PartnerImpl("EasierSBS"));
        System.out.println("Semantic matching done in " + (System.currentTimeMillis() - start) + " ms");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)1, (int)result.getResultProfiles().size());
        Assert.assertEquals((boolean)true, (boolean)result.hasExactProfile());
        Assert.assertEquals((boolean)true, (boolean)result.hasCorrectProfile(0.9));
        Assert.assertEquals((Object)operationQName, (Object)((Operation)result.getBestProfile().getProfile().getOperations().iterator().next()).getOperationQName());
        Assert.assertEquals((Object)1.0, (Object)result.getBestProfile().getProfileRate());
    }

    @Test
    public void findSawsdlTcService() throws RegistryException, EasierSBSException, ReasonerException, URISyntaxException {
        SemanticMatcher semanticMatcher = this.factory.newSemanticMatcher(this.reasoner, this.registry);
        URL queryUrl = Thread.currentThread().getContextClassLoader().getResource(SawsdlTcSample.getQuerySample());
        Description queryDesc = this.registry.getDescription(queryUrl);
        QName opQName = ((Interface)queryDesc.getInterfaces().get(0)).getOperations()[0].inferQName();
        System.out.println("findSawsdlTcService: SemanticMatching (13 services in registry)");
        long start = System.currentTimeMillis();
        MatchingResult result = semanticMatcher.findServices(opQName, queryDesc);
        System.out.println("Semantic matching done in " + (System.currentTimeMillis() - start) + " ms");
        System.out.println(semanticMatcher.getMatcherProperties().getCompositionServiceLimit());
        System.out.println(result.getResultProfiles());
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)13, (int)result.getResultProfiles().size());
        Assert.assertEquals((int)3, (int)result.getCorrectProfiles(0.4).size());
        Assert.assertEquals((boolean)false, (boolean)result.hasExactProfile());
        Assert.assertEquals((boolean)true, (boolean)result.hasCorrectProfile(0.4));
    }

    @Test
    public void findSawsdlTcServiceWithSpecificProperties() throws RegistryException, EasierSBSException, IOException, ReasonerException, URISyntaxException {
        Properties props = new Properties();
        URL propUrl = Thread.currentThread().getContextClassLoader().getResource("easiersbs.properties");
        props.load(propUrl.openStream());
        MatcherPropertiesImpl matchProps = new MatcherPropertiesImpl(props);
        SemanticMatcher semanticMatcher = this.factory.newSemanticMatcher(this.reasoner, this.registry, (MatcherProperties)matchProps);
        URL queryUrl = Thread.currentThread().getContextClassLoader().getResource(SawsdlTcSample.getQuerySample());
        Description queryDesc = this.registry.getDescription(queryUrl);
        QName opQName = ((Interface)queryDesc.getInterfaces().get(0)).getOperations()[0].inferQName();
        System.out.println("findSawsdlTcService: SemanticMatching (13 services in registry)");
        long start = System.currentTimeMillis();
        MatchingResult result = semanticMatcher.findServices(opQName, queryDesc);
        System.out.println("Semantic matching done in " + (System.currentTimeMillis() - start) + " ms");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)9, (int)result.getResultProfiles().size());
        Assert.assertEquals((boolean)true, (boolean)result.hasExactProfile());
        Assert.assertEquals((boolean)true, (boolean)result.hasCorrectProfile(0.6));
    }
}

