/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.test;

import com.petalslink.easiersbs.matching.service.SBSFactoryImpl;
import com.petalslink.easiersbs.matching.service.api.EasierSBSException;
import com.petalslink.easiersbs.matching.service.api.SBSFactory;
import com.petalslink.easiersbs.matching.service.api.matcher.similarity.SimilarityMeasure;
import com.petalslink.easiersbs.matching.service.api.matcher.similarity.SimilarityType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class SimilarityTest {
    private SBSFactory factory = SBSFactoryImpl.getInstance();
    private List<String> words1 = new ArrayList<String>(Arrays.asList("test", "word", "fooo", "bar", "semantic"));
    private List<String> words2 = new ArrayList<String>(Arrays.asList("semantic", "fooo", "test", "bar", "word"));
    private List<String> words3 = new ArrayList<String>(Arrays.asList("test", "words", "foo", "service"));
    private List<String> words4 = new ArrayList<String>(Arrays.asList("lorem", "ipsum", "dolor", "sit", "amet"));
    private List<String> words5 = new ArrayList<String>(Arrays.asList("test", "word", "fooo", "bar", "semantic", "lorem", "ipsum", "dolor", "sit", "amet", "consectetur", "adipisicingor", "elit", "sed", "do", "eiusmod", "tempor", "incididunt", "ut", "labore", "et", "dolore", "magna", "aliqua", ""));
    private List<String> words6 = new ArrayList<String>(Arrays.asList("test", "tests", "foo", "semantic", "semantics", "foo"));
    private List<String> empty = new ArrayList<String>();

    @Test
    public void testCosineSimilarityMeasure() throws EasierSBSException {
        SimilarityMeasure similarity = this.factory.newSimilarityMeasure(SimilarityType.COSINE);
        System.out.println("\n            COSINE SIMILARITY TEST");
        this.testSimilarityMeasure(similarity);
    }

    @Test
    public void testDiceSimilarityMeasure() throws EasierSBSException {
        SimilarityMeasure similarity = this.factory.newSimilarityMeasure(SimilarityType.DICE);
        System.out.println("\n             DICE SIMILARITY TEST");
        this.testSimilarityMeasure(similarity);
    }

    @Test
    public void testJaccardSimilarityMeasure() throws EasierSBSException {
        SimilarityMeasure similarity = this.factory.newSimilarityMeasure(SimilarityType.JACCARD);
        System.out.println("\n           JACCARD SIMILARITY TEST");
        this.testSimilarityMeasure(similarity);
    }

    @Test
    public void testJensenShanonSimilarityMeasure() throws EasierSBSException {
        SimilarityMeasure similarity = this.factory.newSimilarityMeasure(SimilarityType.JENSEN_SHANNON);
        System.out.println("\n        JENSEN-SHANNON SIMILARITY TEST");
        this.testSimilarityMeasure(similarity);
    }

    @Test
    public void testLevenshteinLimitManagement() throws EasierSBSException {
        SimilarityMeasure similarity = this.factory.newSimilarityMeasure(SimilarityType.COSINE, 2);
        Assert.assertEquals((int)2, (int)similarity.getLevenshteinLimit());
        similarity.setLevenshteinLimit(3);
        Assert.assertEquals((int)2, (int)similarity.getLevenshteinLimit());
    }

    private void testSimilarityMeasure(SimilarityMeasure similarity) {
        double epsilon = 0.001;
        String[] name = new String[10];
        double[] res = new double[10];
        double[] time = new double[10];
        name[0] = "Normal-w1w2";
        long start = System.currentTimeMillis();
        res[0] = similarity.measureSimilarity(this.words1, this.words2);
        Assert.assertTrue((res[0] <= 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((1.0 - res[0] < epsilon ? 1 : 0) != 0);
        time[0] = (double)(System.currentTimeMillis() - start) / 1000.0;
        name[1] = "Normal-w1w3";
        start = System.currentTimeMillis();
        res[1] = similarity.measureSimilarity(this.words1, this.words3);
        Assert.assertTrue((res[1] > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((res[1] < 1.0 ? 1 : 0) != 0);
        time[1] = (double)(System.currentTimeMillis() - start) / 1000.0;
        name[2] = "Normal-w1w4";
        start = System.currentTimeMillis();
        res[2] = similarity.measureSimilarity(this.words1, this.words4);
        Assert.assertTrue((res[2] >= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((res[2] < epsilon ? 1 : 0) != 0);
        time[2] = (double)(System.currentTimeMillis() - start) / 1000.0;
        name[3] = "Normal-w1w5";
        start = System.currentTimeMillis();
        res[3] = similarity.measureSimilarity(this.words1, this.words5);
        Assert.assertTrue((res[3] >= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((res[3] < 1.0 ? 1 : 0) != 0);
        time[3] = (double)(System.currentTimeMillis() - start) / 1000.0;
        name[4] = "Normal-w1w6";
        start = System.currentTimeMillis();
        res[4] = similarity.measureSimilarity(this.words1, this.words6);
        Assert.assertTrue((res[4] >= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((res[4] < 1.0 ? 1 : 0) != 0);
        time[4] = (double)(System.currentTimeMillis() - start) / 1000.0;
        similarity.setLevenshteinLimit(1);
        name[5] = "Fuzzy-w1w2";
        start = System.currentTimeMillis();
        res[5] = similarity.measureSimilarity(this.words1, this.words2);
        Assert.assertTrue((res[5] <= 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((1.0 - res[5] < epsilon ? 1 : 0) != 0);
        time[5] = (double)(System.currentTimeMillis() - start) / 1000.0;
        name[6] = "Fuzzy-w1w3";
        start = System.currentTimeMillis();
        res[6] = similarity.measureSimilarity(this.words1, this.words3);
        Assert.assertTrue((res[6] > res[1] ? 1 : 0) != 0);
        Assert.assertTrue((res[6] < 1.0 ? 1 : 0) != 0);
        time[6] = (double)(System.currentTimeMillis() - start) / 1000.0;
        name[7] = "Fuzzy-w1w4";
        start = System.currentTimeMillis();
        res[7] = similarity.measureSimilarity(this.words1, this.words4);
        Assert.assertTrue((res[7] >= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((res[7] < epsilon ? 1 : 0) != 0);
        time[7] = (double)(System.currentTimeMillis() - start) / 1000.0;
        name[8] = "Fuzzy-w1w5";
        start = System.currentTimeMillis();
        res[8] = similarity.measureSimilarity(this.words1, this.words5);
        Assert.assertTrue((res[8] >= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((res[8] < 1.0 ? 1 : 0) != 0);
        time[8] = (double)(System.currentTimeMillis() - start) / 1000.0;
        name[9] = "Fuzzy-w1w6";
        start = System.currentTimeMillis();
        res[9] = similarity.measureSimilarity(this.words1, this.words6);
        Assert.assertTrue((res[9] >= res[6] ? 1 : 0) != 0);
        Assert.assertTrue((res[9] < 1.0 ? 1 : 0) != 0);
        time[9] = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.println("---------------------------------------------");
        System.out.println("|     Test     |   Resultat   |  Temps (s)  |");
        System.out.println("---------------------------------------------");
        for (int i = 0; i < name.length; ++i) {
            System.out.format("| %-12s |  %.8f  |    %.3f    |\n", name[i], res[i], time[i]);
        }
        System.out.println("---------------------------------------------");
        Double resEmpty = similarity.measureSimilarity(this.words1, this.empty);
        Assert.assertTrue((resEmpty < epsilon ? 1 : 0) != 0);
    }
}

