/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.test;

import com.petalslink.easiersbs.matching.service.ProfileFactoryImpl;
import com.petalslink.easiersbs.matching.service.api.profile.SearchElement;
import com.petalslink.easiersbs.matching.service.util.ProfileUtil;
import com.petalslink.easiersbs.matching.service.util.SimilarityUtil;
import com.petalslink.easiersbs.matching.service.util.VectorUtil;
import com.petalslink.easiersbs.registry.service.impl.model.OperationImpl;
import com.petalslink.easiersbs.registry.service.impl.model.SemanticElementImpl;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Test;

public class UtilsTest {
    @Test
    public void testVectorUtil() {
        int[] v1 = new int[]{1, 2, 2};
        int[] v2 = new int[]{4, 5, 6};
        int[] v3 = new int[]{0, 0, 0};
        int[] v4 = new int[]{1, 2};
        Assert.assertEquals((Object)3.0, (Object)VectorUtil.magnitude((int[])v1));
        Assert.assertEquals((Object)0.0, (Object)VectorUtil.magnitude((int[])v3));
        Assert.assertEquals((int)26, (int)VectorUtil.dotProduct((int[])v1, (int[])v2));
        Assert.assertEquals((int)0, (int)VectorUtil.dotProduct((int[])v1, (int[])v3));
        Assert.assertEquals((int)0, (int)VectorUtil.dotProduct((int[])v1, (int[])v4));
        Assert.assertEquals((Object)0.3333333333333333, (Object)VectorUtil.normalize((int[])v1)[0]);
    }

    @Test
    public void testSimilarityUtil() throws URISyntaxException {
        SemanticElementImpl element = new SemanticElementImpl();
        element.addSemanticConcept(new URI("http://petalslink.com/easiersbs/test.owl#SuperConcept-withSeveralWords_Usefull4tests"));
        element.addSemanticConcept(new URI("http://petalslink.com/easiersbs/test.owl#anotherTwo"));
        HashSet<SemanticElementImpl> elements = new HashSet<SemanticElementImpl>();
        elements.add(element);
        List words = SimilarityUtil.extractElementRelatedWords(elements);
        Assert.assertEquals((int)9, (int)words.size());
        Assert.assertTrue((boolean)words.contains("super"));
        Assert.assertTrue((boolean)words.contains("with"));
        Assert.assertTrue((boolean)words.contains("tests"));
        Assert.assertTrue((boolean)words.contains("another"));
    }

    @Test
    public void testExtractRelatedWords() throws URISyntaxException {
        HashSet<URI> uris1 = new HashSet<URI>();
        HashSet<URI> uris2 = new HashSet<URI>();
        Assert.assertEquals((int)0, (int)SimilarityUtil.extractUriRelatedWords(uris1).size());
        uris1.add(new URI("http://www.petalslink.com/easiersbs/test#SuperConcept-withSeveralWords_Usefull4tests"));
        uris1.add(new URI("http://www.petalslink.com/easiersbs/test/noconcept"));
        uris1.add(new URI("http://www.petalslink.com/easiersbs/test#anotherTwo"));
        uris2.add(new URI("http://www.petalslink.com/easiersbs/test#oneTwo_Three"));
        Assert.assertEquals((int)9, (int)SimilarityUtil.extractUriRelatedWords(uris1).size());
        Assert.assertEquals((int)3, (int)SimilarityUtil.extractUriRelatedWords(uris2).size());
        HashSet<SearchElement> elements = new HashSet<SearchElement>();
        elements.add(ProfileFactoryImpl.getInstance().newSemanticElement("foo", uris1, true));
        elements.add(ProfileFactoryImpl.getInstance().newSemanticElement("bar", uris2, false));
        Assert.assertEquals((int)14, (int)SimilarityUtil.extractElementRelatedWords(elements).size());
    }

    @Test
    public void testCycleDetection() {
        OperationImpl op1 = new OperationImpl(new QName("Test", "Op1"), new QName("Test", "Serv1"));
        OperationImpl op2 = new OperationImpl(new QName("Test", "Op2"), new QName("Test", "Serv1"));
        OperationImpl op3 = new OperationImpl(new QName("Test", "Op3"), new QName("Test", "Serv2"));
        OperationImpl op4 = new OperationImpl(new QName("Test", "Op4"), new QName("Test", "Serv2"));
        HashMap dependencies = new HashMap();
        dependencies.put(op1, new HashSet());
        dependencies.put(op2, new HashSet());
        dependencies.put(op3, new HashSet());
        dependencies.put(op4, new HashSet());
        ((Set)dependencies.get(op3)).add(op4);
        ((Set)dependencies.get(op3)).add(op2);
        ((Set)dependencies.get(op4)).add(op2);
        ((Set)dependencies.get(op2)).add(op1);
        Assert.assertFalse((boolean)ProfileUtil.hasCycle(dependencies));
        for (Set dep : dependencies.values()) {
            dep.clear();
        }
        ((Set)dependencies.get(op4)).add(op3);
        ((Set)dependencies.get(op3)).add(op2);
        ((Set)dependencies.get(op2)).add(op4);
        ((Set)dependencies.get(op2)).add(op1);
        Assert.assertTrue((boolean)ProfileUtil.hasCycle(dependencies));
    }
}

