/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher;

import com.petalslink.easiersbs.matching.service.SBSFactoryImpl;
import com.petalslink.easiersbs.matching.service.api.CompositionException;
import com.petalslink.easiersbs.matching.service.api.EasierSBSException;
import com.petalslink.easiersbs.matching.service.api.SBSFactory;
import com.petalslink.easiersbs.matching.service.api.matcher.HybridMatcher;
import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.matcher.MatchingResult;
import com.petalslink.easiersbs.matching.service.api.matcher.SemanticMatcher;
import com.petalslink.easiersbs.matching.service.api.matcher.SyntacticMatcher;
import com.petalslink.easiersbs.matching.service.api.profile.SearchProfile;
import com.petalslink.easiersbs.matching.service.api.profile.rated.RatedSemanticProfile;
import com.petalslink.easiersbs.matching.service.matcher.AbstractMatcherImpl;
import com.petalslink.easiersbs.matching.service.matcher.MatcherPropertiesImpl;
import com.petalslink.easiersbs.matching.service.matcher.MatchingResultImpl;
import com.petalslink.easiersbs.matching.service.profile.rated.RatedSemanticProfileImpl;
import com.petalslink.easiersbs.matching.service.util.ProfileUtil;
import com.petalslink.easiersbs.reasoner.api.ReasonerException;
import com.petalslink.easiersbs.reasoner.api.ReasonerFactory;
import com.petalslink.easiersbs.registry.service.api.SemanticRegistryManager;
import com.petalslink.easiersbs.registry.service.api.model.Operation;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public class HybridMatcherImpl
extends AbstractMatcherImpl
implements HybridMatcher {
    private static Logger logger = Logger.getLogger("HybridMatcherImpl");
    private SBSFactory factory = SBSFactoryImpl.getInstance();
    private SemanticMatcher semanticMatcher;
    private SyntacticMatcher syntacticMatcher;
    private MatcherProperties props;

    public HybridMatcherImpl(ReasonerFactory reasoner, SemanticRegistryManager registry, MatcherProperties props) throws ReasonerException, EasierSBSException {
        this.props = props;
        this.registry = registry;
        this.semanticMatcher = this.factory.newSemanticMatcher(reasoner, registry, props);
        this.syntacticMatcher = this.factory.newSyntacticMatcher(registry, props);
    }

    public HybridMatcherImpl(ReasonerFactory reasoner, SemanticRegistryManager registry) throws ReasonerException, EasierSBSException {
        this(reasoner, registry, new MatcherPropertiesImpl());
    }

    @Override
    public void setMatcherProperties(MatcherProperties props) {
        this.props = props;
        this.semanticMatcher.setMatcherProperties(props);
        this.syntacticMatcher.setMatcherProperties(props);
    }

    public SyntacticMatcher getSyntacticMatcher() {
        return this.syntacticMatcher;
    }

    public SemanticMatcher getSemanticMatcher() {
        return this.semanticMatcher;
    }

    @Override
    public MatchingResult findServices(SearchProfile profile, Set<SemanticProfile> serviceList) {
        logger.fine("Hybrid matchmaking - begin");
        MatchingResult res = this.serviceSelection(profile, serviceList);
        if (this.props.getCompositionServiceLimit() > 1 && res.getBestProfile() != null && res.getBestProfile().getProfileRate() < this.props.getGeneralValidationRate()) {
            MatchingResult compoRes = this.serviceComposition(res, serviceList, new HashSet<Set<Operation>>());
            for (RatedSemanticProfile compo : compoRes.getResultProfiles()) {
                res.addResultProfile(compo);
            }
        }
        logger.fine("Hybrid matchmaking - end - " + res.getResultProfiles().size() + " results found");
        return res;
    }

    private MatchingResult serviceSelection(SearchProfile profile, Set<SemanticProfile> serviceList) {
        logger.fine("   Service selection - begin");
        MatchingResult hybridRes = null;
        if (this.props.getSemanticWeight() == 0.0) {
            hybridRes = this.syntacticMatcher.findServices(profile, serviceList);
        } else if (this.props.getSyntacticWeigth() == 0.0) {
            hybridRes = this.semanticMatcher.findServices(profile, serviceList);
        } else {
            hybridRes = new MatchingResultImpl(profile);
            MatchingResult semanticRes = this.semanticMatcher.findServices(profile, serviceList);
            MatchingResult syntacticRes = this.syntacticMatcher.findServices(profile, ProfileUtil.getSemanticProfiles(semanticRes.getResultProfiles()));
            for (RatedSemanticProfile synProfile : syntacticRes.getResultProfiles()) {
                RatedSemanticProfileImpl hybridProfile = new RatedSemanticProfileImpl(synProfile.getProfile());
                RatedSemanticProfile semProfile = semanticRes.findProfile(synProfile.getProfile());
                hybridProfile.setProfileRate(this.getHybridRate(semProfile.getProfileRate(), synProfile.getProfileRate()));
                hybridProfile.setOperationRate(this.getHybridRate(semProfile.getOperationRate(), synProfile.getOperationRate()));
                hybridProfile.setInputCoverage(semProfile.getInputCoverage());
                hybridProfile.setInputRate(this.getHybridRate(semProfile.getInputRate(), synProfile.getInputRate()));
                hybridProfile.setOutputCoverage(semProfile.getOutputCoverage());
                hybridProfile.setOutputRate(this.getHybridRate(semProfile.getOutputRate(), synProfile.getOutputRate()));
                hybridRes.addResultProfile((RatedSemanticProfile)hybridProfile);
            }
        }
        MatchingResultImpl res = new MatchingResultImpl(profile);
        for (RatedSemanticProfile rated : hybridRes.getResultProfiles()) {
            if (!(rated.getProfileRate() >= this.props.getHybridThreshold())) continue;
            res.addResultProfile(rated);
        }
        logger.fine("   Service selection - end - " + res.getResultProfiles().size() + " results found");
        System.out.println("   Service selection - end - " + res.getResultProfiles().size() + " results found");
        return res;
    }

    private MatchingResult serviceComposition(MatchingResult prevResult, Set<SemanticProfile> serviceList, Set<Set<Operation>> studiedOperationSets) {
        logger.fine("   Service composition - begin");
        MatchingResultImpl res = new MatchingResultImpl(prevResult.getQuery());
        for (RatedSemanticProfile baseProfile : prevResult.getResultProfiles()) {
            SearchProfile compoProfile = ProfileUtil.computeComplementaryProfile(prevResult.getQuery(), baseProfile.getProfile(), this.semanticMatcher.getReasoner(), this.props);
            HashSet<SemanticProfile> newServiceList = new HashSet<SemanticProfile>(serviceList);
            newServiceList.remove(baseProfile);
            MatchingResult compoResults = this.serviceSelection(compoProfile, newServiceList);
            for (RatedSemanticProfile compoResult : compoResults.getResultProfiles()) {
                HashSet<Operation> involvedOps = new HashSet<Operation>(baseProfile.getProfile().getOperations());
                involvedOps.addAll(compoResult.getProfile().getOperations());
                if (studiedOperationSets.contains(involvedOps)) continue;
                studiedOperationSets.add(involvedOps);
                HashSet<SemanticProfile> eqList = new HashSet<SemanticProfile>();
                try {
                    eqList.add(ProfileUtil.computeEquivalentProfile(involvedOps, this.registry, this.semanticMatcher.getReasoner(), this.props));
                }
                catch (CompositionException e) {
                    logger.warning("   Service composition - Loop detected with operations " + involvedOps);
                    continue;
                }
                MatchingResult eqRes = this.findServices(prevResult.getQuery(), eqList);
                if (!eqRes.hasCorrectProfile(baseProfile.getProfileRate())) continue;
                res.addResultProfile(eqRes.getBestProfile());
            }
            if (res.getResultProfiles().size() == 0) break;
            if (res.getBestProfile().getProfile().getOperations().size() >= this.props.getCompositionServiceLimit()) continue;
            logger.fine("   Service composition - level " + (res.getBestProfile().getProfile().getOperations().size() + 1));
            for (RatedSemanticProfile profile : this.serviceComposition(res, newServiceList, studiedOperationSets).getResultProfiles()) {
                res.addResultProfile(profile);
            }
        }
        logger.fine("   Service composition - end - " + res.getResultProfiles().size() + " results found");
        return res;
    }

    private double getHybridRate(double semanticRate, double syntacticRate) {
        return semanticRate * this.props.getSemanticWeight() + syntacticRate * this.props.getSyntacticWeigth();
    }
}

