/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher.similarity;

import com.petalslink.easiersbs.matching.service.api.matcher.similarity.SimilarityMeasure;
import com.petalslink.easiersbs.matching.service.matcher.similarity.DoubleVector;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractSimilarityMeasureImpl
implements SimilarityMeasure {
    protected static Logger logger = Logger.getLogger(AbstractSimilarityMeasureImpl.class.getName());
    private int levenshteinLimit = 0;

    protected Map<String, Integer> countWordFrequency(List<String> words) {
        HashMap<String, Integer> res = new HashMap<String, Integer>();
        for (String word : words) {
            if (res.containsKey(word)) {
                res.put(word, (Integer)res.get(word) + 1);
                continue;
            }
            boolean found = false;
            if (this.levenshteinLimit > 0 && word.length() > 3 && word.length() < 12) {
                for (String key : res.keySet()) {
                    if (Math.abs(key.length() - word.length()) > this.levenshteinLimit || StringUtils.getLevenshteinDistance((String)key, (String)word) > this.levenshteinLimit) continue;
                    res.put(key, (Integer)res.get(key) + 1);
                    found = true;
                }
            }
            if (found) continue;
            res.put(word, 1);
        }
        return res;
    }

    protected DoubleVector getProperVectors(Map<String, Integer> wordFrequencies1, Map<String, Integer> wordFrequencies2) {
        HashSet<String> words = new HashSet<String>();
        Map<String, String> closeWords = null;
        for (String w1 : wordFrequencies1.keySet()) {
            words.add(w1);
        }
        if (this.levenshteinLimit > 0) {
            closeWords = this.getCloseWords(wordFrequencies1.keySet(), wordFrequencies2.keySet());
            for (String w2 : wordFrequencies2.keySet()) {
                if (closeWords.containsKey(w2)) continue;
                words.add(w2);
            }
        } else {
            for (String w2 : wordFrequencies2.keySet()) {
                words.add(w2);
            }
        }
        int[] vector1 = new int[words.size()];
        int[] vector2 = new int[words.size()];
        int i = 0;
        for (String word : words) {
            vector1[i] = wordFrequencies1.containsKey(word) ? wordFrequencies1.get(word) : 0;
            if (this.levenshteinLimit > 0 && closeWords.containsValue(word)) {
                for (Map.Entry<String, String> entry : closeWords.entrySet()) {
                    if (!entry.getValue().equals(word)) continue;
                    int n = i;
                    vector2[n] = vector2[n] + wordFrequencies2.get(entry.getKey());
                }
            } else {
                vector2[i] = wordFrequencies2.containsKey(word) ? wordFrequencies2.get(word) : 0;
            }
            ++i;
        }
        return new DoubleVector(vector1, vector2);
    }

    private Map<String, String> getCloseWords(Set<String> words1, Set<String> words2) {
        HashMap<String, String> closeWords = new HashMap<String, String>();
        block0: for (String w1 : words1) {
            for (String w2 : words2) {
                if (w1.equals(w2)) {
                    closeWords.put(w2, w1);
                    continue;
                }
                if (w1.length() >= 12 || w2.length() >= 12 || Math.abs(w1.length() - w2.length()) > this.levenshteinLimit || StringUtils.getLevenshteinDistance((String)w1, (String)w2) > this.levenshteinLimit) continue;
                closeWords.put(w2, w1);
                continue block0;
            }
        }
        return closeWords;
    }

    public int getLevenshteinLimit() {
        return this.levenshteinLimit;
    }

    public void setLevenshteinLimit(int levenshteinLimit) {
        this.levenshteinLimit = levenshteinLimit > 2 ? 2 : levenshteinLimit;
    }
}

