/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher.similarity;

import com.petalslink.easiersbs.matching.service.matcher.similarity.AbstractSimilarityMeasureImpl;
import com.petalslink.easiersbs.matching.service.matcher.similarity.DoubleVector;
import java.util.List;
import java.util.Map;

public class DiceSimilarityImpl
extends AbstractSimilarityMeasureImpl {
    public DiceSimilarityImpl() {
    }

    public DiceSimilarityImpl(int levenshteinLimit) {
        super.setLevenshteinLimit(levenshteinLimit);
    }

    public double measureSimilarity(List<String> words1, List<String> words2) {
        if (words1.isEmpty() || words2.isEmpty()) {
            return 0.0;
        }
        Map<String, Integer> wordFrequencies1 = this.countWordFrequency(words1);
        Map<String, Integer> wordFrequencies2 = this.countWordFrequency(words2);
        DoubleVector vectors = this.getProperVectors(wordFrequencies1, wordFrequencies2);
        int commons = 0;
        int nbW1 = 0;
        int nbW2 = 0;
        for (int i = 0; i < vectors.length(); ++i) {
            if (vectors.getVector1()[i] != 0 && vectors.getVector2()[i] != 0) {
                ++commons;
                ++nbW1;
                ++nbW2;
                continue;
            }
            if (vectors.getVector1()[i] != 0) {
                ++nbW1;
                continue;
            }
            ++nbW2;
        }
        double res = 2.0 * (double)commons / (double)(nbW1 + nbW2);
        logger.finest("Dice's Coefficient similarity fully measured: " + res);
        return res;
    }
}

