/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.profile;

import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.profile.SearchElement;
import com.petalslink.easiersbs.matching.service.api.profile.SearchPart;
import com.petalslink.easiersbs.matching.service.api.profile.SearchProfile;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredProfile;
import com.petalslink.easiersbs.matching.service.profile.SearchPartImpl;
import com.petalslink.easiersbs.matching.service.profile.inferred.InferredProfileImpl;
import com.petalslink.easiersbs.matching.service.util.ProfileUtil;
import com.petalslink.easiersbs.reasoner.api.engine.Reasoner;
import com.petalslink.easiersbs.registry.service.api.model.SemanticElement;
import com.petalslink.easiersbs.registry.service.api.model.SemanticPart;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericElement;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericPart;
import com.petalslink.easiersbs.registry.service.impl.model.generic.GenericProfileImpl;

public class SearchProfileImpl
extends GenericProfileImpl<SearchPart, SearchElement>
implements SearchProfile {
    public SearchProfileImpl() {
    }

    public SearchProfileImpl(SemanticProfile profile) {
        this.partner = profile.getPartner();
        this.operations = profile.getOperations();
        this.semanticInterface = new SearchPartImpl((SemanticPart)profile.getSemanticInterface());
        this.semanticOperation = new SearchPartImpl((SemanticPart)profile.getSemanticOperation());
        this.semanticInput = ProfileUtil.convertSemanticElement((SemanticElement)profile.getInputSemanticElement());
        if (profile.getOutputSemanticElement() != null) {
            this.semanticOutput = ProfileUtil.convertSemanticElement((SemanticElement)profile.getOutputSemanticElement());
        }
    }

    public SearchProfileImpl(SearchPart semanticInterface, SearchPart semanticOperation, SearchElement semanticInput, SearchElement semanticOutput) {
        this.semanticInterface = semanticInterface;
        this.semanticOperation = semanticOperation;
        this.semanticInput = semanticInput;
        this.semanticOutput = semanticOutput;
    }

    public InferredProfile infer(Reasoner reasoner, MatcherProperties props) {
        InferredProfileImpl result = new InferredProfileImpl();
        result.setPartner(this.partner);
        if (this.semanticInterface != null) {
            result.setSemanticInterface((GenericPart)((SearchPart)this.semanticInterface).infer(reasoner, props));
        }
        if (this.semanticOperation != null) {
            result.setSemanticOperation((GenericPart)((SearchPart)this.semanticOperation).infer(reasoner, props));
        }
        if (this.semanticInput != null) {
            result.setInputSemanticElement((GenericElement)((SearchElement)this.semanticInput).infer(reasoner, props));
        }
        if (this.semanticOutput != null) {
            result.setOutputSemanticElement((GenericElement)((SearchElement)this.semanticOutput).infer(reasoner, props));
        }
        return result;
    }

    public boolean equals(Object other) {
        if (other instanceof SearchProfile) {
            return !(this.semanticInterface != null && !((SearchPart)this.semanticInterface).equals(((SearchProfile)other).getSemanticInterface()) || this.semanticOperation != null && !((SearchPart)this.semanticOperation).equals(((SearchProfile)other).getSemanticOperation()) || this.semanticInput != null && !((SearchElement)this.semanticInput).equals(((SearchProfile)other).getInputSemanticElement())) && (this.semanticOutput == null || ((SearchElement)this.semanticOutput).equals(((SearchProfile)other).getOutputSemanticElement()));
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        String res = "SearchProfile";
        res = res + super.toString();
        return res;
    }
}

