/*
 * Decompiled with CFR 0.152.
 */
package org.example.nrbc;

import com.ebmwebsourcing.easiestdemo.helper.BusManagement;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import esstar.petalslink.com.service.management._1_0.ManagementException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Scanner;
import java.util.logging.LogManager;
import javax.xml.namespace.QName;
import org.example.dde.Dde_WSOUIServer;
import org.example.drire.Drire_WSOUIServer;
import org.example.fireman.Fireman_WSOUIServer;
import org.example.military.Military_WSOUIServer;
import org.example.prefect.Prefect_WSOUIServer;
import org.example.samu.Samu_WSOUIServer;
import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;

public class NrbcBPEL_Main {
    public static final URL BPEL_LOCATION = Thread.currentThread().getContextClassLoader().getResource("nrbc.bpel");
    private Drire_WSOUIServer drire_WSOUIServer = null;
    private Military_WSOUIServer military_WSOUIServer = null;
    private Dde_WSOUIServer dde_WSOUIServer = null;
    private Samu_WSOUIServer samu_WSOUIServer = null;
    private Prefect_WSOUIServer prefect_WSOUIServer = null;
    private Fireman_WSOUIServer fireman_WSOUIServer = null;
    private Node node = null;
    private QName nodeName = new QName("http://www.example.org/nrbc", "nrbcBPEL_EasyESBNode");
    private String nodeHost = "localhost";
    private int nodeInternalPort = 8000;
    private int nodeSoapPort = 8085;
    private String adminUrl = "http://" + this.nodeHost + ":" + this.nodeSoapPort + "/services/adminExternalEndpoint";
    private static boolean standalone;

    public static void main(String[] args) throws Exception {
        NrbcBPEL_Main main = new NrbcBPEL_Main();
        PrintStream err = System.err;
        try {
            boolean activeGUI = true;
            NrbcBPEL_Main.analyzeCommand(args);
            main.startAllWebServices();
            main.setGUIOnAllWebServices(activeGUI);
            main.createNode();
            List<URL> bpelUrls = main.deployAndExposeBPEL(BPEL_LOCATION);
            if (activeGUI) {
                main.createClient();
            }
            Scanner sc = new Scanner(System.in);
            System.out.println("Hit Enter to exit :");
            sc.nextLine();
        }
        catch (Exception e) {
            e.printStackTrace(err);
            main.stopAllWebServices();
            main.stopNode();
        }
    }

    public static void analyzeCommand(String[] args) {
        if (args != null && args.length == 1 && args[0].equals("standalone")) {
            standalone = true;
        }
    }

    public boolean isStandalone() {
        return standalone;
    }

    public void createNode() throws ESBException {
        this.node = BusManagement.getInstance().createNode(this.nodeName, this.nodeHost, this.nodeInternalPort, this.nodeSoapPort);
    }

    public List<URL> deployAndExposeBPEL(URL bpel) throws MalformedURLException, ManagementException {
        List urls = BusManagement.getInstance().deployAndExposeBPEL(bpel, new URL(this.adminUrl));
        System.out.println("BPEL " + bpel + " are exposed at url:");
        for (URL url : urls) {
            System.out.println("\t" + url);
        }
        return urls;
    }

    public void stopNode() throws TransportException {
        this.node.stop();
    }

    public void startAllWebServices() throws WSOUIException {
        if (!this.isStandalone()) {
            this.drire_WSOUIServer = new Drire_WSOUIServer();
            this.drire_WSOUIServer.start();
            this.military_WSOUIServer = new Military_WSOUIServer();
            this.military_WSOUIServer.start();
            this.dde_WSOUIServer = new Dde_WSOUIServer();
            this.dde_WSOUIServer.start();
            this.samu_WSOUIServer = new Samu_WSOUIServer();
            this.samu_WSOUIServer.start();
            this.prefect_WSOUIServer = new Prefect_WSOUIServer();
            this.prefect_WSOUIServer.start();
            this.fireman_WSOUIServer = new Fireman_WSOUIServer();
            this.fireman_WSOUIServer.start();
        }
    }

    public void createClient() throws WSOUIException {
        try {
            WSOUIClient client = new WSOUIClient();
            org.petalslink.easiestdemo.client.model.api.esb.Node n = client.addNewAdminWsdlofESBNode(new URL[]{new URL(this.adminUrl + "?wsdl")});
            n.setModel(this.node);
            client.setVisible(true);
        }
        catch (MalformedURLException e) {
            throw new WSOUIException((Throwable)e);
        }
        catch (WSOUIClientException e) {
            throw new WSOUIException((Throwable)e);
        }
    }

    public void setGUIOnAllWebServices(boolean activeGUI) throws WSOUIException {
        if (!this.isStandalone()) {
            if (this.drire_WSOUIServer != null) {
                this.drire_WSOUIServer.getProviderConfigurationFor_Drire().setActiveGui(activeGUI);
            }
            if (this.military_WSOUIServer != null) {
                this.military_WSOUIServer.getProviderConfigurationFor_Military().setActiveGui(activeGUI);
            }
            if (this.dde_WSOUIServer != null) {
                this.dde_WSOUIServer.getProviderConfigurationFor_Dde().setActiveGui(activeGUI);
            }
            if (this.samu_WSOUIServer != null) {
                this.samu_WSOUIServer.getProviderConfigurationFor_Samu().setActiveGui(activeGUI);
            }
            if (this.prefect_WSOUIServer != null) {
                this.prefect_WSOUIServer.getProviderConfigurationFor_Prefect().setActiveGui(activeGUI);
            }
            if (this.fireman_WSOUIServer != null) {
                this.fireman_WSOUIServer.getProviderConfigurationFor_Fireman().setActiveGui(activeGUI);
            }
        }
    }

    public void stopAllWebServices() {
        if (!this.isStandalone()) {
            if (this.drire_WSOUIServer != null) {
                this.drire_WSOUIServer.stop();
            }
            if (this.military_WSOUIServer != null) {
                this.military_WSOUIServer.stop();
            }
            if (this.dde_WSOUIServer != null) {
                this.dde_WSOUIServer.stop();
            }
            if (this.samu_WSOUIServer != null) {
                this.samu_WSOUIServer.stop();
            }
            if (this.prefect_WSOUIServer != null) {
                this.prefect_WSOUIServer.stop();
            }
            if (this.fireman_WSOUIServer != null) {
                this.fireman_WSOUIServer.stop();
            }
        }
    }

    static {
        try {
            InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("logger/easiestdemo-logging.properties");
            LogManager.getLogManager().readConfiguration(configFile);
        }
        catch (Exception ex) {
            System.out.println("WARNING: Could not open configuration file");
            System.out.println("WARNING: Logging not configured (console output only)");
        }
        standalone = false;
    }
}

