/*
 * Decompiled with CFR 0.152.
 */
package org.example.prefect;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.logging.LogManager;
import javax.xml.ws.Endpoint;
import org.example.prefect.PrefectImplementationManager;
import org.example.prefect.PrefectTestImplementation;
import org.example.prefect.Prefect_ExchangeProcessor;
import org.example.prefect.Prefect_WSOUIService;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.provided.AbstractImplementationManager;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;

public class Prefect_WSOUIServer {
    private static final String LOGGER_FILE = "/logger.properties";
    private Endpoint endpointFor_Prefect = null;
    private ProviderConfiguration confEndpointFor_Prefect = null;
    private AbstractImplementationManager<?> im = null;

    public ProviderConfiguration createDefaultProviderConfigurationFor_Prefect() {
        ProviderConfiguration conf = new ProviderConfiguration();
        conf.setEndpointAddress("http://localhost:9001/prefect_prefectSOAP");
        conf.setImage(Thread.currentThread().getContextClassLoader().getResource("bpel2java/nrbc/images/prefect.jpg"));
        conf.setPosition(ProviderConfiguration.PositionType.NORTH_WEST);
        conf.setActiveGui(false);
        return conf;
    }

    public ProviderConfiguration getProviderConfigurationFor_Prefect() {
        if (this.confEndpointFor_Prefect == null) {
            this.confEndpointFor_Prefect = this.createDefaultProviderConfigurationFor_Prefect();
        }
        return this.confEndpointFor_Prefect;
    }

    public void start() throws WSOUIException {
        this.confEndpointFor_Prefect = this.getProviderConfigurationFor_Prefect();
        this.im = new PrefectImplementationManager(new PrefectTestImplementation(new Prefect_ExchangeProcessor()), Prefect_WSOUIService.getWSDL_LOCATION(), this.confEndpointFor_Prefect);
        this.endpointFor_Prefect = Endpoint.publish((String)this.confEndpointFor_Prefect.getEndpointAddress(), this.im);
        System.out.println("Service deploy at: " + this.confEndpointFor_Prefect.getEndpointAddress() + "?wsdl");
        System.out.println("Service Configuration: " + this.confEndpointFor_Prefect);
    }

    public void stop() {
        if (this.endpointFor_Prefect != null) {
            this.endpointFor_Prefect.stop();
        }
    }

    public Description getDescription() {
        return this.im.getDescription();
    }

    public static void main(String[] args) throws Exception {
        Prefect_WSOUIServer provider = new Prefect_WSOUIServer();
        provider.start();
        boolean gui = false;
        if (args.length > 0) {
            System.out.print("Commands args: ");
            for (int i = 0; i < args.length; ++i) {
                System.out.print(args[i]);
            }
            System.out.println();
            gui = Boolean.parseBoolean(args[0]);
            System.out.println("gui: " + gui);
        }
        provider.getProviderConfigurationFor_Prefect().setActiveGui(gui);
        System.out.println("Server ready...");
    }

    static {
        try {
            InputStream inputStream = null;
            File logger = new File("./logger.properties");
            inputStream = logger.exists() ? new FileInputStream(logger) : Prefect_WSOUIServer.class.getClass().getResourceAsStream(LOGGER_FILE);
            if (inputStream != null) {
                LogManager.getLogManager().readConfiguration(inputStream);
                inputStream.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("couldn't initialize logging properly", e);
        }
    }
}

