/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.cli;

import com.ebmwebsourcing.easybox.api.Catalog;
import com.ebmwebsourcing.easybox.api.ObjectUnderTestFactory;
import com.ebmwebsourcing.easybox.api.TestRuntimeException;
import com.ebmwebsourcing.easybox.api.TestXmlContext;
import com.ebmwebsourcing.easybox.cli.Validator;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;

public class ValidatorUnderTestFactory
implements ObjectUnderTestFactory {
    private final String urlStr;
    private final Catalog catalog;

    public ValidatorUnderTestFactory(String xmlObjectInterfaceClassStr, String testResourcePath, String[] testCatalogPaths) {
        this.urlStr = this.getClass().getClassLoader().getResource(testResourcePath).toString();
        this.catalog = new Catalog();
        for (String testCatalogPath : testCatalogPaths) {
            File catalogFile = new File(this.getClass().getClassLoader().getResource(testCatalogPath).getFile());
            this.catalog.addCatalogFile(catalogFile);
        }
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public Validator newObjectUnderTest() {
        try {
            Validator validator = new Validator(System.out, System.err, TestXmlContext.DEFAULT_XML_CONTEXT, this.urlStr);
            validator.setEntityResolver(this.catalog.newEntityResolver());
            return validator;
        }
        catch (MalformedURLException e) {
            throw new TestRuntimeException("Cannot create validator (MalformedURLException).", (Throwable)e);
        }
        catch (IOException e) {
            throw new TestRuntimeException("Cannot create validator (IOException).", (Throwable)e);
        }
    }
}

