/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.cli;

import com.ebmwebsourcing.easybox.api.Catalog;
import com.ebmwebsourcing.easybox.api.ObjectUnderTestFactory;
import com.ebmwebsourcing.easybox.api.TestRuntimeException;
import com.ebmwebsourcing.easybox.api.TestXmlContext;
import com.ebmwebsourcing.easybox.cli.XPathEvaluator;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;

public class XPathEvaluatorUnderTestFactory
implements ObjectUnderTestFactory {
    private final String urlStr;
    private final String xpathExpression;
    private final Catalog catalog;

    public XPathEvaluatorUnderTestFactory(String testResourcePath, String xpathExpression, String[] testCatalogPaths) {
        this.urlStr = this.getClass().getClassLoader().getResource(testResourcePath).toString();
        this.xpathExpression = xpathExpression;
        this.catalog = new Catalog();
        for (String testCatalogPath : testCatalogPaths) {
            File catalogFile = new File(this.getClass().getClassLoader().getResource(testCatalogPath).getFile());
            this.catalog.addCatalogFile(catalogFile);
        }
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public XPathEvaluator newObjectUnderTest() {
        try {
            XPathEvaluator xpathEvaluator = new XPathEvaluator(System.out, System.err, TestXmlContext.DEFAULT_XML_CONTEXT, this.urlStr, this.xpathExpression);
            xpathEvaluator.setEntityResolver(this.catalog.newEntityResolver());
            return xpathEvaluator;
        }
        catch (MalformedURLException e) {
            throw new TestRuntimeException("Cannot create xpathEvaluator (MalformedURLException).", (Throwable)e);
        }
        catch (IOException e) {
            throw new TestRuntimeException("Cannot create xpathEvaluator (IOException).", (Throwable)e);
        }
    }
}

