/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.cli;

import com.ebmwebsourcing.easybox.api.XQueryValidationRule;
import com.ebmwebsourcing.easybox.cli.XQueryValidationRuleInputStreamBuilder;
import com.ebmwebsourcing.easybox.cli.XQueryValidationRuleParsingException;
import java.io.IOException;
import java.net.URL;
import org.junit.Assert;
import org.junit.Test;

public class XQueryValidationRuleInputStreamBuilderTest {
    @Test
    public void testBuildRuleOK0() throws IOException, XQueryValidationRuleParsingException {
        URL ruleFileURL = this.getClass().getClassLoader().getResource("xquery-rule-ok-0.xq");
        XQueryValidationRuleInputStreamBuilder builder = new XQueryValidationRuleInputStreamBuilder(ruleFileURL.openStream());
        XQueryValidationRule validationRule = builder.build();
        XQueryValidationRule expectedValidationRule = new XQueryValidationRule("rule0", "This is a description of rule0.", "(:\nname:           rule0\ndescription:    This is a description of rule0.\n:)\nlet $NODES := //*\nlet $RESULT := false()\nreturn ($NODES, $RESULT)\n");
        Assert.assertEquals((Object)expectedValidationRule, (Object)validationRule);
    }

    @Test(expected=XQueryValidationRuleParsingException.class)
    public void testBuildRuleKONoName0() throws IOException, XQueryValidationRuleParsingException {
        URL ruleFileURL = this.getClass().getClassLoader().getResource("xquery-rule-ko-noname-0.xq");
        XQueryValidationRuleInputStreamBuilder builder = new XQueryValidationRuleInputStreamBuilder(ruleFileURL.openStream());
        builder.build();
    }

    @Test(expected=XQueryValidationRuleParsingException.class)
    public void testBuildRuleKOEmptyName0() throws IOException, XQueryValidationRuleParsingException {
        URL ruleFileURL = this.getClass().getClassLoader().getResource("xquery-rule-ko-emptyname-0.xq");
        XQueryValidationRuleInputStreamBuilder builder = new XQueryValidationRuleInputStreamBuilder(ruleFileURL.openStream());
        builder.build();
    }

    @Test(expected=XQueryValidationRuleParsingException.class)
    public void testBuildRuleKONoDescription0() throws IOException, XQueryValidationRuleParsingException {
        URL ruleFileURL = this.getClass().getClassLoader().getResource("xquery-rule-ko-nodescription-0.xq");
        XQueryValidationRuleInputStreamBuilder builder = new XQueryValidationRuleInputStreamBuilder(ruleFileURL.openStream());
        builder.build();
    }

    @Test(expected=XQueryValidationRuleParsingException.class)
    public void testBuildRuleKOEmptyDescription0() throws IOException, XQueryValidationRuleParsingException {
        URL ruleFileURL = this.getClass().getClassLoader().getResource("xquery-rule-ko-emptydescription-0.xq");
        XQueryValidationRuleInputStreamBuilder builder = new XQueryValidationRuleInputStreamBuilder(ruleFileURL.openStream());
        builder.build();
    }

    @Test(expected=XQueryValidationRuleParsingException.class)
    public void testBuildRuleKOEmptyXQuery0() throws IOException, XQueryValidationRuleParsingException {
        URL ruleFileURL = this.getClass().getClassLoader().getResource("xquery-rule-ko-emptydescription-0.xq");
        XQueryValidationRuleInputStreamBuilder builder = new XQueryValidationRuleInputStreamBuilder(ruleFileURL.openStream());
        builder.build();
    }
}

