/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.cli;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easybox.api.XmlObjectValidationException;
import com.ebmwebsourcing.easybox.api.XmlObjectValidator;
import com.ebmwebsourcing.easybox.cli.ValidatorResult;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class Validator
implements ErrorHandler {
    static final String INTERFACE_OPT = "-i";
    static final String FILE_OPT = "-f";
    static final int OK_EXITCODE = 0;
    static final int BAD_USAGE_EXITCODE = 1;
    static final int VALIDATION_FAILED_EXITCODE = 2;
    static final int UNKNOWN_ERROR_EXITCODE = 3;
    private final PrintStream outStream;
    private final PrintStream errStream;
    private final XmlContext xmlContext;
    private final URL url;
    private final ValidatorResult result;
    private EntityResolver entityResolver;

    Validator(PrintStream outStream, PrintStream errStream, XmlContext xmlContext, String urlStr) throws MalformedURLException, IOException {
        this.outStream = outStream;
        this.errStream = errStream;
        this.xmlContext = xmlContext;
        this.url = Validator.createURL(urlStr);
        this.result = new ValidatorResult();
    }

    private static URL createURL(String urlStr) throws MalformedURLException, IOException {
        URL url = null;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException mue) {
            // empty catch block
        }
        if (url != null) {
            return url;
        }
        File file = new File(urlStr);
        return new URL("file", "", file.getCanonicalPath());
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public ValidatorResult getResult() {
        return this.result;
    }

    public void run() throws XmlObjectReadException, XmlObjectValidationException {
        long timeTaken = System.currentTimeMillis();
        this.writeToOut(String.format("Validating %s...", this.url.toString()));
        XmlObjectReader reader = this.xmlContext.createReader();
        reader.setEntityResolver(this.entityResolver);
        XmlObject xmlObject = reader.readDocument(this.url, XmlObject.class);
        XmlObjectValidator validator = this.xmlContext.createValidator();
        validator.validate(xmlObject, (ErrorHandler)this);
        timeTaken = System.currentTimeMillis() - timeTaken;
        this.writeToOut(String.format("Validation %s and took %d ms; %s.", this.result.success() ? "succeeded" : "failed", timeTaken, this.result.toString()));
    }

    private void writeToErr(String errorLevel, SAXParseException exception) {
        this.errStream.println(String.format("[%s] : %s", errorLevel, exception.getMessage()));
    }

    private void writeToOut(String message) {
        this.outStream.println(message);
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.writeToErr("ERROR", exception);
        this.result.increaseErrorsCount();
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.writeToErr("FATAL", exception);
        this.result.increaseFatalErrorsCount();
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.writeToErr("WARNING", exception);
        this.result.increaseWarningsCount();
    }

    public static void error(String errorMessage) {
        System.err.println(errorMessage);
    }

    public static void printUsage() {
        System.out.println(String.format("usage: java -cp CLASSPATH %s %s INTERFACE %s FILE", Validator.class.getName(), INTERFACE_OPT, FILE_OPT));
    }

    public static void main(String[] args) {
        if (args.length != 4 || !INTERFACE_OPT.equals(args[0]) || !FILE_OPT.equals(args[2])) {
            Validator.printUsage();
            System.exit(1);
        }
        String urlStr = args[3];
        XmlContextFactory xmlContextFactory = new XmlContextFactory();
        XmlContext xmlContext = xmlContextFactory.newContext();
        try {
            Validator validator = new Validator(System.out, System.err, xmlContext, urlStr);
            validator.run();
            System.exit(validator.result.success() ? 2 : 0);
        }
        catch (MalformedURLException mue) {
            Validator.error(String.format("Cannot find '%s'.", urlStr));
            System.exit(1);
        }
        catch (IOException e) {
            Validator.error(String.format("Cannot find '%s'.", urlStr));
            System.exit(1);
        }
        catch (XmlObjectValidationException xove) {
            Validator.error("Unexpected validation exception : " + xove.getMessage());
            System.exit(3);
        }
        catch (XmlObjectReadException xore) {
            Validator.error("Unexpected exception : " + xore.getMessage());
            System.exit(3);
        }
    }
}

