/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.cli;

public final class ValidatorResult {
    private int warningsCount;
    private int errorsCount;
    private int fatalErrorsCount;

    public ValidatorResult(int warningsCount, int errorsCount, int fatalErrorsCount) {
        this.warningsCount = warningsCount;
        this.errorsCount = errorsCount;
        this.fatalErrorsCount = fatalErrorsCount;
    }

    public ValidatorResult() {
        this(0, 0, 0);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.errorsCount;
        result = 31 * result + this.fatalErrorsCount;
        result = 31 * result + this.warningsCount;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidatorResult other = (ValidatorResult)obj;
        if (this.errorsCount != other.errorsCount) {
            return false;
        }
        if (this.fatalErrorsCount != other.fatalErrorsCount) {
            return false;
        }
        return this.warningsCount == other.warningsCount;
    }

    void increaseWarningsCount() {
        ++this.warningsCount;
    }

    void increaseErrorsCount() {
        ++this.errorsCount;
    }

    void increaseFatalErrorsCount() {
        ++this.fatalErrorsCount;
    }

    public int getWarningsCount() {
        return this.warningsCount;
    }

    public int getErrorsCount() {
        return this.errorsCount;
    }

    public int getFatalErrorsCount() {
        return this.fatalErrorsCount;
    }

    public boolean success() {
        return this.errorsCount + this.fatalErrorsCount == 0;
    }

    public String toString() {
        return String.format("%d fatal error(s), %d error(s), %d warning(s)", this.getFatalErrorsCount(), this.getErrorsCount(), this.getWarningsCount());
    }
}

