/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.cli;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easybox.api.XmlObjectXPathEvaluator;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.xpath.XPathExpressionException;
import org.xml.sax.EntityResolver;

public final class XPathEvaluator {
    static final String FILE_OPT = "-f";
    static final String XPATH_EXPRESSION_OPT = "-x";
    static final int OK_EXITCODE = 0;
    static final int BAD_USAGE_EXITCODE = 1;
    static final int INVALID_XPATH_EXPRESSION_EXITCODE = 2;
    static final int UNKNOWN_ERROR_EXITCODE = 3;
    private final PrintStream outStream;
    private final PrintStream errStream;
    private final XmlContext xmlContext;
    private final URL url;
    private final String xpathExpression;
    private XmlObjectNode[] result;
    private EntityResolver entityResolver;

    XPathEvaluator(PrintStream outStream, PrintStream errStream, XmlContext xmlContext, String urlStr, String xpathExpression) throws MalformedURLException, IOException {
        this.outStream = outStream;
        this.errStream = errStream;
        this.xmlContext = xmlContext;
        this.url = XPathEvaluator.createURL(urlStr);
        this.xpathExpression = xpathExpression;
        this.result = null;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    private static URL createURL(String urlStr) throws MalformedURLException, IOException {
        URL url = null;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException mue) {
            // empty catch block
        }
        if (url != null) {
            return url;
        }
        File file = new File(urlStr);
        return new URL("file", "", file.getCanonicalPath());
    }

    public void run() throws XmlObjectReadException, XPathExpressionException {
        this.writeToOut(String.format("Evaluating XPath expression %s on %s...", this.xpathExpression, this.url.toString()));
        XmlObjectReader reader = this.xmlContext.createReader();
        reader.setReadMode(XmlObjectReader.ReadMode.LAZY);
        reader.setEntityResolver(this.entityResolver);
        XmlObject xmlObject = reader.readDocument(this.url, XmlObject.class);
        XmlObjectXPathEvaluator xpathEvaluator = this.xmlContext.createXPathEvaluator();
        long timeTaken = System.currentTimeMillis();
        this.result = xpathEvaluator.selectXmlObjectNodes(xmlObject, this.xpathExpression, XmlObjectNode.class);
        timeTaken = System.currentTimeMillis() - timeTaken;
        this.writeToOut(String.format("XPath evaluation returned %d node(s) and took %d ms.", this.result.length, timeTaken));
    }

    public XmlObjectNode[] getResult() {
        return this.result;
    }

    private void writeToOut(String message) {
        this.outStream.println(message);
    }

    public static void error(String errorMessage) {
        System.err.println(errorMessage);
    }

    public static void printUsage() {
        System.out.println(String.format("usage: java -cp CLASSPATH %s %s FILE %s XPATHEXP", XPathEvaluator.class.getName(), FILE_OPT, XPATH_EXPRESSION_OPT));
    }

    public static void main(String[] args) {
        if (args.length != 4 || !FILE_OPT.equals(args[0]) || !XPATH_EXPRESSION_OPT.equals(args[2])) {
            XPathEvaluator.printUsage();
            System.exit(1);
        }
        String urlStr = args[1];
        String xpathExpression = args[3];
        XmlContextFactory xmlContextFactory = new XmlContextFactory();
        XmlContext xmlContext = xmlContextFactory.newContext();
        try {
            XPathEvaluator xpathEvaluator = new XPathEvaluator(System.out, System.err, xmlContext, urlStr, xpathExpression);
            xpathEvaluator.run();
            System.exit(0);
        }
        catch (MalformedURLException mue) {
            XPathEvaluator.error(String.format("Cannot find '%s'.", urlStr));
            System.exit(1);
        }
        catch (IOException e) {
            XPathEvaluator.error(String.format("Cannot find '%s'.", urlStr));
            System.exit(1);
        }
        catch (XPathExpressionException xee) {
            XPathEvaluator.error("Invalid XPath Expression : " + xee.getMessage());
            System.exit(2);
        }
        catch (XmlObjectReadException e) {
            XPathEvaluator.error(e.getMessage());
            System.exit(3);
        }
    }
}

