/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.cli;

import com.ebmwebsourcing.easybox.api.XQueryException;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easybox.api.XmlObjectXQueryEvaluator;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.xml.sax.EntityResolver;

public final class XQueryEvaluator {
    static final String FILE_OPT = "-f";
    static final String XQUERY_EXPRESSION_OPT = "-x";
    static final int OK_EXITCODE = 0;
    static final int BAD_USAGE_EXITCODE = 1;
    static final int INVALID_XQUERY_EXPRESSION_EXITCODE = 2;
    static final int UNKNOWN_ERROR_EXITCODE = 3;
    private final PrintStream outStream;
    private final PrintStream errStream;
    private final XmlContext xmlContext;
    private final URL url;
    private final String xqueryExpression;
    private List<?> result;
    private EntityResolver entityResolver;

    XQueryEvaluator(PrintStream outStream, PrintStream errStream, XmlContext xmlContext, String urlStr, String xqueryExpression) throws MalformedURLException, IOException {
        this.outStream = outStream;
        this.errStream = errStream;
        this.xmlContext = xmlContext;
        this.url = XQueryEvaluator.createURL(urlStr);
        this.xqueryExpression = xqueryExpression;
        this.result = null;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    private static URL createURL(String urlStr) throws MalformedURLException, IOException {
        URL url = null;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException mue) {
            // empty catch block
        }
        if (url != null) {
            return url;
        }
        File file = new File(urlStr);
        return new URL("file", "", file.getCanonicalPath());
    }

    public void run() throws XmlObjectReadException, XQueryException {
        this.writeToOut(String.format("Evaluating XQuery expression %s on %s...", this.xqueryExpression, this.url.toString()));
        XmlObjectReader reader = this.xmlContext.createReader();
        reader.setReadMode(XmlObjectReader.ReadMode.LAZY);
        reader.setEntityResolver(this.entityResolver);
        XmlObject xmlObject = reader.readDocument(this.url, XmlObject.class);
        XmlObjectXQueryEvaluator xqueryEvaluator = this.xmlContext.createXQueryEvaluator();
        this.result = xqueryEvaluator.evaluate(xmlObject, this.xqueryExpression);
        for (Object o : this.result) {
            this.writeToOut(String.valueOf(o));
        }
    }

    public List<?> getResult() {
        return this.result;
    }

    private void writeToOut(String message) {
        this.outStream.println(message);
    }

    public static void error(String errorMessage) {
        System.err.println(errorMessage);
    }

    public static void printUsage() {
        System.out.println(String.format("usage: java -cp CLASSPATH %s %s FILE %s XQUERYEXP", XQueryEvaluator.class.getName(), FILE_OPT, XQUERY_EXPRESSION_OPT));
    }

    public static void main(String[] args) {
        if (args.length != 4 || !FILE_OPT.equals(args[0]) || !XQUERY_EXPRESSION_OPT.equals(args[2])) {
            XQueryEvaluator.printUsage();
            System.exit(1);
        }
        String urlStr = args[1];
        String xqueryExpression = args[3];
        XmlContextFactory xmlContextFactory = new XmlContextFactory();
        XmlContext xmlContext = xmlContextFactory.newContext();
        try {
            XQueryEvaluator xqueryEvaluator = new XQueryEvaluator(System.out, System.err, xmlContext, urlStr, xqueryExpression);
            xqueryEvaluator.run();
            System.exit(0);
        }
        catch (MalformedURLException mue) {
            XQueryEvaluator.error(String.format("Cannot find '%s'.", urlStr));
            System.exit(1);
        }
        catch (IOException e) {
            XQueryEvaluator.error(String.format("Cannot find '%s'.", urlStr));
            System.exit(1);
        }
        catch (XQueryException xqe) {
            XQueryEvaluator.error("Invalid XQuery Expression : " + xqe.getMessage());
            System.exit(2);
        }
        catch (XmlObjectReadException e) {
            XQueryEvaluator.error(e.getMessage());
            System.exit(3);
        }
    }
}

