/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.cli;

import com.ebmwebsourcing.easybox.api.XQueryException;
import com.ebmwebsourcing.easybox.api.XQueryValidationProfile;
import com.ebmwebsourcing.easybox.api.XQueryValidationReport;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easybox.api.XmlObjectXQueryValidator;
import com.ebmwebsourcing.easybox.cli.XQueryValidationProfileDirBuilder;
import com.ebmwebsourcing.easybox.cli.XQueryValidationProfileParsingException;
import com.ebmwebsourcing.easybox.cli.XQueryValidationProfileZipBuilder;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.xml.sax.EntityResolver;

public final class XQueryProfileValidator {
    static final String FILE_OPT = "-f";
    static final String XQUERYVALIDATIONPROFILE_OPT = "-p";
    static final int OK_EXITCODE = 0;
    static final int BAD_USAGE_EXITCODE = 1;
    static final int INVALID_XQUERYVALIDATIONPROFILE_EXITCODE = 2;
    static final int UNKNOWN_ERROR_EXITCODE = 3;
    private final PrintStream outStream;
    private final PrintStream errStream;
    private final XmlContext xmlContext;
    private final URL url;
    private final File validationProfileFile;
    private List<?> result;
    private EntityResolver entityResolver;

    XQueryProfileValidator(PrintStream outStream, PrintStream errStream, XmlContext xmlContext, String urlStr, String validationProfileFilePath) throws MalformedURLException, IOException {
        this.outStream = outStream;
        this.errStream = errStream;
        this.xmlContext = xmlContext;
        this.url = XQueryProfileValidator.createURL(urlStr);
        this.validationProfileFile = new File(validationProfileFilePath);
        this.result = null;
    }

    private static URL createURL(String urlStr) throws MalformedURLException, IOException {
        URL url = null;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException mue) {
            // empty catch block
        }
        if (url != null) {
            return url;
        }
        File file = new File(urlStr);
        return new URL("file", "", file.getCanonicalPath());
    }

    private XQueryValidationProfile buildProfileFromDir() throws XQueryValidationProfileParsingException {
        assert (this.validationProfileFile.isDirectory());
        XQueryValidationProfileDirBuilder builder = new XQueryValidationProfileDirBuilder(this.validationProfileFile);
        return builder.build();
    }

    private XQueryValidationProfile buildProfileFromZip() throws XQueryValidationProfileParsingException {
        assert (this.validationProfileFile.isFile());
        XQueryValidationProfileZipBuilder builder = new XQueryValidationProfileZipBuilder(this.validationProfileFile);
        return builder.build();
    }

    public void run() throws XmlObjectReadException, XQueryException, XQueryValidationProfileParsingException {
        XQueryValidationProfile profile;
        XQueryValidationProfile xQueryValidationProfile = profile = this.validationProfileFile.isDirectory() ? this.buildProfileFromDir() : this.buildProfileFromZip();
        assert (profile != null);
        XmlObjectReader reader = this.xmlContext.createReader();
        reader.setReadMode(XmlObjectReader.ReadMode.LAZY);
        reader.setEntityResolver(this.entityResolver);
        XmlObject xmlObject = reader.readDocument(this.url, XmlObject.class);
        XmlObjectXQueryValidator validator = this.xmlContext.createXQueryValidator();
        XQueryValidationReport report = validator.validate(xmlObject, profile);
        this.writeToOut(report.toString());
    }

    public List<?> getResult() {
        return this.result;
    }

    private void writeToOut(String message) {
        this.outStream.println(message);
    }

    public static void error(String errorMessage) {
        System.err.println(errorMessage);
    }

    public static void printUsage() {
        System.out.println(String.format("usage: java -cp CLASSPATH %s %s FILE %s PROFILE_ZIP_OR_DIR", XQueryProfileValidator.class.getName(), FILE_OPT, XQUERYVALIDATIONPROFILE_OPT));
    }

    public static void main(String[] args) {
        if (args.length != 4 || !FILE_OPT.equals(args[0]) || !XQUERYVALIDATIONPROFILE_OPT.equals(args[2])) {
            XQueryProfileValidator.printUsage();
            System.exit(1);
        }
        String urlStr = args[1];
        String xqueryValidationProfileFilePath = args[3];
        XmlContextFactory xmlContextFactory = new XmlContextFactory();
        XmlContext xmlContext = xmlContextFactory.newContext();
        try {
            XQueryProfileValidator xqueryEvaluator = new XQueryProfileValidator(System.out, System.err, xmlContext, urlStr, xqueryValidationProfileFilePath);
            xqueryEvaluator.run();
            System.exit(0);
        }
        catch (MalformedURLException mue) {
            XQueryProfileValidator.error(String.format("Cannot find '%s'.", urlStr));
            System.exit(1);
        }
        catch (IOException e) {
            XQueryProfileValidator.error(String.format("Cannot find '%s'.", urlStr));
            System.exit(1);
        }
        catch (XQueryException xqe) {
            XQueryProfileValidator.error("Invalid XQuery Expression : " + xqe.getMessage());
            System.exit(2);
        }
        catch (XmlObjectReadException e) {
            XQueryProfileValidator.error(e.getMessage());
            System.exit(3);
        }
        catch (XQueryValidationProfileParsingException e) {
            XQueryProfileValidator.error(e.getMessage());
            System.exit(2);
        }
    }
}

