/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.cli;

import com.ebmwebsourcing.easybox.api.XQueryValidationProfile;
import com.ebmwebsourcing.easybox.api.XQueryValidationRule;
import com.ebmwebsourcing.easybox.cli.XQueryValidationProfileParsingException;
import com.ebmwebsourcing.easybox.cli.XQueryValidationRuleInputStreamBuilder;
import com.ebmwebsourcing.easybox.cli.XQueryValidationRuleParsingException;
import com.ebmwebsourcing.easycommons.io.IOHelper;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public final class XQueryValidationProfileZipBuilder {
    private static Logger LOG = Logger.getLogger(XQueryValidationProfileZipBuilder.class.getName());
    private final File xqueryValidationProfileZip;

    public XQueryValidationProfileZipBuilder(File xqueryValidationProfileZip) {
        assert (xqueryValidationProfileZip != null);
        this.xqueryValidationProfileZip = xqueryValidationProfileZip;
    }

    public XQueryValidationProfile build() throws XQueryValidationProfileParsingException {
        ZipFile zipFile;
        if (!this.xqueryValidationProfileZip.isFile()) {
            // empty if block
        }
        try {
            zipFile = new ZipFile(this.xqueryValidationProfileZip);
        }
        catch (ZipException ze) {
            throw new XQueryValidationProfileParsingException(String.format("Cannot create a validation profile from '%s'.", this.xqueryValidationProfileZip.getAbsolutePath()), ze);
        }
        catch (IOException ioe) {
            throw new XQueryValidationProfileParsingException(String.format("Cannot create a validation profile from '%s'.", this.xqueryValidationProfileZip.getAbsolutePath()), ioe);
        }
        String profileName = zipFile.getName().replaceAll("\\.zip", "").replaceAll("\\.jar", ")");
        XQueryValidationProfile validationProfile = new XQueryValidationProfile(profileName);
        for (ZipEntry zipEntry : Collections.list(zipFile.entries())) {
            if (zipEntry.isDirectory()) continue;
            try {
                XQueryValidationRule rule = this.buildRule(zipFile, zipEntry);
                validationProfile.addRule(rule);
                LOG.info(String.format("Added rule '%s' to profile '%s'.", rule.getName(), validationProfile.getName()));
            }
            catch (XQueryValidationRuleParsingException xvrpe) {
                LOG.warning(String.format("Cannot parse '%s' as a validation rule zip entry. Skipping it.", zipEntry.getName()));
            }
        }
        return validationProfile;
    }

    private final XQueryValidationRule buildRule(ZipFile zipFile, ZipEntry zipEntry) throws XQueryValidationRuleParsingException {
        InputStream is = null;
        try {
            is = zipFile.getInputStream(zipEntry);
            XQueryValidationRuleInputStreamBuilder ruleBuilder = new XQueryValidationRuleInputStreamBuilder(is);
            XQueryValidationRule xQueryValidationRule = ruleBuilder.build();
            return xQueryValidationRule;
        }
        catch (IOException ioe) {
            throw new XQueryValidationRuleParsingException("Problem while building validation rule.", ioe);
        }
        finally {
            IOHelper.close((Closeable)is);
        }
    }
}

