/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.verification;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.verification.TypeVerifier;
import com.ebmwebsourcing.easycommons.xml.QNameHelper;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.ow2.easywsdl.schema.SchemaFactory;

public class TypeVerifierImpl
implements TypeVerifier {
    private static Logger log = Logger.getLogger(TypeVerifierImpl.class.getName());
    private final BPELProcess bpelDefinition;

    public TypeVerifierImpl(BPELProcess bpelDefinition) {
        this.bpelDefinition = bpelDefinition;
    }

    public Class<?> compare(Element e1, Element e2) throws BPELException {
        Class res = null;
        if (this.isInteger(e1) && this.isInteger(e2)) {
            res = Integer.class;
        } else if (this.isBoolean(e1) && this.isBoolean(e2)) {
            res = Boolean.class;
        } else if (this.isDateTime(e1) && this.isDateTime(e2)) {
            res = Date.class;
        } else if (this.isString(e1) && this.isString(e2)) {
            res = String.class;
        }
        return res;
    }

    public boolean isInteger(Element e) throws BPELException {
        boolean res = false;
        String typeValue = e.getAttributeValue("type");
        if (typeValue == null) {
            typeValue = e.getAttributeValue("type", Namespace.getNamespace((String)"http://www.w3.org/2001/XMLSchema-instance"));
        }
        QName type = null;
        if (typeValue != null) {
            Namespace ns;
            String prefix = QNameHelper.getPrefix((String)typeValue);
            type = new QName(typeValue);
            if (prefix != null && (ns = e.getNamespace(prefix)) != null) {
                type = new QName(ns.getURI(), QNameHelper.getLocalPartWithoutPrefix((String)typeValue));
            }
        } else {
            List elmts = this.bpelDefinition.getImports().findElementsInAllSchema(new QName(e.getNamespaceURI(), e.getName()));
            if (elmts.size() == 0) {
                if (e.getNamespaceURI() == null || e.getNamespaceURI().equals("")) {
                    log.finest("Element not found in schema. It's probably an unqualified element");
                } else {
                    throw new BPELException("Element " + e + " not found in all schemas");
                }
            }
            int typeTest = -1;
            if (elmts.size() > 1) {
                Iterator it = elmts.iterator();
                com.ebmwebsourcing.easyschema10.api.element.Element elmt1 = (com.ebmwebsourcing.easyschema10.api.element.Element)it.next();
                com.ebmwebsourcing.easyschema10.api.element.Element elmt2 = null;
                int id = 0;
                while (it.hasNext() && typeTest == -1) {
                    elmt2 = (com.ebmwebsourcing.easyschema10.api.element.Element)it.next();
                    if (elmt1.getType() != null && elmt1.getType().equals(elmt2.getType())) {
                        typeTest = id;
                    }
                    elmt1 = elmt2;
                    ++id;
                }
            }
            type = typeTest >= 0 ? ((com.ebmwebsourcing.easyschema10.api.element.Element)elmts.get(typeTest)).getType() : SchemaFactory.getDefaultSchema().getTypeString().getQName();
        }
        if (type.equals(SchemaFactory.getDefaultSchema().getTypeInt().getQName()) || type.equals(SchemaFactory.getDefaultSchema().getTypeInteger().getQName())) {
            log.finest("type: " + new XMLOutputter(Format.getPrettyFormat()).outputString(e) + " is an integer");
            res = true;
        }
        return res;
    }

    public boolean isDateTime(Element e) throws BPELException {
        boolean res = false;
        String typeValue = e.getAttributeValue("type");
        if (typeValue == null) {
            typeValue = e.getAttributeValue("type", Namespace.getNamespace((String)"http://www.w3.org/2001/XMLSchema-instance"));
        }
        QName type = null;
        if (typeValue != null) {
            Namespace ns;
            String prefix = QNameHelper.getPrefix((String)typeValue);
            type = new QName(typeValue);
            if (prefix != null && (ns = e.getNamespace(prefix)) != null) {
                type = new QName(ns.getURI(), QNameHelper.getLocalPartWithoutPrefix((String)typeValue));
            }
        } else {
            List elmts = this.bpelDefinition.getImports().findElementsInAllSchema(new QName(e.getNamespaceURI(), e.getName()));
            if (elmts.size() == 0) {
                if (e.getNamespaceURI() == null || e.getNamespaceURI().equals("")) {
                    log.finest("Element not found in schema. It's probably an unqualified element");
                } else {
                    throw new BPELException("Element " + e + " not found in all schemas");
                }
            }
            int typeTest = -1;
            if (elmts.size() > 1) {
                Iterator it = elmts.iterator();
                com.ebmwebsourcing.easyschema10.api.element.Element elmt1 = (com.ebmwebsourcing.easyschema10.api.element.Element)it.next();
                com.ebmwebsourcing.easyschema10.api.element.Element elmt2 = null;
                int id = 0;
                while (it.hasNext() && typeTest == -1) {
                    elmt2 = (com.ebmwebsourcing.easyschema10.api.element.Element)it.next();
                    if (elmt1.getType() != null && elmt1.getType().equals(elmt2.getType())) {
                        typeTest = id;
                    }
                    elmt1 = elmt2;
                    ++id;
                }
            }
            type = typeTest >= 0 ? ((com.ebmwebsourcing.easyschema10.api.element.Element)elmts.get(typeTest)).getType() : SchemaFactory.getDefaultSchema().getTypeString().getQName();
        }
        if (type.equals(SchemaFactory.getDefaultSchema().getTypeDateTime().getQName())) {
            log.finest("type: " + new XMLOutputter(Format.getPrettyFormat()).outputString(e) + " is an datetime");
            res = true;
        }
        return res;
    }

    public boolean isString(Element e) throws BPELException {
        boolean res = false;
        String typeValue = e.getAttributeValue("type");
        if (typeValue == null) {
            typeValue = e.getAttributeValue("type", Namespace.getNamespace((String)"http://www.w3.org/2001/XMLSchema-instance"));
        }
        QName type = null;
        if (typeValue != null) {
            Namespace ns;
            String prefix = QNameHelper.getPrefix((String)typeValue);
            type = new QName(typeValue);
            if (prefix != null && (ns = e.getNamespace(prefix)) != null) {
                type = new QName(ns.getURI(), QNameHelper.getLocalPartWithoutPrefix((String)typeValue));
            }
        } else {
            List elmts = this.bpelDefinition.getImports().findElementsInAllSchema(new QName(e.getNamespaceURI(), e.getName()));
            if (elmts.size() == 0) {
                if (e.getNamespaceURI() == null || e.getNamespaceURI().equals("")) {
                    log.finest("Element not found in schema. It's probably an unqualified element");
                } else {
                    throw new BPELException("Element " + e + " not found in all schemas");
                }
            }
            int typeTest = -1;
            if (elmts.size() > 1) {
                Iterator it = elmts.iterator();
                com.ebmwebsourcing.easyschema10.api.element.Element elmt1 = (com.ebmwebsourcing.easyschema10.api.element.Element)it.next();
                com.ebmwebsourcing.easyschema10.api.element.Element elmt2 = null;
                int id = 0;
                while (it.hasNext() && typeTest == -1) {
                    elmt2 = (com.ebmwebsourcing.easyschema10.api.element.Element)it.next();
                    if (elmt1.getType() != null && elmt1.getType().equals(elmt2.getType())) {
                        typeTest = id;
                    }
                    elmt1 = elmt2;
                }
                ++id;
            }
            type = typeTest >= 0 ? ((com.ebmwebsourcing.easyschema10.api.element.Element)elmts.get(typeTest)).getType() : SchemaFactory.getDefaultSchema().getTypeString().getQName();
        }
        if (type.equals(SchemaFactory.getDefaultSchema().getTypeString().getQName())) {
            log.finest("type: " + new XMLOutputter(Format.getPrettyFormat()).outputString(e) + " is a string");
            res = true;
        }
        return res;
    }

    public boolean isBoolean(Element e) throws BPELException {
        boolean res = false;
        String typeValue = e.getAttributeValue("type");
        if (typeValue == null) {
            typeValue = e.getAttributeValue("type", Namespace.getNamespace((String)"http://www.w3.org/2001/XMLSchema-instance"));
        }
        QName type = null;
        if (typeValue != null) {
            Namespace ns;
            String prefix = QNameHelper.getPrefix((String)typeValue);
            type = new QName(typeValue);
            if (prefix != null && (ns = e.getNamespace(prefix)) != null) {
                type = new QName(ns.getURI(), QNameHelper.getLocalPartWithoutPrefix((String)typeValue));
            }
        } else {
            List elmts = this.bpelDefinition.getImports().findElementsInAllSchema(new QName(e.getNamespaceURI(), e.getName()));
            if (elmts.size() == 0) {
                if (e.getNamespaceURI() == null || e.getNamespaceURI().equals("")) {
                    log.finest("Element not found in schema. It's probably an unqualified element");
                } else {
                    throw new BPELException("Element " + e + " not found in all schemas");
                }
            }
            int typeTest = -1;
            if (elmts.size() > 1) {
                Iterator it = elmts.iterator();
                com.ebmwebsourcing.easyschema10.api.element.Element elmt1 = (com.ebmwebsourcing.easyschema10.api.element.Element)it.next();
                com.ebmwebsourcing.easyschema10.api.element.Element elmt2 = null;
                int id = 0;
                while (it.hasNext() && typeTest == -1) {
                    elmt2 = (com.ebmwebsourcing.easyschema10.api.element.Element)it.next();
                    if (elmt1.getType() != null && elmt1.getType().equals(elmt2.getType())) {
                        typeTest = id;
                    }
                    elmt1 = elmt2;
                }
                ++id;
            }
            type = typeTest >= 0 ? ((com.ebmwebsourcing.easyschema10.api.element.Element)elmts.get(typeTest)).getType() : SchemaFactory.getDefaultSchema().getTypeString().getQName();
        }
        if (type != null && type.equals(SchemaFactory.getDefaultSchema().getTypeString().getQName())) {
            if (e.getText() != null && (e.getText().trim().equals("true") || e.getText().trim().equals("false"))) {
                log.finest("type: " + new XMLOutputter(Format.getPrettyFormat()).outputString(e) + " is a boolean");
                res = true;
            }
        } else if (type != null && type.equals(SchemaFactory.getDefaultSchema().getTypeBoolean().getQName())) {
            log.finest("type: " + new XMLOutputter(Format.getPrettyFormat()).outputString(e) + " is a boolean");
            res = true;
        }
        return res;
    }

    public Integer getIntValue(Element e) {
        Integer res = null;
        if (e.getText() != null && e.getText().trim().length() > 0) {
            res = Integer.parseInt(e.getText());
        }
        return res;
    }

    public String getStringValue(Element e) {
        return e.getText();
    }

    public Boolean getBooleanValue(Element e) {
        Boolean res = null;
        if (e.getText() != null && e.getText().trim().length() > 0) {
            res = Boolean.parseBoolean(e.getText());
        }
        return res;
    }

    public Date getDateTimeValue(Element e) throws BPELException {
        Date res = null;
        if (e.getText() != null && e.getText().trim().length() > 0) {
            try {
                XMLGregorianCalendar xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(e.getText());
                res = xmlCalendar.toGregorianCalendar().getTime();
            }
            catch (DatatypeConfigurationException e1) {
                throw new BPELException("Impossible to convert this date: " + e.getText() + " in element: " + e.getName());
            }
            catch (IllegalArgumentException e1) {
                throw new BPELException("Impossible to convert this date: " + e.getText() + " in element: " + e.getName());
            }
        }
        return res;
    }

    public boolean isNullValue(Element e) {
        boolean res = false;
        if (e != null && e.getText() == null) {
            res = true;
        }
        return res;
    }
}

