/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.test.examples.perf;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.test.examples.activity.AbstractBpelCoreTest;
import com.ebmwebsourcing.easybpel.model.bpel.test.util.ThreadClient;
import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessContextDefinition;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessContextDefinitionImpl;
import com.ebmwebsourcing.easyviper.core.impl.soa.message.MessageImpl;
import com.ebmwebsourcing.easyviper.environment.test.env.ExecutionEnvironmentTestFactory;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ClientEndpoint;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ExecutionEnvironmentTest;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.jdom.JDOMException;
import org.junit.Assert;
import org.junit.Test;

public class HelloProcessTest
extends AbstractBpelCoreTest {
    @Test(timeout=20000L)
    public void testHelloPerf() throws CoreException, URISyntaxException, BPELException, InterruptedException, JDOMException, IOException {
        int i;
        ExecutionEnvironmentTest env = ExecutionEnvironmentTestFactory.newInstance().newEnvironment("TestEnvironnement", false);
        Core core = this.createCoreUnderTest();
        env.setCore(core);
        core.getModel().getRegistry().storeProcessDefinition(new URI("./src/test/resources/com/ebmwebsourcing/easybpel/model/bpel/test/examples/perf/Hello.bpel"), (ProcessContextDefinition)new ProcessContextDefinitionImpl(1));
        MessageImpl message = new MessageImpl("process");
        message.setService(new QName("http://petals.ow2.org", "HelloService"));
        message.setEndpoint("HelloEndpoint");
        message.getBody().setPayloadAsString("<pet:HelloRequest xmlns:pet=\"http://petals.ow2.org\">         <pet:input>Hello!!!</pet:input></pet:HelloRequest>");
        int nbClient = 10;
        ArrayList<ThreadClient> clients = new ArrayList<ThreadClient>();
        for (i = 0; i < nbClient; ++i) {
            ClientEndpoint client = env.createClientEndpoint("client" + i);
            clients.add(new ThreadClient(client, (Message)message));
        }
        ArrayList threadActif = new ArrayList();
        for (i = 0; i <= clients.size() / 2; ++i) {
            ((ThreadClient)clients.get(i)).start();
            threadActif.add(clients.get(i));
        }
        while (i < clients.size()) {
            ((ThreadClient)clients.get(i)).run();
            ++i;
        }
        System.out.println("waiting end of clients");
        for (ThreadClient t : clients) {
            System.out.println("###" + t.getName() + " is going to be ended ...");
            t.join();
        }
        MessageImpl expectedResponse = new MessageImpl("process");
        expectedResponse.getBody().setPayloadAsString("<tns:HelloResponse xmlns:tns=\"http://petals.ow2.org\">  <tns:result xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"string\">Hello!!!</tns:result></tns:HelloResponse>");
        for (ThreadClient client : clients) {
            System.out.println("assert on client: " + client.getClient().getName());
            if (client.getResponse() == null) {
                Assert.fail((String)("no message received on client: " + client.getClient().getName()));
            }
            Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)expectedResponse.toString(), (String)client.getResponse().toString()));
        }
        System.out.println("number of process instance : " + core.getEngine().getProcessInstanceRegistry().getProcessInstances().size());
        System.out.println(clients.size() / 2);
        System.out.println(core.getEngine().getProcessInstanceRegistry().getProcessInstances().size());
        core.getModel().getRegistry().unStoreProcessDefinition(new URI("./src/test/resources/com/ebmwebsourcing/easybpel/model/bpel/test/examples/perf/Hello.bpel"), true);
        Assert.assertTrue((core.getEngine().getProcessInstanceRegistry().getProcessInstances().size() == 0 ? 1 : 0) != 0);
    }
}

