/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.runtime;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Invoke;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.ElementVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.MessageTypeVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariable;
import com.ebmwebsourcing.easybpel.model.bpel.impl.exception.TechnicalException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.exception.UserDefinedException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.protocol.SoapBindingInputMessageAdapter;
import com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.protocol.SoapBindingOutputMessageAdapter;
import com.ebmwebsourcing.easybpel.model.bpel.tools.Util;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.Fault;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.FaultHandler;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.message.BindingMessageAdapter;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.core.impl.soa.message.MessageImpl;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jdom.Document;
import org.jdom.Element;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.Operation;
import org.petalslink.abslayer.service.api.PartnerLinkType;
import org.petalslink.abslayer.service.api.Role;

public class BPELFaultHandler
implements FaultHandler {
    private Logger log = Logger.getLogger(BPELFaultHandler.class.getName());
    private final Descriptions desc;
    private final BPELProcess bpeldefinition;
    private final Invoke invoke;

    public BPELFaultHandler(BPELProcess bpeldefinition, Invoke invoke) {
        this.desc = bpeldefinition.getImports();
        this.bpeldefinition = bpeldefinition;
        this.invoke = invoke;
    }

    public void assignExceptionVariable(Execution execution, CoreException exception, Variable variable) throws CoreException {
        assert (exception instanceof UserDefinedException);
        UserDefinedException businessException = (UserDefinedException)exception;
        SoapBindingInputMessageAdapter soapBindingInputAdapter = new SoapBindingInputMessageAdapter(this.bpeldefinition);
        SoapBindingOutputMessageAdapter soapBindingOutputAdapter = new SoapBindingOutputMessageAdapter(this.bpeldefinition);
        Element detail = soapBindingOutputAdapter.getDetails(businessException.getFault().getBody().getPayload());
        Document doc = new Document((Element)Util.getChildElements(detail).get(0).clone());
        MessageImpl faultMessage = new MessageImpl(businessException.getFault().getOperationName());
        faultMessage.getBody().setPayload(doc.getRootElement());
        faultMessage.setEndpoint(businessException.getFault().getEndpoint());
        faultMessage.setQName(businessException.getFault().getQName());
        faultMessage.setService(businessException.getFault().getService());
        soapBindingInputAdapter.adaptFromBindingInput(execution, (Message)faultMessage, variable, businessException.getDirection(), businessException.getIsBindingStyleRpc());
    }

    public boolean match(Execution execution, Fault f, CoreException e, Scope faultScope) throws CoreException {
        boolean res = false;
        try {
            if (f.getFaultName() != null && f.getFaultName().getLocalPart().equals("unknown") && f.getVariable() == null) {
                this.log.finest("faultName = " + f.getFaultName());
                res = true;
            } else if (e instanceof UserDefinedException) {
                UserDefinedException businessException = (UserDefinedException)e;
                Variable var = f.getVariable();
                TVariable varDef = (TVariable)((AbstractSchemaElementImpl)var).getModel();
                if (!res && var instanceof ElementVariable && businessException.getQnameType() == UserDefinedException.FaultQnameType.ELEMENT_QNAME && varDef.getElement().equals(businessException.getMessageTypeOrElementQName())) {
                    res = true;
                } else if (!res && var instanceof MessageTypeVariable && businessException.getQnameType() == UserDefinedException.FaultQnameType.MESSAGE_QNAME && varDef.getMessageType().equals(businessException.getMessageTypeOrElementQName())) {
                    res = true;
                }
            }
            if (!res && f.getFaultName() != null && f.getFaultName().toString().equals(e.getName())) {
                res = true;
            }
            if (!res && f.getVariable().getName() != null && f.getVariable().getName().toString().equals(e.getName())) {
                res = true;
            }
        }
        catch (BPELException ex) {
            throw new CoreException((Throwable)e);
        }
        return res;
    }

    private static final String findRelevantMessage(Throwable t) {
        assert (t != null);
        String message = t.getMessage();
        if (message == null) {
            if (t.getCause() != null) {
                return BPELFaultHandler.findRelevantMessage(t.getCause());
            }
            return null;
        }
        return message;
    }

    public BPELException getBPELExceptionFromGenericException(Scope scope, CoreException e, BindingMessageAdapter.Direction direction, boolean isBindingStyleRpc) throws CoreException {
        SoapBindingOutputMessageAdapter soapBindingOutputAdapter = new SoapBindingOutputMessageAdapter(this.bpeldefinition);
        BPELException res = null;
        assert (e instanceof CoreException);
        CoreException ce = e;
        assert (this.invoke != null);
        assert (this.bpeldefinition != null);
        Message fault = e.getFault();
        if (fault == null) {
            throw new CoreException(BPELFaultHandler.findRelevantMessage((Throwable)ce), (Throwable)ce);
        }
        Element details = soapBindingOutputAdapter.getDetails(fault.getBody().getPayload());
        if (details != null && details.getChildren().size() > 1) {
            throw new CoreException("Sorry, but the management of severals faults is not supported");
        }
        if (details != null && Util.getChildElements(details).size() == 1) {
            org.petalslink.abslayer.service.api.Fault[] faults;
            Element elmt = Util.getChildElements(details).get(0);
            QName faultElement = new QName(elmt.getNamespaceURI(), elmt.getName());
            QName interfaceName = this.invoke.getInterface();
            Interface itf = null;
            if (interfaceName != null) {
                itf = this.desc.findInterface(interfaceName);
            } else {
                PartnerLink partnerLink = this.bpeldefinition.findPartnerLink(this.invoke.getPartnerLink());
                PartnerLinkType partnerLinkType = null;
                partnerLinkType = this.bpeldefinition.getImports().getPartnerLinkType(partnerLink.getPartnerLinkType());
                Role partnerLinkRole = partnerLinkType.getRole(partnerLink.getPartnerRole());
                itf = this.bpeldefinition.getImports().findInterface(partnerLinkRole.getInterfaceQName());
            }
            if (itf == null) {
                throw new CoreException("Impossible to find interface '" + interfaceName + "'.");
            }
            Operation op = itf.getOperation(new QName(itf.getQName().getNamespaceURI(), this.invoke.getOperation()));
            if (op == null) {
                throw new CoreException("Impossible to find operation with this name: " + this.invoke.getOperation());
            }
            org.petalslink.abslayer.service.api.Fault[] faultArray = faults = op.getFaults();
            int n = faults.length;
            int n2 = 0;
            while (n2 < n) {
                org.petalslink.abslayer.service.api.Fault faultDef = faultArray[n2];
                QName faultName = new QName(itf.getQName().getNamespaceURI(), faultDef.getName());
                if (faultDef.getMessageName() != null && (faultName.equals(faultElement) || faultDef.getElementQName() != null && faultDef.getElementQName().equals(faultElement))) {
                    this.log.finest("Creating new UserDefinedException from message");
                    res = new UserDefinedException(faultName, null, UserDefinedException.FaultQnameType.MESSAGE_QNAME, faultDef.getMessageName(), scope);
                    res.setName(faultName.toString());
                    res.setFault(fault);
                    break;
                }
                if (faultDef.getElementQName() != null && faultDef.getElementQName().equals(faultElement)) {
                    this.log.finest("Creating new UserDefinedException from element");
                    res = new UserDefinedException(faultName, null, UserDefinedException.FaultQnameType.ELEMENT_QNAME, faultDef.getElementQName(), scope);
                    res.setName(faultName.toString());
                    res.setFault(fault);
                    break;
                }
                ++n2;
            }
        } else {
            res = new TechnicalException((Throwable)ce);
        }
        res.setDirection(direction);
        res.setIsBindingStyleRpc(isBindingStyleRpc);
        return res;
    }

    public void setLog(Logger logger) {
        this.log = logger;
    }
}

