/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.inout;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELReader;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.EasyNSFilter;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TProcess;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELProcessImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.inout.BPELJAXBContext;
import com.ebmwebsourcing.easycommons.xml.SourceHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class BPELReaderImpl
implements BPELReader {
    private static Logger log = Logger.getLogger(BPELReaderImpl.class.getName());
    private Map<BPELReader.FeatureConstants, Object> features = new HashMap<BPELReader.FeatureConstants, Object>();

    public BPELReaderImpl() throws BPELException {
        try {
            this.features.put(BPELReader.FeatureConstants.VERBOSE, false);
            this.features.put(BPELReader.FeatureConstants.IMPORT_DOCUMENTS, true);
            BPELJAXBContext.getInstance();
        }
        catch (BPELException e) {
            throw new BPELException((Throwable)e);
        }
    }

    public JAXBContext getJaxbContext() throws BPELException {
        return BPELJAXBContext.getInstance().getJaxbContext();
    }

    private TProcess convertStream2Process(Source bpelDescriptorStream) throws BPELException {
        try {
            JAXBElement wsdlBinding = this.getJaxbContext().createUnmarshaller().unmarshal(bpelDescriptorStream, TProcess.class);
            return (TProcess)wsdlBinding.getValue();
        }
        catch (JAXBException e) {
            throw new BPELException("Failed to build Java bindings from WSDL descriptor XML document", (Throwable)e);
        }
    }

    public BPELProcess readBPEL(URI wsdlURI) throws BPELException {
        BPELProcess desc = null;
        try {
            InputStream input = null;
            File f = new File(wsdlURI.toString());
            input = f.exists() ? new FileInputStream(f) : wsdlURI.toURL().openStream();
            desc = this.readBPEL(wsdlURI, new InputSource(input));
        }
        catch (MalformedURLException e) {
            throw new BPELException("Can not get bpel at: " + wsdlURI, (Throwable)e);
        }
        catch (IOException e) {
            throw new BPELException("Can not get bpel at: " + wsdlURI, (Throwable)e);
        }
        catch (BPELException e) {
            throw new BPELException("Can not get bpel at: " + wsdlURI, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BPELException("Can not get bpel at: " + wsdlURI, (Throwable)e);
        }
        return desc;
    }

    public BPELProcess readBPEL(Document bpelDocument) throws BPELException {
        BPELProcess desc = null;
        try {
            URI uri = null;
            uri = bpelDocument.getDocumentURI() != null ? new URI(bpelDocument.getDocumentURI()) : new File(".").toURI();
            desc = this.readBPEL(uri, SourceHelper.toInputSource((Document)bpelDocument));
        }
        catch (URISyntaxException e) {
            throw new BPELException((Throwable)e);
        }
        catch (TransformerException e) {
            throw new BPELException((Throwable)e);
        }
        return desc;
    }

    public BPELProcess readBPEL(URI wsdlURI, InputSource inputSource) throws BPELException {
        BPELProcessImpl desc = null;
        try {
            log.finest("Loading " + wsdlURI);
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            EasyNSFilter filter = new EasyNSFilter(xmlReader);
            SAXSource saxSource = new SAXSource((XMLReader)filter, inputSource);
            TProcess def = this.convertStream2Process(saxSource);
            desc = new BPELProcessImpl(wsdlURI, def, filter.getNamespaceMapper(), this.getFeatures());
        }
        catch (SAXException e) {
            throw new BPELException((Throwable)e);
        }
        return desc;
    }

    public final void setFeature(BPELReader.FeatureConstants name, Object value) throws BPELException {
        this.features.put(name, value);
        log.finest("set proterty: " + name + " - value = " + value);
    }

    public final Object getFeature(BPELReader.FeatureConstants name) {
        return this.features.get(name);
    }

    public final Map<BPELReader.FeatureConstants, Object> getFeatures() {
        return this.features;
    }

    public final void setFeatures(Map<BPELReader.FeatureConstants, Object> features) {
        this.features = features;
    }
}

