/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.tools.validator.test.examples.all;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Sequence;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.AnalysorResult;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.BPELAnalyser;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.BPELValidator;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.ValidatorResult;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.ValidatorResultPrinter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class AllValidationTest {
    @Test
    public void testAll() throws BPELException, MalformedURLException, URISyntaxException {
        BPELValidator validator = new BPELValidator();
        ValidatorResult result = validator.validate(Thread.currentThread().getContextClassLoader().getResource("com/ebmwebsourcing/easybpel/model/bpel/tools/validator/test/examples/all/Hello.bpel"));
        System.out.println(ValidatorResultPrinter.getInstance().printAll(result));
        System.out.println("XPath Links:");
        System.out.println(ValidatorResultPrinter.getInstance().printAllXPathExpression(result));
        List infos = result.getInfos();
        List warnings = result.getWarnings();
        List errors = result.getErrors();
        Assert.assertEquals((long)24L, (long)infos.size());
        Assert.assertEquals((long)3L, (long)warnings.size());
        Assert.assertEquals((long)68L, (long)errors.size());
    }

    @Test
    public void testAnalyzer() throws BPELException, MalformedURLException, URISyntaxException {
        BPELAnalyser analyzer = new BPELAnalyser();
        AnalysorResult result = analyzer.analyze(Thread.currentThread().getContextClassLoader().getResource("com/ebmwebsourcing/easybpel/model/bpel/tools/validator/test/examples/all/Hello.bpel"));
        System.out.println("Imports: " + result.getImports());
        System.out.println("Process Description: " + result.getProcessDescriptions());
        BPELProcess bpel = result.getProcessDefinition();
        System.out.println("first Activity: " + bpel.getActivity());
        if (bpel.getActivity() instanceof Sequence) {
            Sequence seq = (Sequence)bpel.getActivity();
            System.out.println("number of under child activities in sequence: " + seq.getActivities().size());
            Assert.assertEquals((long)29L, (long)seq.getActivities().size());
        } else {
            Assert.fail();
        }
    }
}

