/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.usecases.armee.air.mobilite;

import com.ebmwebsourcing.easybpel.model.bpel.api.message.BPELExternalMessage;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.message.BPELExternalMessageImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.message.DefaultBPELMessageConverter;
import com.ebmwebsourcing.easybpel.usecases.armee.air.mobilite.AnnuService;
import com.ebmwebsourcing.easybpel.usecases.armee.air.mobilite.MockServiceBuilder;
import com.ebmwebsourcing.easybpel.usecases.armee.air.mobilite.SendMailService;
import com.ebmwebsourcing.easybpel.usecases.armee.air.mobilite.SigabaseService;
import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessContextDefinition;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessContextDefinitionImpl;
import com.ebmwebsourcing.easyviper.environment.test.env.ExecutionEnvironmentTestFactory;
import com.ebmwebsourcing.easyviper.environment.test.env.TestSenderImpl;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ClientEndpoint;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ExecutionEnvironmentTest;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ProviderEndpoint;
import com.ebmwebsourcing.easyviper.tools.MemoryReceiverImpl;
import java.io.File;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Element;
import org.junit.Assert;
import org.junit.Test;

public class ArmeeProcessTest {
    @Test
    public void testArmee() throws Exception {
        boolean explorer = false;
        Logger.getLogger("com.ebmwebsourcing.easybpel").setLevel(Level.FINEST);
        Logger.getLogger("com.ebmwebsourcing.easyviper.core.impl").setLevel(Level.OFF);
        Logger logger = Logger.getLogger("com.ebmwebsourcing.orchestration.maestro.bpel20");
        logger.info("=====" + this.getClass().getSimpleName() + "=====");
        ExecutionEnvironmentTest env = ExecutionEnvironmentTestFactory.newInstance().newEnvironment("TestEnvironnement", false);
        Core core = BPELFactoryImpl.getInstance().newBPELEngine(DefaultBPELMessageConverter.get(), 1, MemoryReceiverImpl.class, 1, TestSenderImpl.class);
        env.setCore(core);
        ProviderEndpoint AnnuProvider = env.createProviderEndpoint("ServicesCSIAPort", AnnuService.class);
        ProviderEndpoint SigabaseProvider = env.createProviderEndpoint("sigabaseport", SigabaseService.class);
        ProviderEndpoint SendMailProvider = env.createProviderEndpoint("SendMailGenericEndpoint", SendMailService.class);
        ClientEndpoint client = env.createClientEndpoint("client");
        core.getModel().getRegistry().storeProcessDefinition(new URI("./src/test/resources/bpel/process.bpel"), (ProcessContextDefinition)new ProcessContextDefinitionImpl(5));
        File xmlFile = new File("./src/test/resources/tests/test1/ProcessRequest.xml");
        BPELExternalMessage message = MockServiceBuilder.buildEmptyMessage("http://air.defense.gouv.fr/", "affectation", "affectationEndpoint", xmlFile, "iaffectationRequestMessage", "process");
        ExternalMessage response = client.sendSync((ExternalMessage)message);
        BPELExternalMessageImpl expectedResponse = new BPELExternalMessageImpl();
        Element content = MockServiceBuilder.buildContent(new File("./src/test/resources/tests/test1/ProcessResponse.xml"));
        expectedResponse.setContent((Object)content);
        Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)expectedResponse.toString(), (String)response.toString()));
        core.getModel().getRegistry().unStoreProcessDefinition(new URI("./src/test/resources/bpel/process.bpel"), true);
        while (core.getEngine().getProcessInstanceRegistry().getProcessInstances().size() != 0) {
            logger.info("Wait that all instances of process stop ...");
            Thread.sleep(500L);
        }
    }
}

