/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.usecase.prosodie.bindconsume;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.exception.UserDefinedException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.message.BPELExternalMessageImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.message.DefaultBPELMessageConverter;
import com.ebmwebsourcing.easybpel.usecase.prosodie.bindconsume.ProvideACService;
import com.ebmwebsourcing.easybpel.usecase.prosodie.bindconsume.ProvideQUIDService;
import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessContextDefinition;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessContextDefinitionImpl;
import com.ebmwebsourcing.easyviper.environment.test.env.ExecutionEnvironmentTestFactory;
import com.ebmwebsourcing.easyviper.environment.test.env.TestSenderImpl;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ClientEndpoint;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ExecutionEnvironmentTest;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ProviderEndpoint;
import com.ebmwebsourcing.easyviper.tools.MemoryReceiverImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.junit.Assert;
import org.junit.Test;

public class BindConsumeProcessTest {
    private ExecutionEnvironmentTest createAllEnvironment(boolean explorer) throws CoreException, BPELException, URISyntaxException {
        ExecutionEnvironmentTest env = ExecutionEnvironmentTestFactory.newInstance().newEnvironment("TestEnvironnement", explorer);
        Core core = BPELFactoryImpl.getInstance().newBPELEngine(DefaultBPELMessageConverter.get(), 1, MemoryReceiverImpl.class, 1, TestSenderImpl.class);
        env.setCore(core);
        ProviderEndpoint acProvider = env.createProviderEndpoint("ACPort", ProvideACService.class);
        ProviderEndpoint quidProvider = env.createProviderEndpoint("QuidPort", ProvideQUIDService.class);
        core.getModel().getRegistry().storeProcessDefinition(new URI("./src/test/resources/bindConsume.bpel"), (ProcessContextDefinition)new ProcessContextDefinitionImpl(1));
        return env;
    }

    @Test
    public void testNominalBindConsume() throws CoreException, URISyntaxException, BPELException, InterruptedException, JDOMException, IOException {
        boolean explorer = false;
        ExecutionEnvironmentTest env = this.createAllEnvironment(false);
        ClientEndpoint client = env.createClientEndpoint("client");
        BPELExternalMessageImpl message = new BPELExternalMessageImpl();
        message.setService(new QName("http://prosodie.com", "BindService"));
        message.setEndpoint("BindEndpoint");
        message.setOperationName("bindUserBySsoToken");
        message.setMessage("<pros:bindConsumeRequest xmlns:pros=\"http://prosodie.com\">         <pros:interfaceKey>myKey</pros:interfaceKey>         <!--1 or more repetitions:-->         <pros:ssoToken>mySsoToken1</pros:ssoToken>         <pros:ssoToken>mySsoToken2</pros:ssoToken></pros:bindConsumeRequest>");
        ExternalMessage response = client.sendSync((ExternalMessage)message);
        BPELExternalMessageImpl expectedResponse = new BPELExternalMessageImpl();
        expectedResponse.setMessage("<tns:bindConsumeResponse xmlns:tns=\"http://prosodie.com\">  <tns:result xmlns:Q1=\"http://prosodie.com/user\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"Q1:User\">    <tns:firstName xmlns:tns=\"http://prosodie.com/user\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xsi:type=\"xsd:string\">Nicolas</tns:firstName>    <tns:serialNumber xmlns:tns=\"http://prosodie.com/user\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xsi:type=\"xsd:int\">1</tns:serialNumber>    <tns:lastName xmlns:tns=\"http://prosodie.com/user\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xsi:type=\"xsd:string\">Salatge</tns:lastName>    <tns:type xmlns:tns=\"http://prosodie.com/user\" xsi:type=\"tns:Type\">INTERNAL</tns:type>  </tns:result>  <tns:result xmlns:Q1=\"http://prosodie.com/user\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"Q1:User\">    <tns:firstName xmlns:tns=\"http://prosodie.com/user\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xsi:type=\"xsd:string\">Matthias</tns:firstName>    <tns:serialNumber xmlns:tns=\"http://prosodie.com/user\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xsi:type=\"xsd:int\">2</tns:serialNumber>    <tns:lastName xmlns:tns=\"http://prosodie.com/user\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xsi:type=\"xsd:string\">Beldame</tns:lastName>    <tns:type xmlns:tns=\"http://prosodie.com/user\" xsi:type=\"tns:Type\">INTERNAL</tns:type>  </tns:result></tns:bindConsumeResponse>");
        Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)expectedResponse.toString(), (String)response.toString()));
        Core core = env.getCore();
        core.getModel().getRegistry().unStoreProcessDefinition(new URI("./src/test/resources/bindConsume.bpel"), true);
        while (core.getEngine().getProcessInstanceRegistry().getProcessInstances().size() != 0) {
            System.out.println("Wait that all instances of process stop ...");
            Thread.sleep(500L);
        }
    }

    @Test
    public void testFaultBindConsume() throws Exception {
        boolean explorer = false;
        ExecutionEnvironmentTest env = this.createAllEnvironment(false);
        ClientEndpoint client = env.createClientEndpoint("client");
        BPELExternalMessageImpl message = new BPELExternalMessageImpl();
        message.setService(new QName("http://prosodie.com", "BindService"));
        message.setEndpoint("BindEndpoint");
        message.setOperationName("bindUserBySsoToken");
        message.setMessage("<pros:bindConsumeRequest xmlns:pros=\"http://prosodie.com\">         <pros:interfaceKey>myFaultKey</pros:interfaceKey>         <!--1 or more repetitions:-->         <pros:ssoToken>myFaultSsoToken1</pros:ssoToken>         <pros:ssoToken>myFaultSsoToken2</pros:ssoToken></pros:bindConsumeRequest>");
        try {
            ExternalMessage response = client.sendSync((ExternalMessage)message);
            Assert.fail();
        }
        catch (BPELException e) {
            Assert.assertEquals(UserDefinedException.class, ((Object)((Object)e)).getClass());
            Assert.assertEquals((Object)"{http://prosodie.com}fault", (Object)((UserDefinedException)e).getFaultName().toString());
            Assert.assertEquals((Object)"MyFault", (Object)((UserDefinedException)e).getFaultVariableName());
            String expectedfaultMsg = "<soap:Fault xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">  <faultcode>soap:Server</faultcode>  <detail>      <tns:errorCode xmlns:tns=\"http://prosodie.com\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"tns:ErrorCode\">INVALID_SSO_TOKEN</tns:errorCode>  </detail></soap:Fault>";
            String actualfaultMsg = new XMLOutputter(Format.getPrettyFormat()).outputString((Element)((UserDefinedException)e).getFault().getContent());
            ByteArrayInputStream actualStream = new ByteArrayInputStream(actualfaultMsg.getBytes());
            ByteArrayInputStream expectedStream = new ByteArrayInputStream(expectedfaultMsg.getBytes());
            Assert.assertTrue((boolean)XMLComparator.isEquivalent((InputStream)actualStream, (InputStream)expectedStream));
            Core core = env.getCore();
            core.getModel().getRegistry().unStoreProcessDefinition(new URI("./src/test/resources/bindConsume.bpel"), true);
            while (core.getEngine().getProcessInstanceRegistry().getProcessInstances().size() != 0) {
                System.out.println("Wait that all instances of process stop ...");
                Thread.sleep(500L);
            }
        }
    }

    @Test
    public void testAlternanceBindConsume() throws BPELException, CoreException, URISyntaxException, InterruptedException {
        boolean explorer = false;
        ExecutionEnvironmentTest env = this.createAllEnvironment(false);
        ClientEndpoint client = env.createClientEndpoint("client");
        BPELExternalMessageImpl nominalMessage = new BPELExternalMessageImpl();
        nominalMessage.setService(new QName("http://prosodie.com", "BindService"));
        nominalMessage.setEndpoint("BindEndpoint");
        nominalMessage.setOperationName("bindUserBySsoToken");
        nominalMessage.setMessage("<pros:bindConsumeRequest xmlns:pros=\"http://prosodie.com\">         <pros:interfaceKey>myKey</pros:interfaceKey>         <!--1 or more repetitions:-->         <pros:ssoToken>mySsoToken1</pros:ssoToken>         <pros:ssoToken>mySsoToken2</pros:ssoToken></pros:bindConsumeRequest>");
        BPELExternalMessageImpl faultMessage = new BPELExternalMessageImpl();
        faultMessage.setService(new QName("http://prosodie.com", "BindService"));
        faultMessage.setEndpoint("BindEndpoint");
        faultMessage.setOperationName("bindUserBySsoToken");
        faultMessage.setMessage("<pros:bindConsumeRequest xmlns:pros=\"http://prosodie.com\">         <pros:interfaceKey>myFaultKey</pros:interfaceKey>         <!--1 or more repetitions:-->         <pros:ssoToken>myFaultSsoToken1</pros:ssoToken>         <pros:ssoToken>myFaultSsoToken2</pros:ssoToken></pros:bindConsumeRequest>");
        ExternalMessage response = client.sendSync((ExternalMessage)nominalMessage);
        BPELExternalMessageImpl expectedResponse = new BPELExternalMessageImpl();
        expectedResponse.setMessage("<tns:bindConsumeResponse xmlns:tns=\"http://prosodie.com\">  <tns:result xmlns:Q1=\"http://prosodie.com/user\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"Q1:User\">    <tns:firstName xmlns:tns=\"http://prosodie.com/user\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xsi:type=\"xsd:string\">Nicolas</tns:firstName>    <tns:serialNumber xmlns:tns=\"http://prosodie.com/user\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xsi:type=\"xsd:int\">1</tns:serialNumber>    <tns:lastName xmlns:tns=\"http://prosodie.com/user\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xsi:type=\"xsd:string\">Salatge</tns:lastName>    <tns:type xmlns:tns=\"http://prosodie.com/user\" xsi:type=\"tns:Type\">INTERNAL</tns:type>  </tns:result>  <tns:result xmlns:Q1=\"http://prosodie.com/user\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"Q1:User\">    <tns:firstName xmlns:tns=\"http://prosodie.com/user\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xsi:type=\"xsd:string\">Matthias</tns:firstName>    <tns:serialNumber xmlns:tns=\"http://prosodie.com/user\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xsi:type=\"xsd:int\">2</tns:serialNumber>    <tns:lastName xmlns:tns=\"http://prosodie.com/user\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xsi:type=\"xsd:string\">Beldame</tns:lastName>    <tns:type xmlns:tns=\"http://prosodie.com/user\" xsi:type=\"tns:Type\">INTERNAL</tns:type>  </tns:result></tns:bindConsumeResponse>");
        Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)expectedResponse.toString(), (String)response.toString()));
        try {
            response = client.sendSync((ExternalMessage)faultMessage);
            Assert.fail();
        }
        catch (BPELException e) {
            // empty catch block
        }
        response = client.sendSync((ExternalMessage)nominalMessage);
        Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)expectedResponse.toString(), (String)response.toString()));
        try {
            response = client.sendSync((ExternalMessage)faultMessage);
            Assert.fail();
        }
        catch (BPELException e) {
            // empty catch block
        }
        response = client.sendSync((ExternalMessage)nominalMessage);
        Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)expectedResponse.toString(), (String)response.toString()));
        Core core = env.getCore();
        core.getModel().getRegistry().unStoreProcessDefinition(new URI("./src/test/resources/bindConsume.bpel"), true);
        while (core.getEngine().getProcessInstanceRegistry().getProcessInstances().size() != 0) {
            System.out.println("Wait that all instances of process stop ...");
            Thread.sleep(500L);
        }
    }
}

