/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.usecase.choreos.nodenode;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.message.BPELExternalMessageImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.message.DefaultBPELMessageConverter;
import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessContextDefinition;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessContextDefinitionImpl;
import com.ebmwebsourcing.easyviper.environment.test.env.ExecutionEnvironmentTestFactory;
import com.ebmwebsourcing.easyviper.environment.test.env.TestSenderImpl;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ClientEndpoint;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ExecutionEnvironmentTest;
import com.ebmwebsourcing.easyviper.tools.MemoryReceiverImpl;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import org.jdom.JDOMException;
import org.junit.Assert;
import org.junit.Test;

public class ChoreoNodeNodeProcessTest {
    @Test
    public void testChoreosNodeNode() throws CoreException, URISyntaxException, BPELException, InterruptedException, JDOMException, IOException {
        boolean explorer = false;
        ExecutionEnvironmentTest env = ExecutionEnvironmentTestFactory.newInstance().newEnvironment("TestEnvironnement", false);
        Core core = BPELFactoryImpl.getInstance().newBPELEngine(DefaultBPELMessageConverter.get(), 1, MemoryReceiverImpl.class, 1, TestSenderImpl.class);
        env.setCore(core);
        core.getModel().getRegistry().storeProcessDefinition(new URI("./src/test/resources/NodeNode1.bpel"), (ProcessContextDefinition)new ProcessContextDefinitionImpl(1));
        core.getModel().getRegistry().storeProcessDefinition(new URI("./src/test/resources/LeafNode2.bpel"), (ProcessContextDefinition)new ProcessContextDefinitionImpl(1));
        ClientEndpoint client1 = env.createClientEndpoint("client1");
        int denominator = 10;
        long sum = 0L;
        int delay = 100;
        for (int i = 0; i < denominator; ++i) {
            Thread.sleep(delay);
            BPELExternalMessageImpl message1 = new BPELExternalMessageImpl();
            message1.setService(new QName("http://localhost/NodeNode1", "NodeService1"));
            message1.setEndpoint("NodePort1");
            message1.setOperationName("NodeOperation1");
            message1.setMessage("<xs:string xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">toto</xs:string>");
            long deb = System.currentTimeMillis();
            ExternalMessage response1 = client1.sendSync((ExternalMessage)message1);
            long fin = System.currentTimeMillis();
            BPELExternalMessageImpl expectedResponse1 = new BPELExternalMessageImpl();
            expectedResponse1.setMessage("<xs:Message xmlns:xs=\"http://localhost/NodeNode1\">toto</xs:Message>");
            Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)expectedResponse1.toString(), (String)response1.toString()));
            sum += fin - deb;
        }
        System.out.println("==================================================");
        System.out.println("total time in ms: " + sum);
        System.out.println("average time in ms: " + sum / (long)denominator);
        System.out.println("==================================================");
    }
}

