/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.xpath.exp.impl.function;

import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import com.ebmwebsourcing.easybpel.xpath.exp.api.function.AbstractBPELFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.api.function.DoXslTransformFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.function.XSLParam;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.DOMBuilder;
import org.jdom.output.DOMOutputter;

public class DoXslTransformFunctionImpl
extends AbstractBPELFunction<Element>
implements DoXslTransformFunction {
    private static Logger log = Logger.getLogger(DoXslTransformFunctionImpl.class.getName());
    private final URL xslStyleSheet;
    private final Element nodeset;
    private final List<XSLParam> xslParams;

    public DoXslTransformFunctionImpl(String ns, URL fileName, Element nodeset, List<XSLParam> xslParams) throws XPathExpressionException {
        super(ns);
        this.xslStyleSheet = fileName;
        this.nodeset = nodeset;
        this.xslParams = xslParams;
    }

    public Element process() throws XPathExpressionException {
        Element res = null;
        if (this.xslStyleSheet == null || this.nodeset == null) {
            throw new XPathExpressionException("Wrong number of argument for the bpws:doXslTransform function.");
        }
        try {
            DOMOutputter converter = new DOMOutputter();
            org.w3c.dom.Document domDocument = converter.output(this.nodeset.getDocument());
            org.w3c.dom.Document doc = DoXslTransformFunctionImpl.process(this.xslStyleSheet, domDocument, this.xslParams);
            DOMBuilder builder = new DOMBuilder();
            Document jdomDocument = builder.build(doc);
            res = jdomDocument.getRootElement();
        }
        catch (JDOMException e) {
            throw new XPathExpressionException((Throwable)e);
        }
        return res;
    }

    public static org.w3c.dom.Document process(URL xslStyleSheet, org.w3c.dom.Document nodeset, List<XSLParam> xslParams) throws XPathExpressionException {
        org.w3c.dom.Document res = null;
        if (xslStyleSheet == null || nodeset == null) {
            throw new XPathExpressionException("Wrong number of argument for the bpws:doXslTransform function.");
        }
        StreamSource styleSheet = null;
        try {
            styleSheet = new StreamSource(xslStyleSheet.openStream());
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(styleSheet);
            if (xslParams != null) {
                for (XSLParam param : xslParams) {
                    transformer.setParameter(param.getName(), param.getValue());
                }
            }
            DOMSource source = new DOMSource(nodeset);
            DOMResult result = new DOMResult();
            log.finest("xsl stylesheet = " + xslStyleSheet);
            log.finest("xsl source     = " + XMLPrettyPrinter.prettyPrint((org.w3c.dom.Document)nodeset));
            log.finest("xsl params     = " + xslParams);
            transformer.transform(source, result);
            res = (org.w3c.dom.Document)result.getNode();
            log.finest("xsl result = " + XMLPrettyPrinter.prettyPrint((org.w3c.dom.Document)res));
        }
        catch (IOException e) {
            throw new XPathExpressionException((Throwable)e);
        }
        catch (TransformerConfigurationException e) {
            throw new XPathExpressionException((Throwable)e);
        }
        catch (TransformerException e) {
            throw new XPathExpressionException((Throwable)e);
        }
        finally {
            try {
                styleSheet.getInputStream().close();
            }
            catch (Exception e) {}
        }
        return res;
    }
}

