/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.xpath.exp.impl.verification;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import com.ebmwebsourcing.easybpel.xpath.exp.api.verification.TypeVerifier;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import java.util.Date;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.jdom.Element;

public class TypeVerifier2Impl
implements TypeVerifier {
    private BPELProcess bpeldefinition = null;

    public TypeVerifier2Impl(BPELProcess bpeldefinition) {
        this.bpeldefinition = bpeldefinition;
    }

    public Class<?> compare(Element e1, Element e2) throws XPathExpressionException {
        Class res = null;
        if (this.isInteger(e1) && this.isInteger(e2)) {
            res = Integer.class;
        } else if (this.isInteger(e1) && this.isLong(e2)) {
            res = Long.class;
        } else if (this.isInteger(e1) && this.isDouble(e2)) {
            res = Double.class;
        } else if (this.isLong(e1) && this.isInteger(e2)) {
            res = Long.class;
        } else if (this.isDouble(e1) && this.isInteger(e2)) {
            res = Double.class;
        } else if (this.isLong(e1) && this.isLong(e2)) {
            res = Long.class;
        } else if (this.isLong(e1) && this.isDouble(e2)) {
            res = Double.class;
        } else if (this.isDouble(e1) && this.isLong(e2)) {
            res = Double.class;
        } else if (this.isDouble(e1) && this.isDouble(e2)) {
            res = Double.class;
        } else if (this.isBoolean(e1) && this.isBoolean(e2)) {
            res = Boolean.class;
        } else if (this.isDateTime(e1) && this.isDateTime(e2)) {
            res = Date.class;
        } else if (this.isQName(e1) && this.isQName(e2)) {
            res = QName.class;
        } else if (this.isString(e1) && this.isString(e2)) {
            res = String.class;
        }
        return res;
    }

    private boolean isQName(Element e) {
        String prefix = null;
        if (e.getTextNormalize().indexOf(":") > 0) {
            prefix = e.getTextNormalize().substring(0, e.getTextNormalize().indexOf(":"));
            if (e.getNamespace(prefix) != null) {
                return true;
            }
            if (this.bpeldefinition.getNamespaceContext().getNamespaceURI(prefix) != null) {
                return true;
            }
        }
        return false;
    }

    public QName getQNameValue(Element e) {
        QName res = null;
        if (e.getTextNormalize().indexOf(":") > 0) {
            String prefix = e.getTextNormalize().substring(0, e.getTextNormalize().indexOf(":"));
            String localpart = e.getTextNormalize().substring(e.getTextNormalize().indexOf(":") + 1, e.getTextNormalize().length());
            String namespace = null;
            if (e.getNamespace(prefix) != null) {
                namespace = e.getNamespace(prefix).getURI();
            }
            if (this.bpeldefinition.getNamespaceContext().getNamespaceURI(prefix) != null) {
                namespace = this.bpeldefinition.getNamespaceContext().getNamespaceURI(prefix);
            }
            res = new QName(namespace, localpart);
        }
        return res;
    }

    public boolean isInteger(Element e) throws XPathExpressionException {
        try {
            Integer.parseInt(e.getTextNormalize());
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public boolean isLong(Element e) throws XPathExpressionException {
        try {
            Long.parseLong(e.getTextNormalize());
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public boolean isDouble(Element e) throws XPathExpressionException {
        try {
            Double.parseDouble(e.getTextNormalize());
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public boolean isDateTime(Element e) throws XPathExpressionException {
        String s = e.getTextNormalize();
        assert (!s.isEmpty());
        try {
            XMLGregorianCalendar xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(e.getText());
            xmlCalendar.toGregorianCalendar().getTime();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean isString(Element e) throws XPathExpressionException {
        boolean res = !e.getTextNormalize().isEmpty();
        return res;
    }

    public boolean isBoolean(Element e) throws XPathExpressionException {
        try {
            return Boolean.parseBoolean(e.getTextNormalize().toLowerCase());
        }
        catch (NumberFormatException nfe) {
            try {
                boolean res = Integer.parseInt(e.getTextNormalize()) == 1;
                return res;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
    }

    public int getIntValue(Element e) {
        String s = e.getTextNormalize();
        assert (!s.isEmpty());
        return Integer.parseInt(s);
    }

    public long getLongValue(Element e) {
        String s = e.getTextNormalize();
        assert (!s.isEmpty());
        return Long.parseLong(s);
    }

    public double getDoubleValue(Element e) {
        String s = e.getTextNormalize();
        assert (!s.isEmpty());
        return Double.parseDouble(s);
    }

    public String getStringValue(Element e) {
        String s = e.getTextNormalize();
        assert (!s.isEmpty());
        return s;
    }

    public boolean getBooleanValue(Element e) {
        String s = e.getTextNormalize();
        assert (!s.isEmpty());
        try {
            return Boolean.parseBoolean(e.getTextNormalize().toLowerCase());
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.parseInt(e.getTextNormalize()) == 1;
        }
    }

    public Date getDateTimeValue(Element e) {
        String s = e.getTextNormalize();
        assert (!s.isEmpty());
        try {
            XMLGregorianCalendar xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(e.getText());
            return xmlCalendar.toGregorianCalendar().getTime();
        }
        catch (DatatypeConfigurationException e1) {
            throw new UncheckedException((Throwable)e1);
        }
    }
}

