/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.impl;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easybox.api.XmlObjectSchemaBinding;
import com.ebmwebsourcing.easybox.api.analysis.ClassMetadata;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbModelObject;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easybox.impl.JaxbSchemaBinding;
import com.ebmwebsourcing.easybox.impl.JaxbSchemaElementBinding;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

public abstract class AbstractXmlObjectSchemaBindingImpl
implements XmlObjectSchemaBinding {
    private final JaxbSchemaBinding jaxbSchemaBinding = JaxbSchemaBinding.getJaxbSchemaBindings().get(this.getOriginatingSchemaNamespaceURI());

    protected AbstractXmlObjectSchemaBindingImpl() {
    }

    @Override
    public abstract Package getModelObjectPackage();

    @Override
    public final boolean canWrap(Object obj) {
        if (obj instanceof JAXBElement) {
            return ((JAXBElement)obj).getValue().getClass().getPackage().equals(this.getModelObjectPackage());
        }
        if (obj instanceof ModelObject) {
            return obj.getClass().getPackage().equals(this.getModelObjectPackage());
        }
        return false;
    }

    protected abstract XmlObject doWrap(XmlContext var1, Constructor<? extends XmlObject> var2, ModelObject var3) throws InstantiationException, IllegalAccessException, InvocationTargetException;

    @Override
    public final <X extends XmlObjectNode> X wrap(XmlContext xmlContext, Class<X> xmlObjectImplClass, Object obj) {
        assert (AbstractJaxbXmlObjectImpl.class.isAssignableFrom(xmlObjectImplClass));
        ModelObject modelObject = null;
        if (obj != null) {
            if (obj instanceof ModelObject) {
                modelObject = (ModelObject)obj;
            } else if (obj instanceof JAXBElement) {
                modelObject = (ModelObject)((JAXBElement)obj).getValue();
            } else {
                throw new UncheckedException(String.format("Do not know how to wrap object of class '%s'.", obj.getClass().getSimpleName()));
            }
        }
        try {
            AbstractJaxbModelObject ajo = (AbstractJaxbModelObject)modelObject;
            Constructor constructor = (Constructor)xmlContext.getClassMetadata().get(xmlObjectImplClass, "implementationClassConstructor");
            constructor.setAccessible(true);
            XmlObjectNode xmlObjectImpl = (XmlObjectNode)xmlObjectImplClass.cast(this.doWrap(xmlContext, constructor, ajo));
            return (X)xmlObjectImpl;
        }
        catch (Exception e) {
            throw new UncheckedException("Problem while wrapping class", e);
        }
    }

    private Class<? extends XmlObjectNode>[] findXmlObjectImplClassesByModelObjectClass(XmlContext xmlContext, Class<? extends ModelObject> modelObjectClass) {
        if (!xmlContext.getClassMetadata().has(modelObjectClass, "implementationClassesMetadata")) {
            xmlContext.getClassMetadata().put(modelObjectClass, "implementationClassesMetadata", this.doFindXmlObjectImplClassesByModelObjectClass(xmlContext, modelObjectClass));
        }
        return (Class[])xmlContext.getClassMetadata().get(modelObjectClass, "implementationClassesMetadata");
    }

    private Class<? extends XmlObjectNode>[] doFindXmlObjectImplClassesByModelObjectClass(XmlContext xmlContext, Class<? extends ModelObject> modelObjectClass) {
        ArrayList<Class<? extends XmlObjectNode>> result = new ArrayList<Class<? extends XmlObjectNode>>();
        for (Class<? extends XmlObjectNode> implClass : this.getFactorableClasses()) {
            Class moc = (Class)xmlContext.getClassMetadata().get(implClass, "implementationClassModelObjectClass");
            if (!moc.isAssignableFrom(modelObjectClass)) continue;
            result.add(implClass);
        }
        return result.toArray((Class[])Array.newInstance(Class.class, result.size()));
    }

    @Override
    public final XmlObjectNode wrap(XmlContext xmlContext, Object obj) {
        assert (obj != null);
        assert (obj instanceof AbstractJaxbModelObject || obj instanceof JAXBElement) : String.format("Cannot wrap instances of '%s'", obj.getClass());
        QName qname = null;
        Object ajo = null;
        Class<? extends XmlObjectNode> guessedImplClass = null;
        if (obj instanceof JAXBElement) {
            JAXBElement jaxbElement = (JAXBElement)obj;
            qname = jaxbElement.getName();
            ajo = (AbstractJaxbModelObject)jaxbElement.getValue();
        } else if (obj instanceof AbstractJaxbModelObject) {
            ajo = (AbstractJaxbModelObject)obj;
            qname = ((AbstractJaxbModelObject)ajo).getQName();
        }
        Class<?> modelObjectClass = ajo.getClass();
        Class<? extends XmlObjectNode>[] xmlObjectImplClasses = this.findXmlObjectImplClassesByModelObjectClass(xmlContext, modelObjectClass);
        ClassMetadata cmd = xmlContext.getClassMetadata();
        if (xmlObjectImplClasses.length == 0) {
            throw new UncheckedException(String.format("Do not know how to wrap object of class '%s'.", modelObjectClass.getSimpleName()));
        }
        if (xmlObjectImplClasses.length == 1) {
            guessedImplClass = xmlObjectImplClasses[0];
        } else if (xmlObjectImplClasses.length > 1) {
            for (Class<? extends XmlObjectNode> xmlObjectImplClass : xmlObjectImplClasses) {
                if (this.jaxbSchemaBinding.getJaxbBindingByClass(modelObjectClass) instanceof JaxbSchemaElementBinding && modelObjectClass.equals(cmd.get(xmlObjectImplClass, "implementationClassModelObjectClass"))) {
                    guessedImplClass = xmlObjectImplClass;
                    break;
                }
                if (!cmd.has(xmlObjectImplClass, "implementationClassConstantQName") || !qname.equals(cmd.get(xmlObjectImplClass, "implementationClassConstantQName"))) continue;
                guessedImplClass = xmlObjectImplClass;
                break;
            }
        }
        if (guessedImplClass == null) {
            StringBuffer sb = new StringBuffer();
            for (Class<? extends XmlObjectNode> xmlObjectImplClass : xmlObjectImplClasses) {
                sb.append(xmlObjectImplClass.getSimpleName()).append(" ");
            }
            throw new UncheckedException(String.format("Cannot guess unambiguously implementation class wrapping object of class '%s' ; candidates are '%s'.", modelObjectClass.getSimpleName(), sb.toString().trim()));
        }
        return this.wrap(xmlContext, guessedImplClass, ajo);
    }

    @Override
    public final <X extends XmlObjectNode> X create(XmlContext xmlContext, Class<X> xmlObjectImplClass) {
        return this.wrap(xmlContext, xmlObjectImplClass, null);
    }
}

