/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.impl;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

final class ClassPathResourceResolver
implements LSResourceResolver {
    private static Logger LOG = Logger.getLogger(ClassPathResourceResolver.class.getName());
    private static final DOMImplementationLS domImplementationLS;
    private final Set<String> originatingDirs = new HashSet<String>();
    private final Map<String, String> originatingResourcePathByNamespaceURI = new HashMap<String, String>();

    public void addOriginatingDir(String originatingDir) {
        this.originatingDirs.add(originatingDir);
    }

    public void addOriginatingResourcePath(String namespaceURI, String resourcePath) {
        this.originatingResourcePathByNamespaceURI.put(namespaceURI, resourcePath);
    }

    URL resolveResourceByNamespaceURI(String namespaceURI) {
        assert (namespaceURI != null);
        String resourcePath = this.originatingResourcePathByNamespaceURI.get(namespaceURI);
        if (resourcePath == null) {
            return null;
        }
        URL resourceURL = this.getClass().getClassLoader().getResource(resourcePath);
        return resourceURL == null ? null : resourceURL;
    }

    URL resolveResourceBySystemId(String systemId) {
        assert (systemId != null);
        URL resourceURL = this.getClass().getClassLoader().getResource(systemId);
        if (resourceURL != null) {
            return resourceURL;
        }
        for (String originatingDir : this.originatingDirs) {
            String absolutePath = originatingDir + "/" + systemId;
            resourceURL = this.getClass().getClassLoader().getResource(absolutePath);
            if (resourceURL == null) continue;
            return resourceURL;
        }
        return null;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        URL resourceURL = null;
        if (systemId != null) {
            resourceURL = this.resolveResourceBySystemId(systemId);
        } else if (namespaceURI != null) {
            resourceURL = this.resolveResourceByNamespaceURI(namespaceURI);
        }
        if (resourceURL == null) {
            LOG.warning(String.format("Cannot resolve resource { type='%s' , namespaceURI='%s', publicId='%s', systemId='%s', baseURI='%s'} from classpath.", type, namespaceURI, publicId, systemId, baseURI));
            return null;
        }
        try {
            InputStream classPathInputStream = resourceURL.openStream();
            LSInput lsInput = domImplementationLS.createLSInput();
            lsInput.setByteStream(classPathInputStream);
            return lsInput;
        }
        catch (IOException e) {
            throw new UncheckedException(String.format("Problem while opening stream from URL '%s'.", resourceURL.toString()), e);
        }
    }

    static {
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            domImplementationLS = (DOMImplementationLS)registry.getDOMImplementation("XML").getFeature("LS", "3.0");
        }
        catch (Exception e) {
            throw new UncheckedException(e);
        }
    }
}

