/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.impl;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectAttribute;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easybox.api.XmlObjectText;
import com.ebmwebsourcing.easybox.impl.AttributeModelObject;
import com.ebmwebsourcing.easybox.impl.XmlObjectAttributeImpl;
import com.ebmwebsourcing.easybox.impl.XmlObjectAttributeNodeInfo;
import com.ebmwebsourcing.easybox.impl.XmlObjectNodeInfo;
import com.ebmwebsourcing.easybox.impl.XmlObjectNodeNodeInfo;
import com.ebmwebsourcing.easybox.impl.XmlObjectTextImpl;
import com.ebmwebsourcing.easybox.impl.XmlObjectTextNodeInfo;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.namespace.QName;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.NodeArrayIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.ReverseNodeArrayIterator;
import net.sf.saxon.om.SingleNodeIterator;
import net.sf.saxon.pattern.NodeTest;

final class NodeInfoHelper {
    public static final NodeArrayIterator EMPTY_AXIS_ITERATOR = new NodeArrayIterator(new NodeInfo[0]);

    NodeInfoHelper() {
    }

    static NodeInfo wrapXmlObjectAttributeAsNodeInfo(XmlObjectAttributeImpl xmlObjectAttribute, Configuration configuration) {
        assert (xmlObjectAttribute != null);
        return new XmlObjectAttributeNodeInfo(xmlObjectAttribute, configuration);
    }

    static NodeInfo wrapXmlObjectAttributeAsNodeInfo(XmlObject xmlObject, QName key, Object value, Configuration configuration) {
        assert (xmlObject != null);
        assert (key != null);
        assert (value != null);
        XmlObjectAttributeImpl xoa = new XmlObjectAttributeImpl(xmlObject.getXmlContext(), new AttributeModelObject(null, key, value));
        return NodeInfoHelper.wrapXmlObjectAttributeAsNodeInfo(xoa, configuration);
    }

    static XmlObjectNodeNodeInfo wrapXmlObjectAsNodeInfo(XmlObjectNode xmlObjectNode, Configuration configuration) {
        assert (xmlObjectNode != null);
        if (xmlObjectNode instanceof XmlObject) {
            return new XmlObjectNodeInfo((XmlObject)xmlObjectNode, configuration);
        }
        if (xmlObjectNode instanceof XmlObjectAttribute) {
            return new XmlObjectAttributeNodeInfo((XmlObjectAttribute)xmlObjectNode, configuration);
        }
        if (xmlObjectNode instanceof XmlObjectText) {
            return new XmlObjectTextNodeInfo((XmlObjectText)xmlObjectNode, configuration);
        }
        throw new UncheckedException("Unknown XmlObjectNode kind.");
    }

    static Deque<NodeInfo> wrapXmlObjectsAsNodeInfos(XmlObjectNode[] xmlObjectNodes, NodeTest nodeTest, Configuration configuration) {
        LinkedList<NodeInfo> nodeInfos = new LinkedList<NodeInfo>();
        for (int i = 0; i < xmlObjectNodes.length; ++i) {
            NodeInfo nodeInfo = null;
            if (xmlObjectNodes[i] instanceof XmlObject) {
                nodeInfo = NodeInfoHelper.wrapXmlObjectAsNodeInfo((XmlObject)xmlObjectNodes[i], configuration);
            } else if (xmlObjectNodes[i] instanceof XmlObjectTextImpl) {
                nodeInfo = NodeInfoHelper.wrapXmlObjectTextAsNodeInfo((XmlObjectTextImpl)xmlObjectNodes[i], configuration);
            } else if (xmlObjectNodes[i] instanceof XmlObjectAttributeImpl) {
                nodeInfo = NodeInfoHelper.wrapXmlObjectAttributeAsNodeInfo((XmlObjectAttributeImpl)xmlObjectNodes[i], configuration);
            }
            if (!nodeTest.matches(nodeInfo)) continue;
            nodeInfos.add(nodeInfo);
        }
        return nodeInfos;
    }

    private static NodeInfo wrapXmlObjectTextAsNodeInfo(XmlObjectTextImpl xmlObjectText, Configuration configuration) {
        assert (xmlObjectText != null);
        return new XmlObjectTextNodeInfo(xmlObjectText, configuration);
    }

    static Deque<NodeInfo> wrapXmlObjectAttributesAsNodeInfos(XmlObject xmlObject, Map<QName, Object> xmlObjectAttributes, Configuration configuration, NodeTest nodeTest) {
        LinkedList<NodeInfo> nodeInfos = new LinkedList<NodeInfo>();
        for (Map.Entry<QName, Object> entry : xmlObjectAttributes.entrySet()) {
            NodeInfo xoani = NodeInfoHelper.wrapXmlObjectAttributeAsNodeInfo(xmlObject, entry.getKey(), entry.getValue(), configuration);
            if (!nodeTest.matches(xoani)) continue;
            nodeInfos.add(xoani);
        }
        return nodeInfos;
    }

    static AxisIterator createAncestorAxisIterator(XmlObjectNode xmlObjectNode, NodeTest nodeTest, Configuration configuration) {
        Deque<NodeInfo> ancestors = NodeInfoHelper.wrapXmlObjectsAsNodeInfos(xmlObjectNode.getXmlObjectAncestors(), nodeTest, configuration);
        return new ReverseNodeArrayIterator(ancestors.toArray(new NodeInfo[ancestors.size()]), 0, ancestors.size());
    }

    static AxisIterator createAncestorOrSelfAxisIterator(XmlObjectNode xmlObjectNode, NodeTest nodeTest, Configuration configuration) {
        Deque<NodeInfo> ancestorsOrSelf = NodeInfoHelper.wrapXmlObjectsAsNodeInfos(xmlObjectNode.getXmlObjectAncestors(), nodeTest, configuration);
        ancestorsOrSelf.add(NodeInfoHelper.wrapXmlObjectAsNodeInfo(xmlObjectNode, configuration));
        return new ReverseNodeArrayIterator(ancestorsOrSelf.toArray(new NodeInfo[ancestorsOrSelf.size()]), 0, ancestorsOrSelf.size());
    }

    static AxisIterator createAttributeIterator(XmlObjectNode xmlObjectNode, NodeTest nodeTest, Configuration configuration) {
        if (!(xmlObjectNode instanceof XmlObject)) {
            return EMPTY_AXIS_ITERATOR;
        }
        Deque<NodeInfo> attributes = NodeInfoHelper.wrapXmlObjectAttributesAsNodeInfos((XmlObject)xmlObjectNode, ((XmlObject)xmlObjectNode).getXmlObjectAttributes(), configuration, nodeTest);
        return new NodeArrayIterator(attributes.toArray(new NodeInfo[attributes.size()]));
    }

    static AxisIterator createChildIterator(XmlObjectNode xmlObjectNode, NodeTest nodeTest, Configuration configuration) {
        Deque<NodeInfo> children = NodeInfoHelper.wrapXmlObjectsAsNodeInfos(xmlObjectNode.getXmlObjectChildren(), nodeTest, configuration);
        return new NodeArrayIterator(children.toArray(new NodeInfo[children.size()]));
    }

    static AxisIterator createDescendantIterator(XmlObjectNode xmlObjectNode, NodeTest nodeTest, Configuration configuration) {
        Deque<NodeInfo> descendants = NodeInfoHelper.wrapXmlObjectsAsNodeInfos(xmlObjectNode.getXmlObjectDescendants(), nodeTest, configuration);
        return new NodeArrayIterator(descendants.toArray(new NodeInfo[descendants.size()]));
    }

    static AxisIterator createDescendantOrSelfIterator(XmlObjectNode xmlObjectNode, NodeTest nodeTest, Configuration configuration) {
        Deque<NodeInfo> descendantsOrSelf = NodeInfoHelper.wrapXmlObjectsAsNodeInfos(xmlObjectNode.getXmlObjectDescendants(), nodeTest, configuration);
        descendantsOrSelf.add(NodeInfoHelper.wrapXmlObjectAsNodeInfo(xmlObjectNode, configuration));
        return new NodeArrayIterator(descendantsOrSelf.toArray(new NodeInfo[descendantsOrSelf.size()]));
    }

    static AxisIterator createFollowingIterator(XmlObjectNode xmlObjectNode, NodeTest nodeTest, Configuration configuration) {
        Deque<NodeInfo> following = NodeInfoHelper.wrapXmlObjectsAsNodeInfos(xmlObjectNode.getXmlObjectFollowing(), nodeTest, configuration);
        return new NodeArrayIterator(following.toArray(new NodeInfo[following.size()]));
    }

    static AxisIterator createFollowingSiblingAxisIterator(XmlObjectNode xmlObjectNode, NodeTest nodeTest, Configuration configuration) {
        Deque<NodeInfo> followingSiblings = NodeInfoHelper.wrapXmlObjectsAsNodeInfos(xmlObjectNode.getXmlObjectFollowingSiblings(), nodeTest, configuration);
        return new NodeArrayIterator(followingSiblings.toArray(new NodeInfo[followingSiblings.size()]));
    }

    static AxisIterator createEmptyAxisIterator() {
        return EmptyIterator.getInstance();
    }

    static AxisIterator createSingletonAxisIterator(NodeInfo nodeInfo) {
        return SingleNodeIterator.makeIterator(nodeInfo);
    }

    static AxisIterator createParentAxisIterator(XmlObjectNode xmlObjectNode, NodeTest nodeTest, Configuration configuration) {
        XmlObject parent = xmlObjectNode.getXmlObjectParent();
        if (parent == null) {
            return NodeInfoHelper.createEmptyAxisIterator();
        }
        XmlObjectNodeNodeInfo parentNodeInfo = NodeInfoHelper.wrapXmlObjectAsNodeInfo(parent, configuration);
        if (!nodeTest.matches(parentNodeInfo)) {
            return NodeInfoHelper.createEmptyAxisIterator();
        }
        return SingleNodeIterator.makeIterator(parentNodeInfo);
    }

    static AxisIterator createPrecedingAxisIterator(XmlObjectNode xmlObjectNode, NodeTest nodeTest, Configuration configuration) {
        Deque<NodeInfo> preceding = NodeInfoHelper.wrapXmlObjectsAsNodeInfos(xmlObjectNode.getXmlObjectPreceding(), nodeTest, configuration);
        return new ReverseNodeArrayIterator(preceding.toArray(new NodeInfo[preceding.size()]), 0, preceding.size());
    }

    static AxisIterator createPrecedingOrAncestorAxisIterator(XmlObjectNode xmlObjectNode, NodeTest nodeTest, Configuration configuration) {
        Deque<NodeInfo> precedingOrAncestor = NodeInfoHelper.wrapXmlObjectsAsNodeInfos(xmlObjectNode.getXmlObjectPrecedingOrAncestor(), nodeTest, configuration);
        return new NodeArrayIterator(precedingOrAncestor.toArray(new NodeInfo[precedingOrAncestor.size()]));
    }

    static AxisIterator createPrecedingSiblingAxisIterator(XmlObjectNode xmlObjectNode, NodeTest nodeTest, Configuration configuration) {
        Deque<NodeInfo> precedingSibling = NodeInfoHelper.wrapXmlObjectsAsNodeInfos(xmlObjectNode.getXmlObjectPrecedingSiblings(), nodeTest, configuration);
        return new ReverseNodeArrayIterator(precedingSibling.toArray(new NodeInfo[precedingSibling.size()]), 0, precedingSibling.size());
    }

    static AxisIterator createSelfAxisIterator(XmlObjectNode xmlObjectNode, NodeTest nodeTest, Configuration configuration) {
        return new NodeArrayIterator(new NodeInfo[]{NodeInfoHelper.wrapXmlObjectAsNodeInfo(xmlObjectNode, configuration)});
    }

    static AxisIterator createAxisIterator(byte axisNumber, XmlObjectNode xmlObjectNode, NodeTest nodeTest, Configuration configuration) {
        switch (axisNumber) {
            case 0: {
                return NodeInfoHelper.createAncestorAxisIterator(xmlObjectNode, nodeTest, configuration);
            }
            case 1: {
                return NodeInfoHelper.createAncestorOrSelfAxisIterator(xmlObjectNode, nodeTest, configuration);
            }
            case 2: {
                return NodeInfoHelper.createAttributeIterator(xmlObjectNode, nodeTest, configuration);
            }
            case 3: {
                return NodeInfoHelper.createChildIterator(xmlObjectNode, nodeTest, configuration);
            }
            case 4: {
                return NodeInfoHelper.createDescendantIterator(xmlObjectNode, nodeTest, configuration);
            }
            case 5: {
                return NodeInfoHelper.createDescendantOrSelfIterator(xmlObjectNode, nodeTest, configuration);
            }
            case 6: {
                return NodeInfoHelper.createFollowingIterator(xmlObjectNode, nodeTest, configuration);
            }
            case 7: {
                return NodeInfoHelper.createFollowingSiblingAxisIterator(xmlObjectNode, nodeTest, configuration);
            }
            case 8: {
                throw new Error("Not implemented yet.");
            }
            case 9: {
                return NodeInfoHelper.createParentAxisIterator(xmlObjectNode, nodeTest, configuration);
            }
            case 10: {
                return NodeInfoHelper.createPrecedingAxisIterator(xmlObjectNode, nodeTest, configuration);
            }
            case 13: {
                return NodeInfoHelper.createPrecedingOrAncestorAxisIterator(xmlObjectNode, nodeTest, configuration);
            }
            case 11: {
                return NodeInfoHelper.createPrecedingSiblingAxisIterator(xmlObjectNode, nodeTest, configuration);
            }
            case 12: {
                return NodeInfoHelper.createSelfAxisIterator(xmlObjectNode, nodeTest, configuration);
            }
        }
        return null;
    }
}

