/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObjectBinding;
import com.ebmwebsourcing.easybox.api.XmlObjectFactory;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easybox.api.XmlObjectSchemaBinding;
import com.ebmwebsourcing.easybox.api.XmlObjectValidator;
import com.ebmwebsourcing.easybox.api.XmlObjectWriter;
import com.ebmwebsourcing.easybox.api.XmlObjectXPathEvaluator;
import com.ebmwebsourcing.easybox.api.XmlObjectXQueryEvaluator;
import com.ebmwebsourcing.easybox.api.XmlObjectXQueryValidator;
import com.ebmwebsourcing.easybox.api.analysis.Analyzer;
import com.ebmwebsourcing.easybox.api.analysis.AnalyzerException;
import com.ebmwebsourcing.easybox.api.analysis.ClassMetadata;
import com.ebmwebsourcing.easybox.impl.JaxbAddExtraInfoUnmarshallListener;
import com.ebmwebsourcing.easybox.impl.XmlObjectFactoryImpl;
import com.ebmwebsourcing.easybox.impl.XmlObjectReaderImpl;
import com.ebmwebsourcing.easybox.impl.XmlObjectValidatorImpl;
import com.ebmwebsourcing.easybox.impl.XmlObjectWriterImpl;
import com.ebmwebsourcing.easybox.impl.XmlObjectXPathEvaluatorImpl;
import com.ebmwebsourcing.easybox.impl.XmlObjectXQueryEvaluatorImpl;
import com.ebmwebsourcing.easybox.impl.XmlObjectXQueryValidatorImpl;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.lang.reflect.ReflectionHelper;
import com.ebmwebsourcing.easycommons.xml.DefaultNamespaceContext;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.w3c.dom.Node;

public final class XmlContextImpl
implements XmlContext {
    private static Logger LOG = Logger.getLogger(XmlContextImpl.class.getName());
    private Map<String, XmlObjectBinding> bindings = new HashMap<String, XmlObjectBinding>();
    private XmlObjectFactory xmlObjectFactory = null;
    private JAXBContext jaxbContext = null;
    private ClassMetadata classMetadata = new ClassMetadata();
    private DefaultNamespaceContext namespaceContext = new DefaultNamespaceContext();

    @Override
    public XmlObjectBinding[] getXmlObjectBindings() {
        return this.bindings.values().toArray(new XmlObjectBinding[this.bindings.size()]);
    }

    @Override
    public void addXmlObjectBindings(String ... bindingNames) {
        this.clearXmlObjectBindings();
        LinkedList jaxbFactoryClasses = new LinkedList();
        ServiceLoader<XmlObjectBinding> sl = ServiceLoader.load(XmlObjectBinding.class);
        List<String> bindingNamesList = Arrays.asList(bindingNames);
        for (XmlObjectBinding xob : sl) {
            if (bindingNames.length != 0 && !bindingNamesList.contains(xob.getName())) continue;
            this.bindings.put(xob.getName(), xob);
            Analyzer analyzer = new Analyzer(xob, this.classMetadata);
            try {
                analyzer.analyze();
            }
            catch (AnalyzerException e) {
                throw new UncheckedException(e);
            }
            if (!(xob instanceof XmlObjectSchemaBinding)) continue;
            XmlObjectSchemaBinding xosb = (XmlObjectSchemaBinding)xob;
            this.namespaceContext.bindNamespace(xosb.getOriginatingSchemaPreferredNamespacePrefix(), xosb.getOriginatingSchemaNamespaceURI());
            String jaxbFactoryClassName = xosb.getModelObjectPackage().getName() + ".ObjectFactory";
            try {
                Class<?> jaxbFactoryClass = Class.forName(jaxbFactoryClassName);
                String jaxbFactoryClassFile = jaxbFactoryClassName.replaceAll("\\.", "/") + ".class";
                ArrayList<URL> jaxbFactoryClassFileUrls = Collections.EMPTY_LIST;
                try {
                    jaxbFactoryClassFileUrls = Collections.list(this.getClass().getClassLoader().getResources(jaxbFactoryClassFile));
                }
                catch (IOException ioe) {
                    LOG.log(Level.SEVERE, String.format("Several class files (%d) for '%s' are found in classpath, JAXB behaviour is unpredictable.", jaxbFactoryClassFileUrls.size(), jaxbFactoryClass.getName()), ioe);
                }
                jaxbFactoryClasses.add(jaxbFactoryClass);
            }
            catch (ClassNotFoundException cnfe) {
                throw new UncheckedException(String.format("Cannot found JAXB factory class '%s'.", jaxbFactoryClassName), cnfe);
            }
            LOG.config(String.format("Registered JAXB schema binding : '%s' => '%s'.", xosb.getOriginatingSchemaNamespaceURI(), xosb.getModelObjectPackage().getName()));
        }
        try {
            this.jaxbContext = JAXBContext.newInstance(jaxbFactoryClasses.toArray(new Class[jaxbFactoryClasses.size()]));
        }
        catch (JAXBException je) {
            throw new UncheckedException("Problem while instantiating JAXB context.", je);
        }
        this.xmlObjectFactory = null;
    }

    @Override
    public void removeXmlObjectBindings(String ... bindingNames) {
        for (String bindingName : bindingNames) {
            this.bindings.remove(bindingName);
        }
        this.xmlObjectFactory = null;
    }

    @Override
    public void clearXmlObjectBindings() {
        this.bindings.clear();
        this.classMetadata.clear();
        this.xmlObjectFactory = null;
        this.namespaceContext = new DefaultNamespaceContext();
    }

    @Override
    public XmlObjectFactory getXmlObjectFactory() {
        if (this.xmlObjectFactory == null) {
            this.xmlObjectFactory = new XmlObjectFactoryImpl(this);
        }
        return this.xmlObjectFactory;
    }

    JAXBContext getJaxbContext() {
        return this.jaxbContext;
    }

    Binder<Node> newBinder() {
        Binder<Node> binder = this.jaxbContext.createBinder();
        Method getUnmarshallerMethod = ReflectionHelper.getDeclaredMethod(binder.getClass(), "getUnmarshaller", new Class[0]);
        getUnmarshallerMethod.setAccessible(true);
        try {
            Unmarshaller unmarshaller = (Unmarshaller)ReflectionHelper.invokeMethod(binder, getUnmarshallerMethod, new Object[0]);
            unmarshaller.setListener(new JaxbAddExtraInfoUnmarshallListener(binder));
        }
        catch (InvocationTargetException ite) {
            throw new UncheckedException("Cannot invoke 'getUnmarshaller' method on Binder class.", ite);
        }
        return binder;
    }

    @Override
    public XmlObjectReader createReader() {
        return new XmlObjectReaderImpl(this);
    }

    @Override
    public XmlObjectValidator createValidator() {
        return new XmlObjectValidatorImpl(this);
    }

    @Override
    public XmlObjectWriter createWriter() {
        return new XmlObjectWriterImpl(this);
    }

    @Override
    public XmlObjectXPathEvaluator createXPathEvaluator() {
        return new XmlObjectXPathEvaluatorImpl(this.namespaceContext);
    }

    @Override
    public ClassMetadata getClassMetadata() {
        return this.classMetadata;
    }

    @Override
    public XmlObjectXQueryEvaluator createXQueryEvaluator() {
        return new XmlObjectXQueryEvaluatorImpl(this.namespaceContext);
    }

    @Override
    public XmlObjectXQueryValidator createXQueryValidator() {
        return new XmlObjectXQueryValidatorImpl(this.namespaceContext);
    }
}

