/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.impl;

import com.ebmwebsourcing.easybox.api.Catalog;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easybox.api.XmlObjectXPathEvaluator;
import com.ebmwebsourcing.easybox.impl.InadequateChildAdoptionException;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.uri.URIHelper;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;

final class XmlObjectAdoptionMediator {
    private final Map<String, XmlObject> adoptedChildrenCache = new HashMap<String, XmlObject>();

    XmlObjectAdoptionMediator(XmlObject xmlObject) {
        URI baseURI = xmlObject.getXmlObjectBaseURI();
        if (baseURI != null) {
            this.adoptedChildrenCache.put(this.makeAdoptedChildKey(baseURI, ""), xmlObject.getXmlObjectBaseRoot());
        }
    }

    private String makeAdoptedChildKey(URI baseURI, String xpath) {
        assert (baseURI != null);
        return baseURI.toString() + "#" + xpath;
    }

    private XmlObject resolveXPath(XmlObject contextXmlObject, String xpath) {
        if (xpath.isEmpty()) {
            return contextXmlObject;
        }
        XmlObjectXPathEvaluator xpe = contextXmlObject.getXmlContext().createXPathEvaluator();
        try {
            XmlObject childToAdopt = xpe.selectSingleXmlObjectNode(contextXmlObject, xpath, XmlObject.class);
            return childToAdopt;
        }
        catch (XPathExpressionException xpee) {
            throw new UncheckedException(String.format("Invalid XPath expression '%s'.", xpath));
        }
    }

    private XmlObject adoptChild(XmlObject adoptiveParent, URI sourceUri, String xpath) throws InadequateChildAdoptionException {
        XmlObject childToAdopt;
        String key;
        assert (adoptiveParent != null);
        assert (sourceUri != null);
        if (xpath == null) {
            xpath = "";
        }
        if (this.adoptedChildrenCache.containsKey(key = this.makeAdoptedChildKey(sourceUri, xpath))) {
            return this.adoptedChildrenCache.get(key);
        }
        URI baseURI = adoptiveParent.getXmlObjectBaseURI();
        if (baseURI == null) {
            throw new InadequateChildAdoptionException("Cannot adopt child because adoptive parent has no base URI");
        }
        if (baseURI.equals(sourceUri)) {
            childToAdopt = this.resolveXPath(adoptiveParent.getXmlObjectRoot(), xpath);
        } else {
            XmlObjectReader reader = adoptiveParent.getXmlContext().createReader();
            reader.setReadMode(XmlObjectReader.ReadMode.LAZY);
            try {
                XmlObject readXmlObject = reader.readDocument(sourceUri.toURL(), XmlObject.class);
                childToAdopt = this.resolveXPath(readXmlObject, xpath);
            }
            catch (MalformedURLException e) {
                throw new UncheckedException(String.format("Cannot adopt child from URI '%s' and XPath '%s' (MalformedURLException).", sourceUri.toString(), xpath), e);
            }
            catch (XmlObjectReadException e) {
                throw new UncheckedException(String.format("Cannot adopt child from URI '%s' and XPath '%s' (XmlObjectReadException).", sourceUri.toString(), xpath), e);
            }
        }
        assert (childToAdopt != null);
        this.adoptedChildrenCache.put(key, childToAdopt);
        return childToAdopt;
    }

    XmlObject adoptChild(XmlObject parentAdopter, String publicId, String systemId, Object object) throws InadequateChildAdoptionException {
        assert (parentAdopter != null);
        URI resolvedUri = null;
        try {
            if (publicId != null) {
                resolvedUri = Catalog.getInstance().resolveUri(publicId);
            }
            if (resolvedUri == null) {
                if (systemId == null) {
                    systemId = publicId;
                }
                URI baseURI = parentAdopter.getXmlObjectBaseURI();
                URI newUri = URIHelper.resolve(baseURI, systemId);
                resolvedUri = Catalog.getInstance().resolveUri(newUri);
                if (resolvedUri == null) {
                    resolvedUri = newUri;
                }
            }
        }
        catch (MalformedURLException e) {
            throw new InadequateChildAdoptionException(e.getMessage());
        }
        catch (URISyntaxException e) {
            throw new InadequateChildAdoptionException(e.getMessage());
        }
        return this.adoptChild(parentAdopter, resolvedUri, null);
    }
}

