/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.impl;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObjectBinding;
import com.ebmwebsourcing.easybox.api.XmlObjectFactory;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;

final class XmlObjectFactoryImpl
implements XmlObjectFactory {
    private final XmlContext xmlContext;

    public XmlObjectFactoryImpl(XmlContext xmlContext) {
        this.xmlContext = xmlContext;
    }

    @Override
    public <X extends XmlObjectNode> X wrap(Object obj, Class<X> xmlObjectClassOrInterface) {
        ModelObject modelObject;
        if (obj instanceof ModelObject && (modelObject = (ModelObject)obj).getXmlObject() != null) {
            return (X)modelObject.getXmlObject();
        }
        if (xmlObjectClassOrInterface.isInterface()) {
            return this.doWrapGivenXmlObjectInterfaceClass(obj, xmlObjectClassOrInterface);
        }
        return this.doWrapGivenXmlObjectImplClass(obj, xmlObjectClassOrInterface);
    }

    @Override
    public XmlObjectNode wrap(Object obj) {
        ModelObject modelObject;
        if (obj instanceof ModelObject && (modelObject = (ModelObject)obj).getXmlObject() != null) {
            return modelObject.getXmlObject();
        }
        for (XmlObjectBinding xob : this.xmlContext.getXmlObjectBindings()) {
            if (!xob.canWrap(obj)) continue;
            return xob.wrap(this.xmlContext, obj);
        }
        throw new UncheckedException(String.format("Cannot find an XmlObjectBinding capable of wrapping object class '%s'.", obj.getClass()));
    }

    private <X extends XmlObjectNode> X doWrapGivenXmlObjectImplClass(Object obj, Class<X> xmlObjectImplClass) {
        assert (xmlObjectImplClass != null);
        XmlObjectBinding binding = (XmlObjectBinding)this.xmlContext.getClassMetadata().get(xmlObjectImplClass, "implementationClassBinding");
        return binding.wrap(this.xmlContext, xmlObjectImplClass, obj);
    }

    private <X extends XmlObjectNode> X doWrapGivenXmlObjectInterfaceClass(Object obj, Class<X> xmlObjectInterfaceClass) {
        Class xmlObjectImplClass = (Class)this.xmlContext.getClassMetadata().get(xmlObjectInterfaceClass, "interfaceClassImplementationClass");
        assert (xmlObjectImplClass != null) : String.format("No implementation class found for interface '%s'", xmlObjectInterfaceClass.getSimpleName());
        return this.doWrapGivenXmlObjectImplClass(obj, xmlObjectImplClass);
    }

    @Override
    public <X extends XmlObjectNode> X create(Class<X> xmlObjectClassOrInterface) {
        if (xmlObjectClassOrInterface.isInterface()) {
            return this.doCreateGivenXmlObjectInterfaceClass(xmlObjectClassOrInterface);
        }
        return this.doCreateGivenXmlObjectImplClass(xmlObjectClassOrInterface);
    }

    private <X extends XmlObjectNode> X doCreateGivenXmlObjectImplClass(Class<X> xmlObjectImplClass) {
        assert (xmlObjectImplClass != null);
        XmlObjectBinding binding = (XmlObjectBinding)this.xmlContext.getClassMetadata().get(xmlObjectImplClass, "implementationClassBinding");
        return binding.create(this.xmlContext, xmlObjectImplClass);
    }

    private <X extends XmlObjectNode> X doCreateGivenXmlObjectInterfaceClass(Class<X> xmlObjectInterfaceClass) {
        assert (xmlObjectInterfaceClass != null);
        if (!this.xmlContext.getClassMetadata().has(xmlObjectInterfaceClass, "interfaceClassImplementationClass")) {
            throw new UncheckedException(String.format("No implementation class found for interface '%s'", xmlObjectInterfaceClass.getName()));
        }
        Class xmlObjectImplClass = (Class)this.xmlContext.getClassMetadata().get(xmlObjectInterfaceClass, "interfaceClassImplementationClass");
        return this.doCreateGivenXmlObjectImplClass(xmlObjectImplClass);
    }
}

