/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.impl;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectBinding;
import com.ebmwebsourcing.easybox.api.XmlObjectSchemaBinding;
import com.ebmwebsourcing.easybox.api.XmlObjectValidationException;
import com.ebmwebsourcing.easybox.api.XmlObjectValidator;
import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easybox.api.XmlObjectWriter;
import com.ebmwebsourcing.easybox.impl.ClassPathResourceResolver;
import com.ebmwebsourcing.easybox.impl.XmlContextImpl;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ServiceLoader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.ValidatorHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlObjectValidatorImpl
implements XmlObjectValidator {
    private static final Schema schema = XmlObjectValidatorImpl.initializeSchema();
    private XmlContextImpl context;

    private static Schema initializeSchema() {
        Schema schema = null;
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        ClassPathResourceResolver cprr = new ClassPathResourceResolver();
        ServiceLoader<XmlObjectBinding> loader = ServiceLoader.load(XmlObjectBinding.class);
        Iterator<XmlObjectBinding> it = loader.iterator();
        LinkedList<StreamSource> schemaSources = new LinkedList<StreamSource>();
        while (it.hasNext()) {
            XmlObjectBinding xob = it.next();
            if (!(xob instanceof XmlObjectSchemaBinding)) continue;
            XmlObjectSchemaBinding xosb = (XmlObjectSchemaBinding)xob;
            String schemaResourcePath = xosb.getOriginatingSchemaDir() + "/" + xosb.getOriginatingSchemaName();
            cprr.addOriginatingDir(xosb.getOriginatingSchemaDir());
            cprr.addOriginatingResourcePath(xosb.getOriginatingSchemaNamespaceURI(), schemaResourcePath);
            InputStream schemaInputStream = XmlObjectValidatorImpl.class.getClassLoader().getResourceAsStream(schemaResourcePath);
            if (schemaInputStream == null) continue;
            schemaSources.add(new StreamSource(schemaInputStream));
        }
        schemaFactory.setResourceResolver(cprr);
        try {
            schema = schemaFactory.newSchema(schemaSources.toArray(new Source[schemaSources.size()]));
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return schema;
    }

    XmlObjectValidatorImpl(XmlContextImpl context) {
        this.context = context;
    }

    @Override
    public void failFastValidate(XmlObject xmlObject) throws XmlObjectValidationException {
        FailFastErrorHandler failFastErrorHandler = new FailFastErrorHandler();
        try {
            this.validate(xmlObject, failFastErrorHandler);
        }
        catch (FailFastValidationException ffve) {
            throw new XmlObjectValidationException("xml object is not valid!", ffve.getCause());
        }
    }

    @Override
    public void validate(XmlObject xmlObject, ErrorHandler errorHandler) {
        ValidatorHandler validatorHandler = schema.newValidatorHandler();
        validatorHandler.setErrorHandler(errorHandler);
        XmlObjectWriter writer = this.context.createWriter();
        try {
            writer.writeDocument(xmlObject, validatorHandler);
        }
        catch (XmlObjectWriteException e) {
            throw new UncheckedException("Unexpected problem while  validating XmlObject.");
        }
    }

    private static final class FailFastValidationException
    extends RuntimeException {
        private static final long serialVersionUID = 633136600651546753L;

        public FailFastValidationException(SAXParseException e) {
            super(e);
        }

        @Override
        public SAXParseException getCause() {
            return (SAXParseException)super.getCause();
        }
    }

    private static final class FailFastErrorHandler
    extends DefaultHandler {
        private FailFastErrorHandler() {
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.fatalError(e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw new FailFastValidationException(e);
        }
    }
}

