/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.impl;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easybox.api.XmlObjectXPathEvaluator;
import com.ebmwebsourcing.easybox.impl.NodeInfoHelper;
import com.ebmwebsourcing.easybox.impl.XmlContextImpl;
import com.ebmwebsourcing.easybox.impl.XmlObjectNodeInfo;
import com.ebmwebsourcing.easybox.impl.XmlObjectNodeNodeInfo;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import net.sf.saxon.Configuration;
import net.sf.saxon.xpath.XPathEvaluator;

final class XmlObjectXPathEvaluatorImpl
implements XmlObjectXPathEvaluator {
    private static Logger LOG = Logger.getLogger(XmlContextImpl.class.getName());
    private final Configuration configuration = new Configuration();
    private final NamespaceContext namespaceContext;

    XmlObjectXPathEvaluatorImpl(NamespaceContext namespaceContext) {
        this.namespaceContext = namespaceContext;
    }

    @Override
    public <X extends XmlObjectNode> X selectSingleXmlObjectNode(XmlObject xmlObjectContextNode, String xpathStr, Class<X> resultInterfaceClass) throws XPathExpressionException {
        LOG.finest(String.format("Executing XPath query '%s'.", xpathStr));
        XPathEvaluator eval = new XPathEvaluator(this.configuration);
        eval.setNamespaceContext(this.namespaceContext);
        XmlObjectNodeNodeInfo nodeInfo = NodeInfoHelper.wrapXmlObjectAsNodeInfo(xmlObjectContextNode, this.configuration);
        try {
            Object result = eval.evaluate(xpathStr, nodeInfo, XPathConstants.NODE);
            if (result == null) {
                LOG.finest(String.format("Executed XPath query successfully. 0 node found.", new Object[0]));
                return null;
            }
            if (result instanceof XmlObjectNodeInfo) {
                XmlObjectNode xon = ((XmlObjectNodeNodeInfo)result).getXmlObjectNode();
                if (!resultInterfaceClass.isInstance(xon)) {
                    throw new UncheckedException(String.format("XPath expression '%s' does not select a single '%s' XML object node.", xpathStr, resultInterfaceClass.getName()));
                }
                LOG.finest(String.format("Executed XPath query successfully. 1 node found.", new Object[0]));
                return (X)((XmlObjectNode)resultInterfaceClass.cast(xon));
            }
            throw new UncheckedException(String.format("XPath expression '%s' does not select a single XML object node.", xpathStr));
        }
        catch (XPathExpressionException xpee) {
            throw new UncheckedException(xpee);
        }
    }

    @Override
    public <X extends XmlObjectNode> X[] selectXmlObjectNodes(XmlObject xmlObjectContextNode, String xpathStr, Class<X> resultInterfaceClass) throws XPathExpressionException {
        ArrayList<X> listResult = new ArrayList<X>();
        LOG.finest(String.format("Executing XPath query '%s'.", xpathStr));
        XPathEvaluator eval = new XPathEvaluator(this.configuration);
        eval.setNamespaceContext(this.namespaceContext);
        XmlObjectNodeNodeInfo nodeInfo = NodeInfoHelper.wrapXmlObjectAsNodeInfo(xmlObjectContextNode, this.configuration);
        Object result = eval.evaluate(xpathStr, nodeInfo, XPathConstants.NODESET);
        if (result instanceof List) {
            List list = (List)result;
            for (Object item : list) {
                if (item instanceof XmlObjectNodeNodeInfo) {
                    XmlObjectNode xon = ((XmlObjectNodeNodeInfo)item).getXmlObjectNode();
                    if (!resultInterfaceClass.isInstance(xon)) {
                        throw new UncheckedException(String.format("XPath expression '%s' does not select '%s' XML object nodes.", xpathStr, resultInterfaceClass.getName()));
                    }
                    listResult.add(resultInterfaceClass.cast(xon));
                    continue;
                }
                throw new UncheckedException(String.format("XPath expression '%s' does not select XML object nodes.", xpathStr));
            }
        }
        LOG.finest(String.format("Executed XPath query successfully. %d node(s) found.", listResult.size()));
        return listResult.toArray((XmlObjectNode[])Array.newInstance(resultInterfaceClass, listResult.size()));
    }
}

