/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.impl;

import com.ebmwebsourcing.easybox.api.XQueryException;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easybox.api.XmlObjectXQueryEvaluator;
import com.ebmwebsourcing.easybox.impl.XmlObjectNodeInfo;
import com.ebmwebsourcing.easybox.impl.XmlObjectNodeNodeInfo;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.xml.DefaultNamespaceContext;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.saxon.Configuration;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trans.XPathException;

final class XmlObjectXQueryEvaluatorImpl
implements XmlObjectXQueryEvaluator {
    private static Logger LOG = Logger.getLogger(XmlObjectXQueryEvaluatorImpl.class.getName());
    private final Configuration configuration = new Configuration();
    private final StaticQueryContext staticQueryContext = this.configuration.newStaticQueryContext();

    XmlObjectXQueryEvaluatorImpl(DefaultNamespaceContext namespaceContext) {
        for (Map.Entry<String, String> namespaceBinding : namespaceContext.getNamespaces().entrySet()) {
            this.staticQueryContext.declareNamespace(namespaceBinding.getKey(), namespaceBinding.getValue());
        }
    }

    @Override
    public <X extends XmlObjectNode> X selectSingleXmlObjectNode(XmlObject xmlObjectContextNode, String xqueryString, Class<X> resultInterfaceClass) throws XQueryException {
        LOG.finest(String.format("Executing XQuery query '%s'.", xqueryString));
        try {
            XQueryExpression exp = this.staticQueryContext.compileQuery(xqueryString);
            DynamicQueryContext dynamicContext = new DynamicQueryContext(this.configuration);
            dynamicContext.setContextItem(new XmlObjectNodeInfo(xmlObjectContextNode, this.configuration));
            Object result = exp.evaluateSingle(dynamicContext);
            if (result == null) {
                LOG.finest(String.format("Executed XQuery query successfully. 0 node found.", new Object[0]));
                return null;
            }
            if (result instanceof XmlObjectNodeInfo) {
                XmlObjectNode xon = ((XmlObjectNodeNodeInfo)result).getXmlObjectNode();
                if (!resultInterfaceClass.isInstance(xon)) {
                    throw new UncheckedException(String.format("XQuery expression '%s' does not select a single '%s' XML object node.", xqueryString, resultInterfaceClass.getName()));
                }
                LOG.finest(String.format("Executed XQuery expression successfully. 1 node found.", new Object[0]));
                return (X)((XmlObjectNode)resultInterfaceClass.cast(xon));
            }
            throw new UncheckedException(String.format("XQuery expression '%s' does not select a single XML object node.", xqueryString));
        }
        catch (XPathException xpe) {
            throw new XQueryException(String.format("Error while evaluating XQuery expression '%s'.", xqueryString), xpe);
        }
    }

    @Override
    public <X extends XmlObjectNode> X[] selectXmlObjectNodes(XmlObject xmlObjectContextNode, String xqueryString, Class<X> resultInterfaceClass) throws XQueryException {
        LOG.finest(String.format("Executing XQuery query '%s'.", xqueryString));
        ArrayList<X> listResult = new ArrayList<X>();
        try {
            XQueryExpression exp = this.staticQueryContext.compileQuery(xqueryString);
            DynamicQueryContext dynamicContext = new DynamicQueryContext(this.configuration);
            dynamicContext.setContextItem(new XmlObjectNodeInfo(xmlObjectContextNode, this.configuration));
            List result = exp.evaluate(dynamicContext);
            for (Object item : result) {
                if (item instanceof XmlObjectNodeNodeInfo) {
                    XmlObjectNode xon = ((XmlObjectNodeNodeInfo)item).getXmlObjectNode();
                    if (!resultInterfaceClass.isInstance(xon)) {
                        throw new UncheckedException(String.format("XQuery expression '%s' does not select '%s' XML object nodes.", xqueryString, resultInterfaceClass.getName()));
                    }
                    listResult.add(resultInterfaceClass.cast(xon));
                    continue;
                }
                throw new UncheckedException(String.format("XQuery expression '%s' does not select XML object nodes.", xqueryString));
            }
        }
        catch (XPathException xpe) {
            throw new XQueryException(String.format("Error while evaluating XQuery expression '%s'.", xqueryString), xpe);
        }
        LOG.finest(String.format("Executed XQuery query successfully. '%s' node(s) found.", listResult.size()));
        return listResult.toArray((XmlObjectNode[])Array.newInstance(resultInterfaceClass, listResult.size()));
    }

    @Override
    public List<?> evaluate(XmlObject xmlObjectContextNode, String xqueryString) throws XQueryException {
        LOG.finest(String.format("Executing XQuery query '%s'.", xqueryString));
        try {
            XQueryExpression exp = this.staticQueryContext.compileQuery(xqueryString);
            DynamicQueryContext dynamicContext = new DynamicQueryContext(this.configuration);
            dynamicContext.setContextItem(new XmlObjectNodeInfo(xmlObjectContextNode, this.configuration));
            List result = exp.evaluate(dynamicContext);
            LOG.finest(String.format("Executed XQuery expression successfully.", new Object[0]));
            return result;
        }
        catch (XPathException xpe) {
            throw new XQueryException(String.format("Error while evaluating XQuery expression '%s'.", xqueryString), xpe);
        }
    }
}

