/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.CorrelationSetValidator;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.CorrelationSet;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.ScopeUtil;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import javax.xml.namespace.QName;
import org.petalslink.abslayer.service.api.Property;

public class CorrelationSetValidatorImpl
implements CorrelationSetValidator {
    private CorrelationSet correlationSet = null;

    public CorrelationSetValidatorImpl(CorrelationSet correlationSet) {
        this.correlationSet = correlationSet;
    }

    @Override
    public void validate() {
        if (this.correlationSet.getName() == null || this.correlationSet.getName().trim().length() == 0) {
            BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.correlationSet, new BPELException("In CorrelationSet => The name cannot be null or empty")));
        }
        if (this.correlationSet.getProperties() == null || this.correlationSet.getProperties().size() == 0) {
            BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.correlationSet, new BPELException("In CorrelationSet => The properties cannot be null or empty")));
        }
        BPELProcess process = ScopeUtil.getProcess(this.correlationSet);
        if (this.correlationSet.getProperties() != null) {
            for (QName propertyName : this.correlationSet.getProperties()) {
                Property prop = process.getImports().getProperty(propertyName);
                if (prop != null) continue;
                BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.correlationSet, new BPELException("In CorrelationSet => Impossible to find property corresponding to this name " + propertyName)));
            }
        }
    }
}

