/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.OnMessageValidator;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.ScopeUtil;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TOnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELInfoImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.Operation;
import org.petalslink.abslayer.service.api.PartnerLinkType;
import org.petalslink.abslayer.service.api.Role;

public class OnMessageValidatorImpl
implements OnMessageValidator {
    private static Logger log = Logger.getLogger(OnMessageValidatorImpl.class.getName());
    private OnMessage message = null;

    public OnMessageValidatorImpl(OnMessage onMessage) {
        this.message = onMessage;
    }

    @Override
    public void validate() {
        BPELVariable var;
        log.finest("validate onMessage");
        if (((TOnMessage)((BPELElementImpl)((Object)this.message)).getModel()).getFromParts() != null && ((TOnMessage)((BPELElementImpl)((Object)this.message)).getModel()).getFromParts().getFromPart().size() > 0) {
            BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(this.message, "In OnMessage => [BPEL engine Restriction] Sorry, but the activity fromPart is not supported by BPEL engine for the moment. Use assign element after this receive instead"));
            BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => [BPEL engine Restriction] Sorry, but the activity fromPart is not supported by BPEL engine for the moment. Use assign element after this receive instead")));
        }
        if (((TOnMessage)((BPELElementImpl)((Object)this.message)).getModel()).getMessageExchange() != null) {
            BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(this.message, "In OnMessage => [BPEL engine Restriction] Sorry, but the messageExchange attribute is not supported by BPEL engine for the moment."));
            BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => [BPEL engine Restriction] Sorry, but the messageExchange attribute is not supported by BPEL engine for the moment.")));
        }
        if (this.message.getPartnerLink() == null || this.message.getPartnerLink().trim().length() == 0) {
            BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => the partnerLink cannot be null or empty")));
        }
        if (this.message.getOperation() == null || this.message.getOperation().trim().length() == 0) {
            BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => the operation cannot be null or empty")));
        }
        if (this.message.getInputVariable() == null || this.message.getInputVariable().trim().length() == 0) {
            BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => the input variable cannot be null or empty")));
        }
        if (this.message.getPartnerLink() != null && this.message.getPartnerLink().trim().length() > 0) {
            PartnerLink partnerLink = ScopeUtil.findPartnerLinkRecursively(this.message.getPartnerLink(), (BPELElement)((Object)((BPELElementImpl)((Object)this.message)).getParent()));
            if (partnerLink == null) {
                BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => Impossible to find partnerLink corresponding to the name: " + this.message.getPartnerLink())));
            }
            if (this.message.getOperation() != null && this.message.getOperation().trim().length() > 0 && partnerLink != null) {
                BPELProcess process = ScopeUtil.getProcess(this.message);
                ArrayList<Interface> itfsToVerify = new ArrayList<Interface>();
                if (this.message.getInterface() != null) {
                    Interface itf = process.getImports().findInterface(this.message.getInterface());
                    if (itf != null) {
                        itfsToVerify.add(itf);
                    }
                } else {
                    Interface itf;
                    PartnerLinkType plt = process.getImports().getPartnerLinkType(partnerLink.getPartnerLinkType());
                    if (!(partnerLink.getMyRole() != null && partnerLink.getMyRole().trim().length() != 0 || partnerLink.getPartnerRole() != null && partnerLink.getPartnerRole().trim().length() != 0)) {
                        for (Role r : plt.getRoles()) {
                            itf = process.getImports().findInterface(r.getInterfaceQName());
                            if (itf == null) {
                                BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => Impossible to find in wsdl descriptions the portType corresponding to role: " + r.getName())));
                            }
                            if (itf == null) continue;
                            itfsToVerify.add(itf);
                        }
                    } else {
                        if (partnerLink.getMyRole() != null && partnerLink.getMyRole().trim().length() > 0) {
                            for (Role r : plt.getRoles()) {
                                itf = process.getImports().findInterface(r.getInterfaceQName());
                                if (itf == null) {
                                    BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => Impossible to find in wsdl descriptions the portType corresponding to role: " + r.getName())));
                                }
                                if (!r.getName().equals(partnerLink.getMyRole()) || itf == null) continue;
                                itfsToVerify.add(itf);
                                break;
                            }
                        }
                        if (partnerLink.getPartnerRole() != null && partnerLink.getPartnerRole().trim().length() > 0) {
                            for (Role r : plt.getRoles()) {
                                if (!r.getName().equals(partnerLink.getPartnerRole())) continue;
                                itf = process.getImports().findInterface(r.getInterfaceQName());
                                itfsToVerify.add(itf);
                                break;
                            }
                        }
                    }
                }
                ArrayList<Operation> ops = new ArrayList<Operation>();
                if (itfsToVerify.size() == 0) {
                    if (this.message.getInterface() != null) {
                        BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => Impossible to find in wsdl descriptions the portType: " + this.message.getInterface())));
                    } else {
                        BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => Impossible to find portType. You must add portType attribute in receive or add a role to the partnerLink of receive")));
                    }
                }
                for (Interface itf : itfsToVerify) {
                    Operation op = itf.getOperation(new QName(itf.getQName().getNamespaceURI(), this.message.getOperation()));
                    if (op == null) continue;
                    ops.add(op);
                }
                if (ops.size() == 0) {
                    BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => Impossible to find in wsdl descriptions the operation: " + this.message.getOperation())));
                } else if (ops.size() > 1) {
                    String itfString = null;
                    for (Operation op : ops) {
                        itfString = itfString == null ? op.getParentInterface().getQName().toString() : String.valueOf(itfString) + ", " + op.getParentInterface().getQName().toString();
                    }
                    BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => Several interfaces match with the operation " + this.message.getOperation() + ": " + itfString + ". " + "You must add portType attribute in receive or add a role to the partnerLink of receive")));
                }
            }
        }
        if (this.message.getInputVariable() != null && this.message.getInputVariable().trim().length() > 0 && (var = ScopeImpl.findVariableRecursively(new QName(this.message.getInputVariable()), (BPELElement)((Object)((BPELElementImpl)((Object)this.message)).getParent()))) == null) {
            BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => Impossible to find input variable corresponding to the name: " + this.message.getInputVariable())));
        }
    }
}

