/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.runtime;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.From;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.FromAndTo;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.To;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.MessageUtil;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariableImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.exception.SelectionFailureException;
import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTStart;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTXpathExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ExpressionAnalyzer;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ExpressionDumpVisitor;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ExpressionVisitor;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ParseException;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.util.ExpressionUtil;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.util.JDomAnalyzer;
import com.ebmwebsourcing.easycommons.xml.QNameHelper;
import com.ebmwebsourcing.easyschema.xsd2xml.XSD2XML;
import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Assigner;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.wsstar.addressing.definition.WSAddressingFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.absitf.AbsItfEndpointReferenceType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.commons.lang.NotImplementedException;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.DOMOutputter;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.petalslink.abslayer.service.api.Endpoint;
import org.xml.sax.InputSource;

public class BPELAssigner
implements Assigner {
    private Logger log = Logger.getLogger(BPELAssigner.class.getName());
    private final Descriptions desc;
    private final BPELProcess bpeldefinition;
    private final Map<QName, com.ebmwebsourcing.easyschema10.api.element.Element> schemaElementsCache = new HashMap<QName, com.ebmwebsourcing.easyschema10.api.element.Element>();

    public BPELAssigner(BPELProcess bpeldefinition) {
        this.desc = bpeldefinition.getImports();
        this.bpeldefinition = bpeldefinition;
    }

    @Override
    public void setLog(Logger logger) {
        this.log = logger;
    }

    @Override
    public Expression affect(Scope scope, Expression left, Expression right) throws CoreException {
        Variable v = null;
        try {
            this.log.finest("affect " + right + " in " + left);
            Element leftSide = null;
            Element rightSide = null;
            if (!(left instanceof To)) {
                throw new BPELException("Incorrect affectation !!!");
            }
            if (!(right instanceof From)) {
                throw new BPELException("Incorrect affectation !!!");
            }
            To to = (To)left;
            From from = (From)right;
            v = to.getKind() == FromAndTo.Kind.PARTNERLINK || from.getKind() == FromAndTo.Kind.PARTNERLINK ? this.affectPartner(scope, leftSide, rightSide, to, from) : this.affectVariable(scope, leftSide, rightSide, to, from);
        }
        catch (BPELException e) {
            throw new CoreException(e);
        }
        return v;
    }

    private Variable affectPartner(Scope scope, Element leftSide, Element rightSide, To to, From from) throws CoreException {
        Variable v = null;
        try {
            PartnerLink partner = null;
            v = this.findVariable(scope, to);
            if (v == null && to.getKind() == FromAndTo.Kind.PARTNERLINK && (partner = this.findPartner(scope, to.getPartnerLinkVar().getPartnerLink(), this.bpeldefinition)) == null) {
                throw new CoreException("Impossible to find the partner: " + to.getPartnerLinkVar().getPartnerLink());
            }
            if (v == null && partner == null) {
                throw new CoreException("Impossible to find variable or partner");
            }
            AbsItfEndpointReferenceType eprFrom = null;
            if (from.getKind() == FromAndTo.Kind.LITERAL) {
                if (from.getLiteral().getElementContent() != null) {
                    this.log.finest("litteral content = " + from.getLiteral().getElementContent());
                } else {
                    this.log.finest("litteral content = " + from.getLiteral().getStringContent());
                }
                SAXBuilder builder = new SAXBuilder();
                Element root = null;
                if (from.getLiteral().getElementContent() != null) {
                    eprFrom = this.getEpr((Element)((Element)from.getLiteral().getElementContent().getChildren().get(0)).detach());
                } else if (from.getLiteral().getStringContent() != null) {
                    Document doc = builder.build(new ByteArrayInputStream(from.getLiteral().getStringContent().getBytes()));
                    root = (Element)((Element)doc.getRootElement().getChildren().get(0)).clone();
                    eprFrom = this.getEpr(root);
                } else {
                    eprFrom = WSAddressingFactory.getInstance().newEndpointReferenceType();
                }
            } else if (from.getKind() == FromAndTo.Kind.EXPRESSION || from.getKind() == FromAndTo.Kind.VARIABLE_PART) {
                ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer("");
                String expression = "";
                if (from.getKind() == FromAndTo.Kind.EXPRESSION) {
                    expression = (String)from.getContent();
                } else if (from.getKind() == FromAndTo.Kind.VARIABLE_PART) {
                    expression = ExpressionUtil.convertVariable2Expression(from.getVariablePart());
                }
                expression = expression.trim();
                this.log.finest("expression from  = " + expression);
                expressionAnalyzer.ReInit(new ByteArrayInputStream(expression.getBytes()));
                ASTStart n = expressionAnalyzer.Start();
                ExpressionDumpVisitor ev = new ExpressionDumpVisitor(scope, this.bpeldefinition, null);
                if (!this.log.getName().equals(BPELAssigner.class.getName())) {
                    ev.setLog(this.log);
                }
                if ((rightSide = n.jjtAccept(ev, null)) == null) {
                    throw new BPELException("Impossible to find right side element from expression: " + expression);
                }
                this.log.finest("rightSide = " + rightSide);
                eprFrom = rightSide.getChildren().size() > 0 ? this.getEpr((Element)((Element)rightSide.getChildren().get(0)).clone()) : WSAddressingFactory.getInstance().newEndpointReferenceType();
            } else if (from.getKind() == FromAndTo.Kind.PARTNERLINK) {
                PartnerLink partnerFrom = this.findPartner(scope, from.getPartnerLinkVar().getPartnerLink(), this.bpeldefinition);
                if (partnerFrom == null) {
                    throw new CoreException("Impossible to find the partner");
                }
                com.ebmwebsourcing.easyviper.core.api.soa.Endpoint ep = scope.getEndpoints().get(partnerFrom);
                if (ep == null) {
                    throw new CoreException("Impossible to find the endpoint");
                }
                eprFrom = WSAddressingFactory.getInstance().newEndpointReferenceType();
                eprFrom.setAddress(ep.getEndpointName());
            }
            if (eprFrom == null) {
                throw new BPELException("Impossible to find epr in part from");
            }
            Endpoint defEp = this.bpeldefinition.getImports().findEndpoint(eprFrom.getAddress().trim());
            EndpointReferenceType eprTo = null;
            if (v != null) {
                eprTo = v.getValue().getContent() != null ? this.getEpr((Element)v.getValue().getContent()) : WSAddressingFactory.getInstance().newEndpointReferenceType();
                if (defEp != null) {
                    eprTo.setAddress(defEp.getAddress());
                } else {
                    eprTo.setAddress(eprFrom.getAddress().trim());
                }
                String eprToBuffer = WSAddressingFactory.getInstance().newWSAddressingWriter().writeEndpointReferenceType(eprTo);
                if (v.getValue().getContent() != null) {
                    ((Element)v.getValue().getContent()).removeContent();
                    JDomAnalyzer jdomAnalyzer = new JDomAnalyzer(new InputSource(new ByteArrayInputStream(eprToBuffer.getBytes())));
                    ((Element)v.getValue().getContent()).getChildren().add(jdomAnalyzer.getDocument().clone());
                } else {
                    Element serviceRef = new Element("service-ref", Namespace.getNamespace("s-ref", "http://docs.oasis-open.org/wsbpel/2.0/serviceref"));
                    Document doc = new Document();
                    doc.setRootElement(serviceRef);
                    JDomAnalyzer jdomAnalyzer = new JDomAnalyzer(new InputSource(new ByteArrayInputStream(eprToBuffer.getBytes())));
                    serviceRef.getChildren().add(jdomAnalyzer.getDocument().clone());
                    v.getValue().setContent(serviceRef);
                }
            } else if (partner != null) {
                com.ebmwebsourcing.easyviper.core.api.soa.Endpoint ep = scope.findEndpoint(partner);
                if (eprFrom.getAddress() != null) {
                    if (defEp != null) {
                        ep.setEndpointName(defEp.getName());
                        ep.setServiceName(defEp.getService().getQName());
                        ep.setAddress(defEp.getAddress());
                    } else {
                        ep.setAddress(eprFrom.getAddress().trim());
                    }
                } else {
                    ep.setEndpointName(null);
                    ep.setServiceName(null);
                    ep.setAddress(null);
                }
                this.log.finest("endpoint of partner " + partner.getName() + " set at : " + ep.getEndpointName());
            }
        }
        catch (IOException e) {
            throw new CoreException(e);
        }
        catch (JDOMException e) {
            throw new CoreException(e);
        }
        catch (WSAddressingException e) {
            throw new CoreException(e);
        }
        catch (BPELException e) {
            throw new CoreException(e);
        }
        catch (ParseException e) {
            throw new CoreException(e);
        }
        return v;
    }

    private EndpointReferenceType getEpr(Element root) throws CoreException {
        EndpointReferenceType epr = null;
        try {
            Document eprjDom = new Document((Element)root.clone());
            DOMOutputter converter = new DOMOutputter();
            org.w3c.dom.Document eprDom = converter.output(eprjDom);
            epr = WSAddressingFactory.getInstance().newWSAddressingReader().readEndpointReferenceType(eprDom);
        }
        catch (JDOMException e) {
            throw new CoreException(e);
        }
        catch (WSAddressingException e) {
            throw new CoreException(e);
        }
        return epr;
    }

    private PartnerLink findPartner(Scope scope, String partnerLink, BPELProcess bpeldefinition) throws CoreException {
        PartnerLink pl = bpeldefinition.getPartnerLink(partnerLink);
        return pl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Variable affectVariable(Scope scope, Element leftSide, Element rightSide, To to, From from) throws BPELException {
        Variable v = null;
        try {
            ExpressionDumpVisitor ev;
            ASTStart n;
            String expression;
            v = this.findVariable(scope, to);
            MessageUtil.createMessageIfNotExist(v, this.desc, BPELFactoryImpl.getCore().getMessageFactory());
            this.log.finest("message created: \n" + new XMLOutputter(Format.getPrettyFormat()).outputString((Element)v.getValue().getContent()));
            ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer("");
            if (to.getKind() == FromAndTo.Kind.EXPRESSION || to.getKind() == FromAndTo.Kind.VARIABLE_PART) {
                expression = "";
                if (to.getKind() == FromAndTo.Kind.EXPRESSION) {
                    expression = ((String)to.getContent()).trim();
                } else if (to.getKind() == FromAndTo.Kind.VARIABLE_PART) {
                    expression = ExpressionUtil.convertVariable2Expression(to.getVariablePart());
                }
                this.log.finest("expression to  = " + expression);
                expressionAnalyzer.ReInit(new ByteArrayInputStream(expression.getBytes()));
                n = expressionAnalyzer.Start();
                ev = new ExpressionDumpVisitor(scope, this.bpeldefinition, null);
                if (!this.log.getName().equals(BPELAssigner.class.getName())) {
                    ev.setLog(this.log);
                }
                XPathExpressionException ex = null;
                try {
                    leftSide = n.jjtAccept(ev, null);
                }
                catch (XPathExpressionException e) {
                    ex = e;
                }
                this.log.finest("leftSide = " + leftSide);
                if (leftSide == null && n.jjtGetChild(0) instanceof ASTXpathExpression) {
                    this.log.finest("leftSide == null => try to add nillable or array element");
                    this.addNecessaryMinOccursEqual0ElementOrEmptyArrayElement(expressionAnalyzer, expression, ev);
                    expressionAnalyzer.ReInit(new ByteArrayInputStream(expression.getBytes()));
                    n = expressionAnalyzer.Start();
                    ev = new ExpressionDumpVisitor(scope, this.bpeldefinition, null);
                    if (!this.log.getName().equals(BPELAssigner.class.getName())) {
                        ev.setLog(this.log);
                    }
                    leftSide = n.jjtAccept(ev, null);
                }
                if (leftSide == null) {
                    SelectionFailureException selectionFailureException = null;
                    selectionFailureException = ex != null ? new SelectionFailureException("Impossible to find element corresponding to " + expression, ex) : new SelectionFailureException("Impossible to find element corresponding to " + expression);
                    throw selectionFailureException;
                }
            } else {
                throw new NotImplementedException();
            }
            this.log.finest("leftSide = \n" + new XMLOutputter(Format.getPrettyFormat()).outputString(leftSide));
            if (from.getKind() == FromAndTo.Kind.LITERAL) {
                if (from.getLiteral().getElementContent() != null) {
                    rightSide = (Element)from.getLiteral().getElementContent().detach();
                } else if (from.getLiteral().getStringContent() != null) {
                    rightSide = new Element("literal");
                    rightSide.setText(from.getLiteral().getStringContent().trim());
                }
            } else if (from.getKind() == FromAndTo.Kind.EXPRESSION || from.getKind() == FromAndTo.Kind.VARIABLE_PART) {
                expression = "";
                if (from.getKind() == FromAndTo.Kind.EXPRESSION) {
                    expression = ((String)from.getContent()).trim();
                } else if (from.getKind() == FromAndTo.Kind.VARIABLE_PART) {
                    expression = ExpressionUtil.convertVariable2Expression(from.getVariablePart());
                }
                this.log.finest("expression from  = " + expression);
                expressionAnalyzer.ReInit(new ByteArrayInputStream(expression.getBytes()));
                n = expressionAnalyzer.Start();
                ev = new ExpressionDumpVisitor(scope, this.bpeldefinition, null);
                if (!this.log.getName().equals(BPELAssigner.class.getName())) {
                    ev.setLog(this.log);
                }
                rightSide = n.jjtAccept(ev, null);
                this.log.finest("rightSide = " + rightSide);
                if (rightSide == null) {
                    throw new SelectionFailureException("Impossible to find right side element from expression: " + expression);
                }
                this.log.finest("rightSide = \n" + new XMLOutputter(Format.getPrettyFormat()).outputString(rightSide));
            } else {
                if (from.getKind() == FromAndTo.Kind.VARIABLE_PART) {
                    throw new NotImplementedException("Affectation using variable not implemented: Use affectation by expression");
                }
                throw new NotImplementedException();
            }
            this.log.finest("Assigment : enter MUTEX LEFT section on variable " + leftSide.getName() + " from " + Thread.currentThread().getName());
            Element element = leftSide;
            synchronized (element) {
                this.log.finest("Assigment : enter MUTEX RIGHT section on variable " + rightSide.getName() + " from " + Thread.currentThread().getName());
                Element element2 = rightSide;
                synchronized (element2) {
                    Attribute workOnAttribute = leftSide.getAttribute("workOnAttribute", Namespace.getNamespace("meta_ebm", "http://com.ebmwebsourcing.easybpel/metadata"));
                    if (workOnAttribute != null) {
                        String attributeName = QNameHelper.getLocalPartWithoutPrefix(workOnAttribute.getValue());
                        String prefix = QNameHelper.getPrefix(workOnAttribute.getValue());
                        Namespace nsAttr = null;
                        if (prefix != null && prefix.trim().length() > 0) {
                            String ns = this.bpeldefinition.getNamespaceContext().getNamespaceURI(prefix);
                            nsAttr = Namespace.getNamespace(prefix, ns);
                        }
                        Attribute leftAttribute = null;
                        leftAttribute = nsAttr != null ? leftSide.getAttribute(attributeName, nsAttr) : leftSide.getAttribute(attributeName);
                        if (leftAttribute == null) {
                            throw new BPELException("this attibute: " + attributeName + " is not created because it is optional. You must force it to be required for the moment.");
                        }
                        leftAttribute.setValue(this.affectTextElementOrAttributeValueInRightSide(rightSide));
                        leftSide.removeAttribute(workOnAttribute);
                    } else {
                        leftSide.removeContent();
                        leftSide.setText(null);
                        if (rightSide.getChildren() != null && rightSide.getChildren().size() > 0) {
                            List rootAttrs = rightSide.getAttributes();
                            if (rootAttrs != null) {
                                for (Attribute at : rootAttrs) {
                                    Attribute a = ((Attribute)at.clone()).detach();
                                    if (leftSide.getAttribute(a.getName()) != null) {
                                        leftSide.getAttribute(a.getName()).setValue(a.getValue());
                                        continue;
                                    }
                                    leftSide.setAttribute(a);
                                }
                            }
                            Element rightTemp = (Element)((Element)rightSide.clone()).detach();
                            for (Element child : rightTemp.getChildren()) {
                                leftSide.addContent(((Element)child.clone()).detach());
                            }
                        } else {
                            leftSide.setText(this.affectTextElementOrAttributeValueInRightSide(rightSide));
                        }
                    }
                }
                this.log.finest("Assigment : enter MUTEX RIGHT section on variable " + rightSide.getName() + " from " + Thread.currentThread().getName());
            }
            this.log.finest("Assigment : exit MUTEX LEFT section on variable " + leftSide.getName() + " from " + Thread.currentThread().getName());
            this.log.finest("final " + v.getQName() + " variable value: \n" + v.getValue());
        }
        catch (ParseException e) {
            throw new BPELException("Impossible to realize the following assignment: " + to + " = " + from, e);
        }
        catch (BPELException e) {
            throw new BPELException("Impossible to realize the following assignment: " + to + " = " + from, e);
        }
        catch (CoreException e) {
            throw new BPELException("Impossible to realize the following assignment: " + to + " = " + from, e);
        }
        return v;
    }

    private Element addNecessaryMinOccursEqual0ElementOrEmptyArrayElement(ExpressionAnalyzer expressionAnalyzer, String expression, ExpressionVisitor ev) throws BPELException {
        Element res;
        block19: {
            res = null;
            try {
                Element parent = null;
                boolean isArray = false;
                if (expression.lastIndexOf("/") > 0) {
                    String parentExpression = expression.substring(0, expression.lastIndexOf("/"));
                    String childElement = expression.substring(expression.lastIndexOf("/") + 1, expression.length());
                    String currentExpression = parentExpression;
                    while (childElement.startsWith("@") && currentExpression.lastIndexOf("/") > -1) {
                        if (currentExpression.lastIndexOf("/") <= -1) continue;
                        parentExpression = currentExpression.substring(0, currentExpression.lastIndexOf("/"));
                        childElement = currentExpression.substring(currentExpression.lastIndexOf("/") + 1, currentExpression.length());
                        currentExpression = parentExpression;
                    }
                    if (childElement.indexOf("[") > 0) {
                        childElement = childElement.substring(0, childElement.indexOf("["));
                        isArray = true;
                    }
                    this.log.finest("parent expression = " + parentExpression);
                    this.log.finest("childElement = " + childElement);
                    expressionAnalyzer.ReInit(new ByteArrayInputStream(parentExpression.getBytes()));
                    ASTStart n = expressionAnalyzer.Start();
                    parent = n.jjtAccept(ev, null);
                    if (parent == null) {
                        parent = this.addNecessaryMinOccursEqual0ElementOrEmptyArrayElement(expressionAnalyzer, parentExpression, ev);
                    }
                    if (parent == null) {
                        throw new BPELException("Impossible to find parent");
                    }
                    String prefix = QNameHelper.getPrefix(childElement);
                    String localName = QNameHelper.getLocalPartWithoutPrefix(childElement);
                    String ns = null;
                    QName qn = null;
                    if (prefix != null) {
                        ns = this.bpeldefinition.getNamespaceContext().getNamespaceURI(prefix);
                        qn = new QName(ns, localName, prefix);
                    } else {
                        ns = parent.getDocument().getRootElement().getNamespaceURI();
                        qn = new QName(ns, localName);
                    }
                    com.ebmwebsourcing.easyschema10.api.element.Element schemaElement = this.getSchemaElement(qn, this.bpeldefinition.getImports());
                    if (schemaElement == null) {
                        throw new BPELException("Impossible to find child in all definitions: " + qn);
                    }
                    if (schemaElement.getMinOccurs() == 0 || isArray) {
                        this.log.finest("create optional child or new item of array: " + schemaElement);
                        parent = XSD2XML.newInstance().addMinOccursEqual0OrArrayElement(schemaElement, SchemaHelper.findParentSchema(schemaElement), parent);
                        if (parent.getChildren(schemaElement.getName(), Namespace.getNamespace(schemaElement.inferQName().getNamespaceURI())).size() > 0) {
                            res = (Element)parent.getChildren(schemaElement.getName(), Namespace.getNamespace(schemaElement.inferQName().getNamespaceURI())).get(0);
                        }
                        if (res == null && parent.getChildren(schemaElement.getName()).size() > 0) {
                            res = (Element)parent.getChildren(schemaElement.getName()).get(0);
                        }
                        if (res == null) {
                            res = parent;
                        }
                    } else {
                        this.log.finest("child already created: " + schemaElement);
                        if (parent.getChildren(schemaElement.getName(), Namespace.getNamespace(schemaElement.inferQName().getNamespaceURI())).size() > 0) {
                            res = (Element)parent.getChildren(schemaElement.getName(), Namespace.getNamespace(schemaElement.inferQName().getNamespaceURI())).get(0);
                        }
                        if (res == null && parent.getChildren(schemaElement.getName()).size() > 0) {
                            res = (Element)parent.getChildren(schemaElement.getName()).get(0);
                        }
                        if (res == null) {
                            res = parent;
                        }
                    }
                    this.log.finest("parent expression complet = " + parentExpression);
                    this.log.finest("childElement complet = " + childElement);
                    break block19;
                }
                throw new BPELException("Impossible to find element from expression: " + expression);
            }
            catch (ParseException e) {
                throw new BPELException(e);
            }
            catch (XPathExpressionException e) {
                throw new BPELException(e);
            }
        }
        return res;
    }

    private final com.ebmwebsourcing.easyschema10.api.element.Element getSchemaElement(QName qname, Descriptions imports) {
        com.ebmwebsourcing.easyschema10.api.element.Element schemaElement = this.schemaElementsCache.get(qname);
        if (schemaElement != null) {
            return schemaElement;
        }
        List<com.ebmwebsourcing.easyschema10.api.element.Element> childs = imports.findElementsInAllSchema(qname);
        if (childs == null || childs.size() == 0) {
            return null;
        }
        schemaElement = childs.get(0);
        this.schemaElementsCache.put(qname, schemaElement);
        return schemaElement;
    }

    private String affectTextElementOrAttributeValueInRightSide(Element rightSide) {
        String value = "";
        Attribute workOnAttribute = rightSide.getAttribute("workOnAttribute", Namespace.getNamespace("meta_ebm", "http://com.ebmwebsourcing.easybpel/metadata"));
        if (workOnAttribute != null) {
            String attributeName = QNameHelper.getLocalPartWithoutPrefix(workOnAttribute.getValue());
            String prefix = QNameHelper.getPrefix(workOnAttribute.getValue());
            Namespace nsAttr = null;
            if (prefix != null && prefix.trim().length() > 0) {
                String ns = this.bpeldefinition.getNamespaceContext().getNamespaceURI(prefix);
                nsAttr = Namespace.getNamespace(prefix, ns);
            }
            Attribute rightAttribute = null;
            rightAttribute = nsAttr != null ? rightSide.getAttribute(attributeName, nsAttr) : rightSide.getAttribute(attributeName);
            rightSide.removeAttribute(workOnAttribute);
            value = rightAttribute.getValue();
        } else {
            value = rightSide.getText();
        }
        return value;
    }

    private Variable findVariable(Scope scope, FromAndTo to) throws CoreException {
        Variable v = null;
        String variableName = null;
        if (to.getKind() != FromAndTo.Kind.PARTNERLINK) {
            if (to.getKind() == FromAndTo.Kind.EXPRESSION) {
                variableName = BPELVariableImpl.getVariableNameInXPathExpression((String)to.getContent());
            } else if (to.getKind() == FromAndTo.Kind.VARIABLE_PART) {
                variableName = to.getVariablePart().getVariable().getLocalPart();
            }
            variableName = variableName.trim();
            this.log.finest("find variable " + variableName);
            v = scope.findVariable(new QName(QNameHelper.getLocalPartWithoutPrefix(variableName)));
            if (v == null) {
                throw new CoreException("Error: impossible to find the variable: " + variableName);
            }
        }
        return v;
    }
}

