/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.runtime;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.From;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.To;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.CorrelationSet;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TQuery;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.QueryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.VariablePartImpl;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTStart;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ExpressionAnalyzer;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ExpressionDumpVisitor;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ParseException;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.util.ExpressionUtil;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.Correlation;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationGroup;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationMatcher;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jdom.Element;
import org.ow2.easywsdl.schema.api.extensions.NamespaceMapperImpl;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Property;
import org.petalslink.abslayer.service.api.PropertyAlias;

public class BPELCorrelationMatcher
implements CorrelationMatcher {
    private Logger log = Logger.getLogger(BPELCorrelationMatcher.class.getName());
    private final Descriptions desc;
    private final BPELProcess bpeldefinition;
    private final List<com.ebmwebsourcing.easybpel.model.bpel.api.correlation.Correlation> correlations;
    private QName variableToCorrelate = null;

    public BPELCorrelationMatcher(BPELProcess bpeldefinition, List<com.ebmwebsourcing.easybpel.model.bpel.api.correlation.Correlation> correlations, QName inputVariable) {
        this.desc = bpeldefinition.getImports();
        this.bpeldefinition = bpeldefinition;
        this.correlations = correlations;
        this.variableToCorrelate = inputVariable;
    }

    public void setLog(Logger logger) {
        this.log = logger;
    }

    @Override
    public boolean match(Scope scope, QName variableName, InternalMessage<?> message) throws CoreException {
        boolean res = false;
        try {
            if (this.variableToCorrelate.equals(variableName)) {
                BPELVariable varFrom = (BPELVariable)scope.findVariable(this.variableToCorrelate);
                if (varFrom == null) {
                    throw new CoreException("Impossible to find variable corresponding to this name " + this.variableToCorrelate);
                }
                List<Object> correlationGroups = new ArrayList();
                if (this.correlations != null) {
                    this.log.finest("get specific correlations");
                    for (com.ebmwebsourcing.easybpel.model.bpel.api.correlation.Correlation correlation : this.correlations) {
                        correlationGroups.addAll(scope.findCorrelationGroups(correlation.getSet()));
                    }
                } else {
                    this.log.finest("get global correlations on the scope: " + scope.getName());
                    correlationGroups = scope.getProcess().getCorrelationGroups();
                }
                this.log.finest("correlationGroups size: " + correlationGroups.size());
                if (correlationGroups.size() > 0) {
                    for (CorrelationGroup correlationGroup : correlationGroups) {
                        for (Map.Entry<String, Correlation> correlation : correlationGroup.getCorrelations().entrySet()) {
                            CorrelationSet correlationSet = this.bpeldefinition.getCorrelationSet(correlation.getKey());
                            if (correlationSet == null) {
                                throw new CoreException("Impossible to find the correlation set corresponding to this name " + correlation.getKey());
                            }
                            this.log.finest("control correlation: " + correlationSet.getName());
                            List<QName> propertiesName = correlationSet.getProperties();
                            for (QName propertyName : propertiesName) {
                                Property prop = this.desc.getProperty(propertyName);
                                if (prop == null) {
                                    throw new BPELException("Impossible to find property corresponding to this name " + propertyName);
                                }
                                Correlation corr = correlation.getValue();
                                To to = (To)corr.getOriginator();
                                Variable varTo = scope.findVariable(new QName(to.getVariableProperty().getVariable()));
                                if (varTo == null) {
                                    throw new CoreException("Impossible to find variable corresponding to this name " + to.getVariableProperty().getVariable());
                                }
                                From from = (From)corr.getFollower();
                                PropertyAlias propAliasTo = this.findCorrespondingPropertiesAlias(prop.getQName(), (BPELVariable)varTo);
                                if (propAliasTo == null) {
                                    throw new BPELException("Error to correlate initial variable with property: " + prop.getQName());
                                }
                                TQuery queryTo = new TQuery();
                                queryTo.getContent().add(propAliasTo.getQuery().getContentString());
                                queryTo.setQueryLanguage(propAliasTo.getQuery().getQueryLanguage());
                                VariablePartImpl vTO = new VariablePartImpl(new QName(to.getVariableProperty().getVariable()), propAliasTo.getPart(), new QueryImpl(queryTo, to));
                                PropertyAlias propAliasFrom = this.findCorrespondingPropertiesAlias(prop.getQName(), varFrom);
                                if (propAliasFrom == null) {
                                    throw new BPELException("Error to correlate final variable with property: " + prop.getQName());
                                }
                                TQuery queryFrom = new TQuery();
                                queryFrom.getContent().add(propAliasFrom.getQuery().getContentString());
                                queryFrom.setQueryLanguage(propAliasFrom.getQuery().getQueryLanguage());
                                VariablePartImpl vFrom = new VariablePartImpl(this.variableToCorrelate, propAliasFrom.getPart(), new QueryImpl(queryFrom, from));
                                varFrom.setValue(message);
                                String expressionTo = ExpressionUtil.convertVariable2Expression(vTO);
                                String expressionFrom = ExpressionUtil.convertVariable2Expression(vFrom);
                                String conditionnalExpression = String.valueOf(expressionTo) + "=" + expressionFrom;
                                this.log.finest("Correlation conditional expression found: " + conditionnalExpression);
                                Description descTo = propAliasTo.getParentDescription();
                                Description descFrom = propAliasFrom.getParentDescription();
                                NamespaceMapperImpl nsList = new NamespaceMapperImpl();
                                for (Map.Entry<String, String> entry : descTo.getNamespaces().entrySet()) {
                                    nsList.addNamespace(entry.getKey(), entry.getValue());
                                }
                                for (Map.Entry<String, String> entry : descFrom.getNamespaces().entrySet()) {
                                    if (nsList.getNamespaceURI(entry.getKey()) != null && !nsList.getNamespaceURI(entry.getKey()).equals(entry.getValue())) {
                                        throw new UnsupportedOperationException("Prefix collision.");
                                    }
                                    nsList.addNamespace(entry.getKey(), entry.getValue());
                                }
                                ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(conditionnalExpression);
                                ASTStart n = expressionAnalyzer.Start();
                                ExpressionDumpVisitor ev = new ExpressionDumpVisitor(scope, this.bpeldefinition, nsList);
                                if (!this.log.getName().equals(BPELCorrelationMatcher.class.getName())) {
                                    ev.setLog(this.log);
                                }
                                Element condition = n.jjtAccept(ev, null);
                                this.log.finest("condition = " + condition.getText());
                                if (condition.getText().equals("true")) {
                                    res = true;
                                    continue;
                                }
                                res = false;
                                varFrom.setValue(null);
                            }
                        }
                    }
                } else {
                    res = true;
                }
            }
        }
        catch (BPELException e) {
            throw new CoreException(e);
        }
        catch (ParseException e) {
            throw new CoreException(e);
        }
        return res;
    }

    private PropertyAlias findCorrespondingPropertiesAlias(QName propertyName, BPELVariable var) throws BPELException {
        PropertyAlias res = null;
        List<PropertyAlias> propertiesAliases = this.desc.getPropertyAliases4ThisProperty(propertyName);
        if (propertiesAliases != null) {
            for (PropertyAlias propertyAlias : propertiesAliases) {
                boolean correlationMatching = false;
                if (propertyAlias.getElement() != null && propertyAlias.getElement().equals(var.getElement())) {
                    correlationMatching = true;
                } else if (propertyAlias.getMessageType() != null && propertyAlias.getMessageType().equals(var.getMessageType())) {
                    correlationMatching = true;
                } else if (propertyAlias.getType() != null && propertyAlias.getType().equals(var.getTypeQName())) {
                    correlationMatching = true;
                }
                if (!correlationMatching) continue;
                res = propertyAlias;
                break;
            }
        }
        return res;
    }
}

